define('tmatesoft/svn/views/repository-item-provider', [], function() {
    'use strict';

    function RepositoryItemProvider() {};

    RepositoryItemProvider.prototype.getItems = function(model) {
        var items = model.get('children');
        var result = [];
        for(var key in items) {
            if (items.hasOwnProperty(key)) {
                result.push(items[key].scope.id);
            }
        }
        return result;
    };

    RepositoryItemProvider.prototype.compare = function(model, id1, id2) {
        var item1 = model.get('children.' + id1 + '.data');
        var item2 = model.get('children.' + id2 + '.data');

        var projectName1 = item1.projectName;
        var projectName2 = item2.projectName;
        if (projectName1 !== projectName2) {
            return projectName1 > projectName2 ? 1 : -1;
        }
        var repositoryName1 = item1.repositoryName;
        var repositoryName2 = item2.repositoryName;
        if (repositoryName1 !== repositoryName2) {
            return repositoryName1 > repositoryName2 ? 1 : -1;
        }
        return 0;
    };

    RepositoryItemProvider.prototype.update = function(event) {
        var delta = {};
        event.changed('children.', function(previous, current, key) {
            if (!previous && current) {
                delta.added = delta.added || [];
                delta.added.push(current.scope.id);
            } else if (!current && previous) {
                delta.removed = delta.removed || [];
                delta.removed.push(previous.scope.id);
            }
        });
        return delta;
    };

    return RepositoryItemProvider;
});