define('tmatesoft/svn/views/list-view', [
    'tmatesoft/engine-util'
], function(
    Util
) {
    'use strict';

    function ListView(options) {
        this.itemProvider = options.itemProvider;
        this.tagName = options.tagName || 'div';
        this.attrName = options.attrName || 'data-list-item-id';

        this.children = {};
        if (options.itemViewFactory) {
            this.children[this.tagName] = options.itemViewFactory;
        }
    };

    ListView.prototype.sortElements = function(model, $, el) {
        var comparator = this.itemProvider.compare;
        var order = this.sortOrder;
        var attrName = this.attrName;
        $(this.tagName).detach().sort(function(a, b) {
            var id1 = a.getAttribute(attrName);
            var id2 = b.getAttribute(attrName);
            return comparator(model, id1, id2);
        }).appendTo(el);
    };

    ListView.prototype.createElementHTML = function(id) {
        return '<' + this.tagName + ' ' + this.attrName + '=\"' + id + '\" />';
    };

    ListView.prototype.setup = function(model, el, $) {
        var itemIds = this.itemProvider.getItems(model);
        var html = '';
        for(var i = 0; i < itemIds.length; i++) {
            html += this.createElementHTML(itemIds[i]);
        }
        if (html !== '') {
            el.innerHTML = html;
            this.sortElements(model, $, el);
        }
    };

    ListView.prototype.update = function(event, el, $) {
        var updates = this.itemProvider.update(event);

        if (updates.added) {
            for(var i = 0; i < updates.added.length; i++) {
                var addedItemId = updates.added[i];
                var newElement = this.createElementHTML(addedItemId);
                $(el).append(newElement);
            }
        }

        if (updates.removed) {
            for(var i = 0; i < updates.removed.length; i++) {
                var removedItemId = updates.removed[i];
                $('[' + this.attrName + '="' + removedItemId + '"]').remove();
            }
        }

        if (updates.added || updates.removed || updates.modified) {
            this.sortElements(event.model, $, el);
        }
    };

    return ListView;
});