define('tmatesoft/svn', [
    'exports',
    'jquery',
    'tmatesoft/svnmirror/util/json',
    'tmatesoft/svn/views/root',
    'tmatesoft/svn/command-tracker',
    'tmatesoft/engine-jquery'
], function(
    exports,
    jQuery,
    json,
    RootView,
    CommandTracker,
    Controller) {

    exports.onReady = function(initialState) {
        jQuery('.aui-page-panel-content').css('position', 'relative');

        var commandTracker = new CommandTracker(json);
        var svnCtrl = new Controller(jQuery);
        svnCtrl.update(initialState);
        svnCtrl.addView(new RootView(commandTracker), document.querySelector('.aui-page-panel-content'));

        var connectionEstablished = false;
        var poller = commandTracker.createPoll(initialState.scope.id, initialState.data.longPollOptions,
            function(delta, isComplete) {
                connectionEstablished = true;
                svnCtrl.update(delta, isComplete);
            },
            function(logMessage) {
                if (!connectionEstablished) {
                    svnCtrl.update(logMessage, true);
                }
            });
        poller.poll();
    };
});