define('tmatesoft/svn/messages', [
    'exports'
], function(
    exports
) {

    'use strict';

    var formatFileSize = function(bytes) {
        var exp = Math.log(bytes) / Math.log(1024) | 0;
        var result = (bytes / Math.pow(1024, exp)).toFixed(2);

        return result + ' ' + (exp === 0 ? 'bytes' : 'kMGTPEZY'[exp - 1] + 'B');
    };

    var formatDateAndTime = function(time) {
        var date = new Date(time);
        return  date.getFullYear()
              +  '-'
              + ('0' + (date.getMonth() + 1)).slice(-2)
              +  '-'
              + ('0' + date.getDate()).slice(-2)
              + ' at '
              + formatTime(time);
    };

    var formatTime = function(time) {
        var date = new Date(time);
        return  ('0' + date.getHours()).slice(-2)
              +  ':'
              + ('0' + date.getMinutes()).slice(-2)
              +  ':'
              + ('0' + date.getSeconds()).slice(-2);
    };

    var getMessageForStage = function(item) {
        var message;
        var stage = item.data.stage;
        var pending = item.pending || [];
        if (stage === 'INSTALLED') {
            message = 'Idle';
        } else if (stage === 'PAUSED') {
            if (item.data.importRequested) {
                message = 'Import paused';
            } else {
                message = 'Synchronization disabled';
            }
        } else if (stage === 'CONFIGURED') {
            message = pending.length === 0 ?
                'Ready to start synchronization or import' :
                'Scheduling synchronization or import';
        } else if (stage === 'INITIAL') {
            message = pending.length === 0 ?
                'Ready to configure mirror or import ' :
                'Scheduling initial configuration';
        } else if (stage === 'PENDING_METADATA_MOVE') {
            message = 'Metadata upgrade is pending';
        } else if (stage === 'LEGACY') {
            message = 'Upgrade needed';
        } else if (stage === 'EXTERNAL_LOCAL' || stage === 'EXTERNAL_REMOTE') {
            message = 'Managed by external standalone SubGit tool';
        } else if (stage === 'UNKNOWN') {
            message = 'Unknown state';
        } else {
            message = '';
        }
        return message;
    };

    var getCommandFlagData = function(command, item) {
        if (!item) {
            return null;
        }
        var result = {};

        if (command.repositoryName) {
            result.title = command.projectName + ' / ' + command.repositoryName;
        } else if (command.projectName) {
            result.title = command.projectName + ' Settings';
        } else {
            result.title = 'Global Settings';
        }

        if (command.cancelled) {
            result.content = 'Operation has been cancelled';
        } else if (command.error) {
            result.title = 'Command Failed : ' + result.title;
            result.content = command.error;
        } else if (command.name === 'configure') {
            result.content = 'Initial configuration completed';
        } else if (command.name === 'start') {
            result.content = 'Synchronization enabled';
        } else if (command.name === 'start-import') {
            result.content = 'Import started';
        } else if (command.name === 'stop') {
            result.content = item.data.importRequested ? 'Import stopped' : 'Synchronization disabled';
        } else if (command.name === 'upgrade') {
            result.content = 'Mirror upgraded';
        } else if (command.name === 'refresh') {
            result.content = 'Bitbucket branches and tags refreshed';
        } else if (command.name === 'apply') {
            result.content = 'Configuration changes applied';
        } else if (command.name === 'unsynced-remove') {
            result.content = 'Unsynced reference removed';
        } else if (command.name === 'unsynced-restore') {
            result.content = 'Reference restore scheduled';
        } else if (command.name === 'uninstall') {
            if (item.data.stage === 'CONFIGURED') {
                result.content = 'Configuration reset';
            } else {
                result.content = 'Uninstall completed';
            }
        } else if (command.name === 'build-support-zip') {
            result.content = 'Support Zip Built';
        } else if (command.name === 'move-metadata') {
            result.content = 'Metadata upgraded';
        } else {
            return null;
        }
        return result;

    };

    var getConfirmationData = function(commandName, item) {
        var result = {};
        var isResumeImport = item.data.importRequested;

        if (commandName === 'start-import' && item.data.repositoryEmpty) {
            result.title = 'Start Import';
            result.content =
                   '<p>You are about to start import from Subversion into <strong>'
                 + item.data.projectName + ' / ' + item.data.repositoryName + '</strong>'
                 + ' repository.</p>'
                 + ' <p>Import is <strong>one-time</strong> operation that will'
                 + ' translate Subversion revisions into Git commits.'
                 + ' Upon import completion, <strong>synchronization will be disabled</strong>, until'
                 + ' you explicitly start&nbsp;it later.</p>'
                 + ' <p>Would you like to keep Subversion project and Git repository in sync,'
                 + ' use \'Mirror\' button to start synchronization.</p>';
            result.label = 'Start Import';
        } else if (commandName === 'start-import' && !item.data.repositoryEmpty) {
            result.title = isResumeImport ? 'Resume Import' : 'Start Import';
            result.content =
                   '<p>You are about to ' + (isResumeImport ? 'resume import' : 'start import') + ' into <strong>'
                 + item.data.projectName + ' / ' + item.data.repositoryName + '</strong>'
                 + ' repository.</p>'
                 + ' <p><strong>This repository is not empty.</strong> It may happen, that'
                 + ' branches and tags fetched from Subversion'
                 + ' repository will conflict with those currently present'
                 + ' in Git repository.</p>'
                 + ' <p>Conflicting Git branches and tags'
                 + ' will be moved to'
                 + ' <strong>subgit/unsynced</strong> namespace. As soon as import'
                 + ' is completed, you will be able to review those unsynced'
                 + ' branches and either restore them or remove them from the Git'
                 + ' repository.</p>';
            result.label = isResumeImport ? 'Resume Import' : 'Start Import';
        } else if (commandName === 'start' && !item.data.repositoryEmpty) {
            result.title = isResumeImport ? 'Resume Import' : 'Enable Synchronization';
            result.content =
                   '<p>You are about to ' + (isResumeImport ? 'resume import into' : 'enable synchronization for') + ' <strong>'
                 + item.data.projectName + ' / ' + item.data.repositoryName + '</strong>'
                 + ' repository.</p>'
                 + ' <p><strong>This repository is not empty.</strong> It may happen, that'
                 + ' branches and tags fetched from Subversion'
                 + ' repository will conflict with those currently present'
                 + ' in Git repository.</p>'
                 + ' <p>Conflicting Git branches and tags'
                 + ' will be moved to'
                 + ' <strong>subgit/unsynced</strong> namespace. As soon as ' + (isResumeImport ? 'import' : 'initial synchronization')
                 + ' is completed, you will be able to review those unsynced'
                 + ' branches and either restore them or remove them from the Git'
                 + ' repository.</p>';
            result.label = isResumeImport ? 'Resume Import' : 'Enable Synchronization';
        } else if (commandName === 'stop') {
            result.title = isResumeImport ? 'Stop Import' : 'Disable Synchronization';
            result.content =
                   '<p>You are about to ' + (isResumeImport ? 'stop import into' : 'disable synchronization for') + ' <strong>'
                 + item.data.projectName + ' / ' + item.data.repositoryName + '</strong>'
                 + ' repository.</p>';
            if (!isResumeImport) {
                 result.content += ' <p>As soon as synchronization is disabled, Git repository'
                                 + ' will no longer receive changes from Subversion, and commits'
                                 + ' pushed to Git repository will no longer be translated to'
                                 + ' Subversion repository.</p>';
                 }
            result.content +=
                   ' <p>You will be able to resume ' + (isResumeImport ? 'import' : 'synchronization') + ' later,'
                 + ' however, ' + (isResumeImport ? 'importing into' : 'synchronizing') + ' repository with history diverged may result in conflicts'
                 + ' that you will have to resolve.</p>';
            result.label = isResumeImport ? 'Stop Import' : 'Disable Synchronization';
        } else if (commandName === 'uninstall' && item.data.stage !== 'CONFIGURED') {
            result.title = 'Uninstall';
            result.content =
                   '<p>You are about to uninstall SVN Mirror from <strong>'
                 + item.data.projectName + ' / ' + item.data.repositoryName + '</strong>'
                 + ' repository.</p>'
                 + ' <p>This will not affect existing Git branches and tags.</p>'
                 + ' <p>All the synchronization meta information and configuration'
                 + ' will be removed. To re-enable synchronization later you will'
                 + ' need to reconfigure the mirror from scratch.</p>';
            result.label = 'Uninstall';
        } else if (commandName === 'reset') {
            result.title = 'Reset';
            result.content =
                 '<p>You are about to delete SVN Mirror from <strong>'
               + item.data.projectName + ' / ' + item.data.repositoryName + '</strong>'
               + ' repository to bring repository to the unconfigured state.</p>'
               + ' <p>This will not affect existing Git branches and tags.</p>'
               + ' <p>All the synchronization meta information and configuration present'
               + ' will be removed.</p>';
            result.label = 'Reset';
        } else if (commandName === 'rebuild' || (commandName === 'apply' && item.data.forceRebuild)) {
            var revision = item.data.verifyInfo.rebuildRevision;
            if (!revision) {
                revision = Math.max(1, item.data.minimalRevision);
            }
            result.title = 'Rebuild';
            result.content =
               '<p>You are about to rebuild SVN Mirror.</p>'
             + ' <p>Rebuild will fetch revisions from SVN repository'
             + ' starting from <strong>revision ' + revision + '</strong>.</p><p>New Git commits'
             + ' will be created to replace existing ones: <br/>Git commits before r'
             + revision + ' will be preserved; Git commits corresponding to r' +
             + revision + ' and later revisions will be re-created.</p>'
             + ' <p><strong>Users of this repository will have to re-clone their working repositories</strong> after rebuild is completed.</p>';
            result.label = 'Rebuild';
        } else if (commandName === 'unsynced-remove') {
            result.title = 'Mark Resolved';
            result.content =
                 '<p>Reference to unsynced commit is about to be removed.</p>'
               + '<p>Upon removal, <strong>all commits that are only accessible from this reference'
               + '   will be lost forever</strong>.</p>'
               + '<p>Consider merging or restoring referenced before removal.</p>';
            result.label = 'Mark Resolved';
        } else if (commandName === 'unsynced-restore') {
            result.title = 'Restore';
            result.content =
                 '<p>Reference to unsynced commit is about to be restored as a standard branch or tag.</p>'
               + '<p>Unless synchronization is disabled, as soon as branch is restored, commits it references will pushed to Subversion project.</p>'
               + '<p>Restoring reference will also restore other unsynced references reachable from it.</p>';
            result.label = 'Restore';
        } else {
            return null;
        }
        return result;
    };

    var getProgressTitle = function(item) {
        var task = item.task;
        if (!task) {
            return '';
        } else if (task.state !== 'RUNNING' && task.state !== 'CANCELLING') {
            return '';
        }
        var message = '';
        if (task.name === 'apply') {
            message = 'Change Configuration';
        } else if (task.name === 'upgrade') {
            message = 'Upgrade';
        } else if (task.name === 'move-metadata') {
            message = 'Upgrade Metadata';
        } else if (task.name === 'configure') {
            message = 'Initial Configuration';
        } else if (task.name === 'refresh') {
            message = 'Refresh Bitbucket References';
        } else if (task.name === 'start') {
            message = 'Enable Synchronization';
        } else if (task.name === 'start-import') {
            message = 'Start Import';
        } else if (task.name === 'stop') {
            if (item.data.importRequested) {
                message = 'Stop Import';
            } else {
                message = 'Disable Synchronization';
            }
        } else if (task.name === 'bootstrap') {
            message = 'Detecting Mirror Repositories';
        } else if (task.name === 'sync' || task.name === 'push') {
            if (task.name === 'sync' && item.data.importRequested) {
                message = 'Import';
            } else {
                message = 'Synchronization';
            }
        } else if (task.name === 'uninstall') {
            if (item.data.stage === 'CONFIGURED') {
                message = 'Reset Configuration';
            } else {
                message = 'Uninstall';
            }
        }
        return message;
    };

    var getStatusData = function(item) {
        var task = item.task;
        if (!task) {
            return {
                percentage : 100,
                message : ''
            };
        }
        var pending = item.pending;

        var message;
        if (task.state === 'FAILED') {
            if (task.name === 'sync' || task.name === 'push') {
                message = 'Last synchronization failed';
            } else if (task.name === 'upgrade') {
                message = 'Upgrade failed';
            } else if (task.name === 'start' || task.name === 'start-import') {
                message = 'Start ' + (task.name === 'start' ? 'synchronization' : 'import') + ' failed';
            } else if (task.name === 'bootstrap') {
                message = 'Initialization failed';
            } else if (task.name === 'move-metadata') {
                message = "Metadata upgrade failed";
            } else {
                message = getMessageForStage(item);
            }
        } else if (task.state === 'RUNNING' || task.state === 'FAILING') {
            message = task.message;
            if (!message) {
                if (task.name === 'apply') {
                    message = 'Applying configuration changes...';
                } else if (task.name === 'upgrade') {
                    message = 'Upgrading mirror...';
                } else if (task.name === 'configure') {
                    message = 'Initial configuration...';
                } else if (task.name === 'refresh') {
                    message = 'Refreshing Bitbucket references...';
                } else if (task.name === 'start') {
                    message = 'Enabling synchronization...';
                } else if (task.name === 'start-import') {
                    message = 'Starting import...';
                } else if (task.name === 'stop') {
                    message = 'Disabling synchronization...';
                } else if (task.name === 'bootstrap') {
                    message = 'Detecting Mirror Repositories...';
                } else if (task.name === 'sync' || task.name === 'push') {
                    message = item.data.importRequested ? 'Importing...' : 'Synchronizing...';
                } else if (task.name === 'uninstall') {
                    if (item.data.stage === 'CONFIGURED') {
                        message = 'Resetting configuration...';
                    } else {
                        message = 'Uninstalling...';
                    }
                } else if (task.name === 'move-metadata') {
                    message = 'Upgrading metadata...';
                }
            }
        } else if (task.state === 'CANCELLING') {
            if (task.name === 'apply') {
                message = 'Cancelling configuration changes...';
            } else if (task.name === 'upgrade') {
                message = 'Cancelling upgrade...';
            } else if (task.name === 'configure') {
                message = 'Cancelling initial configuration...'
            } else if (task.name === 'refresh') {
                message = 'Cancelling refresh...';
            } else if (task.name === 'start') {
                message = 'Cancelling synchronization start...';
            } else if (task.name === 'start-import') {
                message = 'Cancelling import start...';
            } else if (task.name === 'stop') {
                message = item.data.importRequested ? 'Cancelling import stop...' : 'Cancelling synchronization stop...';
            } else if (task.name === 'bootstrap') {
                message = 'Cancelling initialization...';
            } else if (task.name === 'sync' || task.name === 'push') {
                message = item.data.importRequested ? 'Cancelling import...' : 'Cancelling synchronization...';
            } else if (task.name === 'uninstall') {
                if (item.data.stage === 'CONFIGURED') {
                    message = 'Cancelling configuration reset...';
                } else {
                    message = 'Cancelling uninstalling';
                }
            } else if (task.name === 'move-metadata') {
                message = 'Cancelling metadata upgrade...';
            }
        } else if (task.state === 'SUCCESS' || task.state === 'CANCELLED') {
            message = getMessageForStage(item);
        } else {
            message = '';
        }

        var nextMessage = null;
        if (task.state !== 'RUNNING' && task.state !== 'CANCELLING' && pending && pending.length > 0) {
            var pendingTask = pending[0];
            if (pendingTask.name === 'sync' || pendingTask.name === 'push') {
                if (pendingTask.scheduled < 0) {
                    nextMessage = 'synchronization is pending';
                } else {
                    nextMessage = 'next synchronization at ' + formatTime(pendingTask.scheduled);
                }
            } else if (pendingTask.name === 'upgrade') {
                if (pendingTask.scheduled < 0) {
                    nextMessage = 'upgrade is pending';
                } else {
                    nextMessage = 'upgrade is scheduled at ' + formatTime(pendingTask.scheduled);
                }
            } else if (pendingTask.name === 'move-metadata') {
                if (pendingTask.scheduled < 0) {
                    nextMessage = 'metadata upgrade is pending';
                } else {
                    nextMessage = 'metadata upgrade is scheduled at ' + formatTime(pendingTask.scheduled);
                }
            } else if (pendingTask.name === 'bootstrap') {
                nextMessage = 'will reload state';
            } else {
                nextMessage = 'one task is queued';
                if (pendingTask.name !== null
                    && pendingTask.name !== undefined) {
                    nextMessage += ' (' + pendingTask.name + ')';
                }
            }
        }
        if (nextMessage) {
            message += ', ' + nextMessage;
        } else if (item.data.stage === 'INSTALLED' || item.data.stage === 'PAUSED') {
            if (task.state === 'SUCCESS' || task.state === 'FAILED' || task.state === 'CANCELLED') {
                if (item.data.synced > 0) {
                    message += ', last synchronized on ' + formatDateAndTime(item.data.synced);
                }
            }
        }

        var percentage = -1;
        if (task.state === 'CANCELLING') {
            percentage = 100;
        } else if (task.state === 'RUNNING' || task.state === 'FAILING') {
            if ((task.name === 'configure' || task.name === 'sync' || task.name === 'bootstrap') && task.percentage >= 0 && task.percentage <= 100) {
                percentage = task.percentage;
            } else {
                percentage = 100;
            }
        }

        return {
            percentage : percentage,
            message : message
        };
    };

    var getPrimaryBadgeData = function(item, isLink) {
        var stage = item.data.stage;
        var result;
        if (stage === 'CONFIGURED') {
            result = ['complete', 'configured', 'Configured, ready to start mirror or import'];
        } else if (stage === 'PAUSED') {
            if (item.data.importRequested) {
                result = ['moved', 'paused', 'Import is paused'];
            } else {
                result = ['moved', 'disabled', 'Synchronization is disabled'];
            }
        } else if (stage === 'INSTALLED') {
            if (item.data.importRequested) {
                result = ['complete', 'importing', 'Importing from Subversion'];
            } else {
                result = ['success', 'active', 'Synchronization is enabled'];
            }
        } else if (stage === 'PENDING_METADATA_MOVE') {
            result = ['current', 'metadata upgrade', 'The add-on is upgrading metadata for the mirror'];
        } else if (stage === 'LEGACY') {
            result = ['current', 'needs upgrade', 'Mirror is in pre 3.0.x format, have to be upgraded to enable synchronization'];
        } else if (stage === 'EXTERNAL_LOCAL' || stage === 'EXTERNAL_REMOTE') {
            result = ['complete', 'external', 'Mirror is managed by external standalone SubGit tool'];
        } else if (stage === 'INITIAL') {
            result = ['complete', 'configuring', 'Initial Configuration'];
        } else if (stage === 'GLOBAL' || stage === 'PROJECT') {
            result = ['complete', 'loading', 'Detecting Mirror Repositories'];
        } else {
            result = ['error', 'unknown', 'Unknown State'];
        }
        if (isLink) {
            if (item.data.importRequested) {
                result[2] += '\nClick to edit settings';
            } else {
                result[2] += '\nClick to edit mirror configuration';
            }
        }
        return result;
    };

    var getSecondaryBadgeData = function(item, isLink) {
        var stage = item.data ? item.data.stage : null;
        if (item.task.state === 'FAILED') {
            if (item.task.name === 'sync'
                || item.task.name === 'push'
                || item.task.name === 'upgrade'
                || item.task.name === 'start'
                || item.task.name === 'start-import') {
                return ['error', 'error', 'Last operation failed with an error' + (isLink ? '\nClick to view details' : '')];
            }
        } else if (item.task.state === 'FAILING') {
            if (item.task.name === 'sync' || item.task.name === 'push') {
                return ['error', 'error', 'Sync failed, collecting additional data...'];
            }
        } else if (item.data.verifyInfo && item.data.verifyInfo.issues.length > 0) {
            if (stage === 'INSTALLED' || stage === 'PAUSED') {
              return ['current', 'out of sync', 'There are unsynced SVN revisions' + (isLink ? '\nClick to review and resolve' : '')];
            }
        } else if (item.data.hasUnsyncedRefs) {
            if (stage === 'INSTALLED' || stage === 'PAUSED' || stage === 'PENDING_METADATA_MOVE' || stage === 'LEGACY') {
                return ['current', 'unsynced', 'There are unsynced commits in this mirror' + (isLink ? '\nClick to review and resolve' : '')];
            }
        }
        return null;
    };

    exports.getProgressTitle = getProgressTitle;
    exports.getPrimaryBadgeData = getPrimaryBadgeData;
    exports.getSecondaryBadgeData = getSecondaryBadgeData;
    exports.getStatusData = getStatusData;
    exports.getConfirmationData = getConfirmationData;
    exports.getCommandFlagData = getCommandFlagData;
    exports.formatDateAndTime = formatDateAndTime;
    exports.formatFileSize = formatFileSize;

});
