define('tmatesoft/engine-jquery', [
    'tmatesoft/engine',
    'tmatesoft/engine-util'
], function(
    Engine,
    Util) {

    'use strict';

    function Controller(jQuery) {
        Engine.Controller.apply(this);
        this.jQuery = jQuery;
    };
    Util.extendClass(Controller, Engine.Controller);

    Controller.prototype.createView = function(delegate, domElement) {
        var wrapper = new View(delegate);
        var view = Engine.Controller.prototype.createView.call(this, wrapper, domElement);
        wrapper.containsElementFilter = function() {
            return view.containsElement(this);
        };
        delegate.el = wrapper.el;

        return view;
    };

    function View(delegate) {
        this.delegate = delegate;
        var childFactories = Util.isFunction(delegate.children) ? delegate.children() : delegate.children;
        this.children = {};
        var self = this;
        for(var childId in childFactories) {
            if (!childFactories.hasOwnProperty(childId)) {
                continue;
            }
            this.children[childId] = function() {
                var factory = childFactories[childId];
                return function(model, el) {
                    return factory(model, el, self.jq(model, el));
                }
            }();
        }
    };

    View.prototype.jq = function(model, el, origin) {
        var filter = this.containsElementFilter;
        var scoped = function(p) {
            if (p && typeof p === 'string') {
                if (p.length > 0 && p.charAt(0) === '<') {
                  return jQuery(p);
                }
                try {
                    var selector = model.jQuery(p, el).filter(filter);
                    return origin ? selector.not(origin) : selector;
                } catch(err) {
                }
            }
            return jQuery(p);
        };
        scoped.$ = model.jQuery;
        return scoped;
    };

    View.prototype.render = function(model, el) {
        var jq = this.jq(model, el);
        if (Util.isFunction(this.delegate.render)) {
            this.delegate.render(model, el, jq);
        }
        if (Util.isFunction(this.delegate.setup)) {
            this.delegate.setup(model, el, jq);
        }
    };

    View.prototype.postRender = function(model, el) {
        var jq = this.jq(model, el);
        if (Util.isFunction(this.delegate.postRender)) {
            this.delegate.postRender(model, el, jq);
        }
    };

    View.prototype.update = function(event, el) {
        if (Util.isFunction(this.delegate.update)) {
            var jq = this.jq(event.model, el, event.origin);
            return this.delegate.update(event, el, jq);
        }
        return false;
    };

    View.prototype.dispose = function(model, el) {
        var jq = this.jq(model, el);
        if (Util.isFunction(this.delegate.dispose)) {
            this.delegate.dispose(model, this.el, jq);
        }
    };

    return Controller;
});