<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <html>
            <head>
                <title>
                    <xsl:apply-templates select="tests" mode="description"/>
                    <xsl:text>(built on</xsl:text>
                    <xsl:apply-templates select="tests" mode="date"/>
                    <xsl:text>)</xsl:text>
                </title>
                <style type="text/css">

                    body {
                    margin: 0;
                    padding: 0;
                    font-family: sans-serif;
                    font-size: 12pt;
                    }

                    body, a, a:visited {
                    color: #303030;
                    }

                    #wrap {
                    width: 1100px;
                    margin: 10px auto;
                    background: #fff;
                    }

                    #header {
                    padding: 15px 10px;
                    overflow:hidden;
                    }

                    #name {
                    float: left;
                    }

                    #name h1 {
                    margin:0;
                    height:80px;
                    line-height:80px;
                    }

                    #date {
                    float: right;
                    text-align: right;
                    width: 500px;
                    }

                    #date h2 {
                    margin:0;
                    height:80px;
                    line-height:80px;
                    }

                    .summary {
                    border: solid 2px #d0d0d0;
                    -moz-border-radius: 10px;
                    border-radius: 10px;
                    width: 40%;
                    }

                    .summary table {
                    table-layout: fixed;
                    padding: 10px;
                    width: 100%;
                    font-size: 16pt;
                    }

                    .info p {
                    margin: 0;
                    }

                    .test {
                    padding-top: 30px;
                    }

                    .description {

                    }

                    .description p {
                    margin: 20px 0;
                    }

                    .method {
                    display: none;
                    }

                    .passed {
                    color: #080
                    }

                    .failed {
                    color: #800
                    }

                    .control {
                    font-size: 14pt;
                    text-decoration: none;
                    border-bottom: 1px dashed;
                    }

                    strong {
                    font-size: 16px;
                    }

                    .main {
                    width: 100%;
                    }

                    .main table {
                    margin: 20px 0;
                    table-layout: fixed;
                    width: 100%;
                    border-collapse: collapse;
                    }

                    .main thead th {
                    padding:15px 30px;
                    background:#fafafa;
                    text-align:left;
                    }

                    .main thead th:first-child {
                    border-radius:8px 0 0 0;
                    }

                    .main thead th:last-child {
                    border-radius:0 8px 0 0;
                    }

                    .main tbody td {
                    padding: 20px 30px;
                    vertical-align: top;
                    border-bottom: 1px solid #ccc;
                    border-top: 1px solid #ccc;
                    }

                    .main tbody tr:nth-child(even) td {
                    background:#fafafa;
                    }

                    .button{
                    text-decoration:none;
                    background:#fafafa;
                    display: inline-block;
                    *display: inline;
                    *zoom: 1;
                    vertical-align: middle;
                    border-radius:5px;
                    padding:8px 15px;
                    color:#333;
                    font-size:13px;
                    box-shadow:0 0 3px #999;
                    cursor:pointer;
                    }

                    .button:hover{
                    background:#f4f4f4;
                    box-shadow:0 0 3px #333;
                    }

                    .button:active{
                    background:#fafafa;
                    box-shadow:0 0 3px #333;
                    }

                    .workDir {
                    color: #333;
                    }

                    .stdout {
                    padding-top:5px;
                    color: #777;
                    }

                    .stderr {
                    padding-top:5px;
                    color:#777;
                    }

                </style>

                <script type="text/javascript" src="http://yandex.st/jquery/1.6.0/jquery.min.js"/>

                <script type="text/javascript">
                    $(document).ready(function() {
                    $('.control').click(function(){
                    a = $(this);
                    $('.method', a.parents('.test')).toggle();
                    if (a.text() == 'Show details') {
                    a.text('Hide details');
                    } else if (a.text() == 'Hide details') {
                    a.text('Show details');
                    }
                    return false;
                    });

                    $('.method').each(function() {
                    var $method = $(this);
                    var $toggleLink = $(this).find('.toggleLink');
                    var $toggleTable = $(this).find('.toggleTable');

                    if ($toggleTable.find('tbody tr').length == 1) {
                    $toggleLink.remove();
                    return;
                    }

                    $toggleLink.toggle(function(e) {
                    $(this).text('Expand');
                    $toggleTable.find('tbody tr').not(':last').hide();
                    return false;
                    }, function(e) {
                    $(this).text('Collapse');
                    $toggleTable.find('tbody tr').show();
                    return false;
                    });
                    });


                    });
                </script>
            </head>
            <body>
                <div id="wrap">
                    <div id="header">
                        <div id="name">
                            <h1>
                                <xsl:apply-templates select="tests" mode="description"/>
                            </h1>
                        </div>
                        <div id="date">
                            <h2>
                                <xsl:apply-templates select="tests" mode="date"/>
                            </h2>
                        </div>
                    </div>
                    <div class="summary">
                        <table>
                            <tr>
                                <td>
                                    <div class="info">
                                        <div class="counter">
                                            <xsl:value-of select="tests/total"/>
                                        </div>
                                        <p>tests</p>
                                    </div>
                                </td>
                                <td>
                                    <div class="info">
                                        <div class="counter">
                                            <xsl:value-of select="tests/failures"/>
                                        </div>
                                        <p>failures</p>
                                    </div>
                                </td>
                                <td>
                                    <div class="info">
                                        <div class="counter">
                                            <xsl:value-of select="tests/duration"/>
                                        </div>
                                        <p>duration</p>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>

                    <div class="main">
                        <xsl:apply-templates select="tests/sequence"/>
                    </div>
                </div>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="tests" mode="description">
        <xsl:value-of select="@description"/>
    </xsl:template>

    <xsl:template match="tests" mode="date">
        <xsl:value-of select="@date"/>
    </xsl:template>

    <xsl:template match="sequence">
        <div class="test">
            <div>
                <span class="methodName">
                    <a href="#" class="control">
                        <xsl:number value="position()"/>
                        <xsl:text>. </xsl:text>
                        <xsl:value-of select="@method"/>
                        <xsl:text> </xsl:text>
                        <xsl:choose>
                            <xsl:when test="result='passed'">
                                <span class="passed">PASSED</span>
                            </xsl:when>
                            <xsl:otherwise>
                                <span class="failed">FAILED</span>
                            </xsl:otherwise>
                        </xsl:choose>
                    </a>
                </span>
            </div>
            <div class="method">
                <div class="description">
                    <p>
                        <xsl:value-of select="@description"/>
                    </p>
                </div>
                <a href="#" class="button toggleLink">Collapse</a>
                <table class="toggleTable">
                    <thead>
                        <tr>
                            <th>Subversion</th>
                            <th>Git</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:apply-templates select="test"/>
                    </tbody>
                </table>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="test">
        <xsl:variable select="change" name="changes"/>
        <xsl:variable select="@method" name="method"/>

        <xsl:choose>
            <xsl:when test="count($changes) > 0">
                <xsl:apply-templates select="change"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="fetch">
                    <xsl:with-param name="method" select="$method"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="fetch">
        <xsl:param name="method"/>
        <xsl:for-each select="/tests/sequence/test[@method = $method]">
            <xsl:variable select="change" name="changes"/>
            <xsl:if test="count($changes) > 0">
                <xsl:apply-templates select="change"/>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="change">
        <tr>
            <td class="svn">
                <xsl:apply-templates select="script[@kind='SVN']"/>
            </td>
            <td class="git">
                <xsl:apply-templates select="script[@kind='GIT']"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="script/cmd">
        <div class="exec">
            <div class="command">
                <span class="workDir">
                    <xsl:if test="@working-directory != ''">
                        <xsl:text>  [</xsl:text>
                        <xsl:value-of select="@working-directory"/>
                        <xsl:text>]  </xsl:text>
                    </xsl:if>
                </span>
                <span class="commandLine">
                    <xsl:value-of select="command-line"/>
                </span>
            </div>
            <div class="stdout">
                <xsl:apply-templates select="stdout"/>
            </div>
            <div class="stderr">
                <xsl:apply-templates select="stderr"/>
            </div>
            <br/>
        </div>
    </xsl:template>

    <xsl:template match="stdout">
        <xsl:copy>
            <xsl:apply-templates mode="replace"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="stderr">
        <xsl:copy>
            <xsl:apply-templates mode="replace"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template name="replace" match="text()" mode="replace">

        <xsl:param name="str" select="."/>
        <xsl:param name="search-for" select="'&#xA;'"/>
        <xsl:param name="replace-with">
            <xsl:element name="BR"/>
            <xsl:text>&#xA;</xsl:text>
        </xsl:param>

        <xsl:choose>

            <xsl:when test="contains($str, $search-for)">
                <xsl:value-of select="substring-before($str, $search-for)"/>
                <xsl:copy-of select="$replace-with"/>
                <xsl:call-template name="replace">
                    <xsl:with-param name="str" select="substring-after($str, $search-for)"/>
                    <xsl:with-param name="search-for" select="$search-for"/>
                    <xsl:with-param name="replace-with" select="$replace-with "/>
                </xsl:call-template>
            </xsl:when>

            <xsl:otherwise>
                <xsl:value-of select="$str"/>
            </xsl:otherwise>

        </xsl:choose>

    </xsl:template>
</xsl:stylesheet>