/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.translator.h;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.translator.h.a;
import org.tmatesoft.translator.h.b;
import org.tmatesoft.translator.h.c;
import org.tmatesoft.translator.h.e;
import org.tmatesoft.translator.h.f;
import org.tmatesoft.translator.util.z;

public class d {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private static final String LOGFILE_NAME_SUFFIX = "yyyyMMdd-HHmmss";
    private static final String DEFAULT_LOGGER_NAME = "subgit";
    private static final InheritableThreadLocal threadLocalLogger = new InheritableThreadLocal();
    private Logger delegate;
    private final Map handlers;

    public static synchronized void resetThreadLogger() {
        threadLocalLogger.set(null);
    }

    public static synchronized void configureConsoleLogger(@Nullable String string, @Nullable Level level) {
        if (level == null) {
            level = Level.OFF;
        }
        if (string == null) {
            string = DEFAULT_LOGGER_NAME;
        }
        d d2 = d.getLogger();
        d2.setLogLevel(level);
        c c2 = new c(string);
        a a2 = new a(level, c2);
        d2.setConsoleHandler(a2);
        f f2 = d2.getMemoryCacheHandler();
        if (f2 != null) {
            f2.a(a2);
        }
        d2.info("Initialized console logger, level: %s", level);
        d2.info(z.r().l());
    }

    public static synchronized void configureFileLogger(@NotNull String string, @Nullable File file, @Nullable Level level, boolean bl2, boolean bl3) {
        if (level == null) {
            level = Level.OFF;
        }
        if (string == null) {
            string = DEFAULT_LOGGER_NAME;
        }
        d d2 = d.getLogger();
        d2.setLogLevel(level);
        c c2 = new c(string);
        b b2 = new b(string, file, level, c2, bl3);
        d2.setFileHandler(b2);
        f f2 = d2.getMemoryCacheHandler();
        if (f2 != null) {
            f2.a(b2);
            f2.setLevel(Level.OFF);
            if (bl2) {
                f2.close();
                d2.removeMemoryCacheHandler();
            }
        }
        d2.info("Initialized file logger, level: %s, logs directory is: '%s'.", level, file);
        d2.info(z.r().l());
    }

    public static synchronized void closeFileLogger() {
        d d2 = d.getLogger();
        d2.closeFileHandler();
    }

    public static synchronized void disposeLogger() {
        d d2 = (d)threadLocalLogger.get();
        if (d2 != null) {
            d2.close();
            threadLocalLogger.remove();
        }
    }

    @NotNull
    public static synchronized d getLogger() {
        d d2 = (d)threadLocalLogger.get();
        if (d2 == null) {
            d2 = new d(null);
            threadLocalLogger.set(d2);
        }
        return d2;
    }

    public static synchronized void setLogger(@NotNull d d2) {
        threadLocalLogger.set(d2);
    }

    protected d(@Nullable String string) {
        if (string == null) {
            string = DEFAULT_LOGGER_NAME;
        }
        this.handlers = new HashMap();
        this.init(string);
    }

    protected void init(String string) {
        this.delegate = Logger.getLogger(string + ":" + UUID.randomUUID());
        this.delegate.setUseParentHandlers(false);
        this.delegate.setLevel(Level.ALL);
        c c2 = new c(string);
        f f2 = new f(Level.ALL, c2);
        this.setMemoryCacheHandler(f2);
        this.info("Initialized memory cache logger.");
        this.info(z.r().l());
    }

    private Logger getDelegate() {
        return this.delegate;
    }

    @NotNull
    public Level getLogLevel() {
        Logger logger = this.getDelegate();
        if (logger == null) {
            return Level.OFF;
        }
        Logger logger2 = logger;
        Level level = logger2.getLevel();
        while (level == null) {
            Logger logger3 = logger2.getParent();
            if (logger3 == null) {
                return Level.OFF;
            }
            level = logger3.getLevel();
            logger2 = logger3;
        }
        return level;
    }

    public void setLogLevel(@NotNull Level level) {
        Logger logger = this.getDelegate();
        if (logger != null) {
            logger.setLevel(level);
        }
    }

    @Nullable
    private f getMemoryCacheHandler() {
        return (f)this.handlers.get("cache");
    }

    private void setMemoryCacheHandler(@Nullable f f2) {
        this.setHandler("cache", f2);
    }

    private void removeMemoryCacheHandler() {
        this.setMemoryCacheHandler(null);
    }

    private void setConsoleHandler(@Nullable a a2) {
        this.setHandler("console", a2);
    }

    @Nullable
    private b getFileHandler() {
        return (b)this.handlers.get("file");
    }

    private void setFileHandler(@Nullable b b2) {
        b b3 = this.getFileHandler();
        if (b3 != null) {
            b3.close();
        }
        this.setHandler("file", b2);
    }

    private Handler setHandler(@NotNull String string, @Nullable Handler handler) {
        Handler handler2 = this.handlers.put(string, handler);
        this.getDelegate().removeHandler(handler2);
        if (handler != null) {
            this.getDelegate().addHandler(handler);
        } else {
            this.handlers.remove(string);
        }
        return handler;
    }

    @Nullable
    public File getLogsDirectory() {
        b b2 = d.getLogger().getFileHandler();
        if (b2 == null) {
            return null;
        }
        return b2.a();
    }

    public void info(@NotNull Throwable throwable) {
        this.info(throwable, throwable.getMessage());
    }

    public void info(@NotNull Throwable throwable, @Nullable String string) {
        if (string == null) {
            this.info(throwable, null, new Object[]{EMPTY_ARRAY});
        } else {
            this.info(throwable, "%s", string);
        }
    }

    public void info(@Nullable String string) {
        this.info("%s", string);
    }

    public void info(@Nullable String string, Object ... objectArray) {
        this.info(null, string, objectArray);
    }

    public void info(@Nullable Throwable throwable, @Nullable String string, Object ... objectArray) {
        this.log(Level.INFO, throwable, string, objectArray);
    }

    protected void log(@NotNull Level level, @Nullable Throwable throwable, @Nullable String string, Object ... objectArray) {
        if (this.getDelegate().isLoggable(level)) {
            String string2;
            if (string == null) {
                string2 = "";
            } else {
                try {
                    string2 = String.format(string, objectArray);
                }
                catch (Throwable throwable2) {
                    this.log(Level.INFO, throwable2, null, new Object[0]);
                    string2 = string + " " + Arrays.toString(objectArray);
                }
            }
            this.getDelegate().log(level, string2, throwable);
        }
    }

    public void logSystemProperties() {
        int n2 = 0;
        for (Object iterator : System.getProperties().keySet()) {
            String string = String.valueOf(iterator);
            n2 = Math.max(n2, string.length());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("System properties:\n");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object object = entry.getKey();
            String string = String.valueOf(object);
            Object object2 = entry.getValue();
            stringBuilder.append(string);
            for (int i2 = 0; i2 < n2 - string.length(); ++i2) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(" : ");
            stringBuilder.append(object2);
            stringBuilder.append('\n');
        }
        this.info(stringBuilder.toString());
    }

    public void logFileContent(File file) {
        this.logFileContent(null, file);
    }

    public void logFileContent(String string, File file) {
        if (string == null) {
            string = "";
        } else if (!string.endsWith(":")) {
            string = string + ":";
        }
        try {
            if (!file.exists()) {
                d.getLogger().info("%s file '%s' does not exist", string, file);
            } else {
                String string2 = SVNFileUtil.readFile(file);
                d.getLogger().info(string + "\n" + string2);
            }
        }
        catch (Throwable throwable) {
            d.getLogger().info(throwable, "%s failed to load file '%s'", file);
        }
    }

    private File getArchiveFile(@NotNull File file, @Nullable String string) {
        String string2 = new SimpleDateFormat(LOGFILE_NAME_SUFFIX).format(new Date());
        if (string == null) {
            string = "bug";
        }
        String string3 = String.format("%s-%s-%s.zip", z.r().b(), string, string2);
        return new File(file, string3);
    }

    @Nullable
    public File archiveLogs(@NotNull File file, @Nullable String string) {
        b b2;
        File file2 = this.getArchiveFile(file, string);
        File file3 = file2.getParentFile();
        if (file3 != null) {
            file3.mkdirs();
            if (!file3.exists()) {
                return null;
            }
        }
        if ((b2 = this.getFileHandler()) != null) {
            b2.a(file2);
        } else {
            f f2 = this.getMemoryCacheHandler();
            if (f2 != null) {
                f2.a(file2);
            }
        }
        return file2;
    }

    public void deleteLogs() {
        b b2 = this.getFileHandler();
        if (b2 != null) {
            b2.c();
        }
    }

    private void closeFileHandler() {
        b b2 = this.getFileHandler();
        if (b2 != null) {
            b2.close();
        }
        this.setFileHandler(null);
    }

    private void closeMemoryCacheHandler() {
        f f2 = this.getMemoryCacheHandler();
        if (f2 != null) {
            f2.close();
        }
    }

    public void close() {
        this.closeFileHandler();
        this.closeMemoryCacheHandler();
    }

    static {
        com.a.a.a.c.c.a(e.a());
        SVNDebugLog.setDefaultLog(e.a());
        com.trilead.ssh2.log.Logger.logger = e.a();
        com.trilead.ssh2.log.Logger.enabled = true;
    }
}

