/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class Version {
    private static String PROPERTIES_PATH = "/svnkit.build.properties";
    private static final String SHORT_VERSION_STRING_PROPERTY = "svnkit.version";
    private static final String VERSION_STRING_PROPERTY = "svnkit.version.string";
    private static final String VERSION_MAJOR_PROPERTY = "svnkit.version.major";
    private static final String VERSION_MINOR_PROPERTY = "svnkit.version.minor";
    private static final String VERSION_MICRO_PROPERTY = "svnkit.version.micro";
    private static final String VERSION_REVISION_PROPERTY = "svnkit.version.revision";
    private static final String SVN_VERSION_PROPERTY = "svnkit.svn.version";
    private static final String VERSION_STRING_DEFAULT = "SVN/1.8.1 SVNKit/1.10.11 (http://svnkit.com/) rSNAPSHOT";
    private static final String VERSION_MAJOR_DEFAULT = "1";
    private static final String VERSION_MINOR_DEFAULT = "10";
    private static final String VERSION_MICRO_DEFAULT = "11";
    private static final String VERSION_REVISION_DEFAULT = "SNAPSHOT";
    private static final String SVN_VERSION_DEFAULT = "1.10.11";
    private static String ourUserAgent = System.getProperty("svnkit.http.userAgent");
    private static Properties ourProperties;

    public static String getVersionString() {
        Version.loadProperties();
        return ourProperties.getProperty(VERSION_STRING_PROPERTY, VERSION_STRING_DEFAULT);
    }

    public static String getShortVersionString() {
        Version.loadProperties();
        return ourProperties.getProperty(SHORT_VERSION_STRING_PROPERTY, VERSION_STRING_DEFAULT);
    }

    public static String getSVNVersion() {
        Version.loadProperties();
        return ourProperties.getProperty(SVN_VERSION_PROPERTY, SVN_VERSION_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserAgent(String string) {
        Class<Version> clazz = Version.class;
        synchronized (Version.class) {
            ourUserAgent = string;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getUserAgent() {
        if (ourUserAgent != null) {
            return ourUserAgent;
        }
        return Version.getVersionString();
    }

    public static int getMajorVersion() {
        Version.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MAJOR_PROPERTY, VERSION_MAJOR_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(VERSION_MAJOR_DEFAULT);
        }
    }

    public static int getMinorVersion() {
        Version.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MINOR_PROPERTY, VERSION_MINOR_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(VERSION_MINOR_DEFAULT);
        }
    }

    public static int getMicroVersion() {
        Version.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MICRO_PROPERTY, VERSION_MICRO_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(VERSION_MICRO_DEFAULT);
        }
    }

    @Deprecated
    public static long getRevisionNumber() {
        Version.loadProperties();
        String string = ourProperties.getProperty(VERSION_REVISION_PROPERTY, VERSION_REVISION_DEFAULT);
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.lastIndexOf(46) > 0) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
            if (string.indexOf(114) >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = string.indexOf(114) + 1; i2 < string.length(); ++i2) {
                    char c2 = string.charAt(i2);
                    if (!Character.isDigit(c2)) break;
                    stringBuffer.append(c2);
                }
                if (stringBuffer.length() > 0) {
                    return Long.parseLong(stringBuffer.toString());
                }
            }
            try {
                return Long.parseLong(VERSION_REVISION_DEFAULT);
            }
            catch (NumberFormatException numberFormatException2) {
                return -1L;
            }
        }
    }

    public static String getRevisionString() {
        Version.loadProperties();
        return ourProperties.getProperty(VERSION_REVISION_PROPERTY, VERSION_REVISION_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        Class<Version> clazz = Version.class;
        synchronized (Version.class) {
            if (ourProperties != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            ourProperties = new Properties();
            InputStream inputStream = Version.class.getResourceAsStream(PROPERTIES_PATH);
            if (inputStream == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                ourProperties.load(inputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                SVNFileUtil.closeFile(inputStream);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

