/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.tmatesoft.svn.core.internal.util.SVNLogInputStream;
import org.tmatesoft.svn.core.internal.util.SVNLogOutputStream;
import org.tmatesoft.svn.core.internal.util.SVNLogStream;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNDebugLogAdapter
implements ISVNDebugLog {
    @Override
    public void logError(SVNLogType sVNLogType, String string) {
        this.log(sVNLogType, string, Level.INFO);
    }

    @Override
    public void logError(SVNLogType sVNLogType, Throwable throwable) {
        this.log(sVNLogType, throwable, Level.INFO);
    }

    @Override
    public void logSevere(SVNLogType sVNLogType, String string) {
        this.log(sVNLogType, string, Level.SEVERE);
    }

    @Override
    public void logSevere(SVNLogType sVNLogType, Throwable throwable) {
        this.log(sVNLogType, throwable, Level.SEVERE);
    }

    @Override
    public void logFine(SVNLogType sVNLogType, Throwable throwable) {
        this.log(sVNLogType, throwable, Level.FINE);
    }

    @Override
    public void logFine(SVNLogType sVNLogType, String string) {
        this.log(sVNLogType, string, Level.FINE);
    }

    @Override
    public void logFiner(SVNLogType sVNLogType, Throwable throwable) {
        this.log(sVNLogType, throwable, Level.FINER);
    }

    @Override
    public void logFiner(SVNLogType sVNLogType, String string) {
        this.log(sVNLogType, string, Level.FINER);
    }

    @Override
    public void logFinest(SVNLogType sVNLogType, Throwable throwable) {
        this.log(sVNLogType, throwable, Level.FINEST);
    }

    @Override
    public void logFinest(SVNLogType sVNLogType, String string) {
        this.log(sVNLogType, string, Level.FINEST);
    }

    @Override
    public void flushStream(Object object) {
        if (object instanceof SVNLogInputStream) {
            SVNLogInputStream sVNLogInputStream = (SVNLogInputStream)object;
            sVNLogInputStream.flushBuffer();
        } else if (object instanceof SVNLogOutputStream) {
            SVNLogOutputStream sVNLogOutputStream = (SVNLogOutputStream)object;
            sVNLogOutputStream.flushBuffer();
        }
    }

    @Override
    public InputStream createLogStream(SVNLogType sVNLogType, InputStream inputStream) {
        return new SVNLogInputStream(inputStream, this.createInputLogStream());
    }

    @Override
    public OutputStream createLogStream(SVNLogType sVNLogType, OutputStream outputStream) {
        return new SVNLogOutputStream(outputStream, this.createOutputLogStream());
    }

    @Override
    public OutputStream createInputLogStream() {
        return new SVNLogStream(this, false);
    }

    @Override
    public OutputStream createOutputLogStream() {
        return new SVNLogStream(this, true);
    }
}

