/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnTarget {
    private SVNURL url;
    private File file;
    private SVNRevision pegRevision;

    public static SvnTarget fromFile(File file) {
        return SvnTarget.fromFile(file, SVNRevision.UNDEFINED);
    }

    public static SvnTarget fromFile(File file, SVNRevision sVNRevision) {
        return new SvnTarget(file, sVNRevision);
    }

    public static SvnTarget fromURL(SVNURL sVNURL) {
        return SvnTarget.fromURL(sVNURL, SVNRevision.UNDEFINED);
    }

    public static SvnTarget fromURL(SVNURL sVNURL, SVNRevision sVNRevision) {
        return new SvnTarget(sVNURL, sVNRevision);
    }

    private SvnTarget(File file, SVNRevision sVNRevision) {
        this.file = new File(SVNPathUtil.validateFilePath(file.getAbsolutePath()));
        this.setPegRevision(sVNRevision);
    }

    private SvnTarget(SVNURL sVNURL, SVNRevision sVNRevision) {
        this.url = this.getCanonicalUrl(sVNURL);
        this.setPegRevision(sVNRevision);
    }

    private SVNURL getCanonicalUrl(SVNURL sVNURL) {
        if (sVNURL == null) {
            return null;
        }
        SVNURL sVNURL2 = null;
        try {
            sVNURL2 = SVNUpdateClient16.canonicalizeURL(sVNURL, true);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return sVNURL2 != null ? sVNURL2 : sVNURL;
    }

    public boolean isLocal() {
        return this.isFile() && this.getResolvedPegRevision().isLocal();
    }

    public boolean isFile() {
        return this.file != null;
    }

    public boolean isURL() {
        return this.url != null;
    }

    public SVNURL getURL() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public SVNRevision getPegRevision() {
        return this.pegRevision;
    }

    public SVNRevision getResolvedPegRevision() {
        return this.getResolvedPegRevision(SVNRevision.HEAD, SVNRevision.WORKING);
    }

    public SVNRevision getResolvedPegRevision(SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        if (this.getPegRevision() == null || this.getPegRevision() == SVNRevision.UNDEFINED) {
            if (sVNRevision2 == null) {
                sVNRevision2 = SVNRevision.WORKING;
            }
            if (sVNRevision == null) {
                sVNRevision = SVNRevision.HEAD;
            }
            return this.isURL() ? sVNRevision : sVNRevision2;
        }
        return this.getPegRevision();
    }

    private void setPegRevision(SVNRevision sVNRevision) {
        if (sVNRevision == null) {
            sVNRevision = SVNRevision.UNDEFINED;
        }
        this.pegRevision = sVNRevision;
    }

    public String getPathOrUrlString() {
        if (this.isFile()) {
            return this.getFile().getPath();
        }
        if (this.isURL()) {
            return this.getURL().toString();
        }
        throw new IllegalStateException("A target can be either an URL or a path");
    }

    public String getPathOrUrlDecodedString() {
        if (this.isFile()) {
            return this.getFile().getPath();
        }
        if (this.isURL()) {
            return this.getURL().toString();
        }
        throw new IllegalStateException("A target can be either an URL or a path");
    }

    public String toString() {
        if (this.isFile()) {
            return this.getFile().getAbsolutePath() + '@' + this.getPegRevision();
        }
        if (this.isURL()) {
            return this.getURL().toString() + '@' + this.getPegRevision();
        }
        return "INVALID TARGET";
    }
}

