/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnSetWCDbVersion
extends SvnOperation {
    public static final int WC_DB_17_VERSION = 29;
    public static final int WC_DB_18_VERSION = 31;
    private int version;

    protected SvnSetWCDbVersion(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public void setVersion(int n2) {
        this.version = n2;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void run() {
        for (SvnTarget svnTarget : this.getTargets()) {
            File file;
            File file2;
            if (!svnTarget.isFile() || SVNFileType.getType(file2 = new File(file = this.getFirstTarget().getFile(), SVNFileUtil.getAdminDirectoryName() + "/wc.db")) != SVNFileType.FILE) continue;
            SVNSqlJetDb sVNSqlJetDb = SVNSqlJetDb.open(file2, SVNSqlJetDb$Mode.ReadWrite);
            sVNSqlJetDb.beginTransaction(SqlJetTransactionMode.WRITE);
            try {
                SvnNgUpgradeSDb.setVersion(sVNSqlJetDb, this.getVersion());
            }
            finally {
                sVNSqlJetDb.commit();
            }
        }
        return null;
    }

    @Override
    protected void initDefaults() {
        super.initDefaults();
        this.setVersion(31);
    }

    @Override
    protected void ensureArgumentsAreValid() {
        super.ensureArgumentsAreValid();
        if (this.getVersion() != 29 && this.getVersion() != 31) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "wc.db version could only be {1} or {2}.", new Object[]{29, 31});
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }
}

