/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnSetChangelist
extends SvnOperation {
    private String changelistName;
    private boolean remove;

    protected SvnSetChangelist(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public void setChangelistName(String string) {
        this.changelistName = string;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean bl2) {
        this.remove = bl2;
    }

    @Override
    protected void ensureArgumentsAreValid() {
        SVNErrorMessage sVNErrorMessage;
        super.ensureArgumentsAreValid();
        if (!this.isRemove() && "".equals(this.getChangelistName())) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_CHANGELIST_NAME, "Target changelist name must not be empty");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (this.hasRemoteTargets()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)this.getFirstTarget().getURL());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    @Override
    protected int getMaximumTargetsCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return true;
    }
}

