/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnOperation
implements ISvnOperationOptionsProvider {
    private SVNDepth depth;
    private Collection targets;
    private SVNRevision revision;
    private Collection changelists;
    private SvnOperationFactory operationFactory;
    private boolean isSleepForTimestamp;
    private SqlJetPagerJournalMode sqliteJournalMode;
    private volatile boolean isCancelled;

    protected SvnOperation(SvnOperationFactory svnOperationFactory) {
        this.operationFactory = svnOperationFactory;
        this.initDefaults();
    }

    @Override
    public ISVNEventHandler getEventHandler() {
        return this.getOperationFactory().getEventHandler();
    }

    @Override
    public ISVNOptions getOptions() {
        return this.getOperationFactory().getOptions();
    }

    protected void initDefaults() {
        this.setDepth(SVNDepth.UNKNOWN);
        this.setSleepForTimestamp(true);
        this.setRevision(SVNRevision.UNDEFINED);
        this.targets = new ArrayList();
    }

    public void setSingleTarget(SvnTarget svnTarget) {
        this.targets = new ArrayList();
        if (svnTarget != null) {
            this.targets.add(svnTarget);
        }
    }

    public void addTarget(SvnTarget svnTarget) {
        this.targets.add(svnTarget);
    }

    public Collection getTargets() {
        return Collections.unmodifiableCollection(this.targets);
    }

    public SvnTarget getFirstTarget() {
        return this.targets != null && !this.targets.isEmpty() ? (SvnTarget)this.targets.iterator().next() : null;
    }

    public void setDepth(SVNDepth sVNDepth) {
        this.depth = sVNDepth;
    }

    public SVNDepth getDepth() {
        return this.depth;
    }

    public void setRevision(SVNRevision sVNRevision) {
        this.revision = sVNRevision;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public void setApplicalbeChangelists(Collection collection) {
        this.changelists = collection;
    }

    public Collection getApplicableChangelists() {
        if (this.changelists == null || this.changelists.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableCollection(this.changelists);
    }

    public SvnOperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    public boolean hasLocalTargets() {
        for (SvnTarget svnTarget : this.getTargets()) {
            if (!svnTarget.isLocal()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRemoteTargets() {
        for (SvnTarget svnTarget : this.getTargets()) {
            if (svnTarget.isLocal()) continue;
            return true;
        }
        return false;
    }

    protected void ensureEnoughTargets() {
        SVNErrorMessage sVNErrorMessage;
        int n2 = this.getTargets().size();
        if (n2 < this.getMinimumTargetsCount()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Wrong number of targets has been specified ({0}), at least {1} is required.", new Object[]{n2, this.getMinimumTargetsCount()}, 0);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (n2 > this.getMaximumTargetsCount()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Wrong number of targets has been specified ({0}), no more that {1} may be specified.", new Object[]{n2, this.getMaximumTargetsCount()}, 0);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    protected int getMinimumTargetsCount() {
        return 1;
    }

    protected int getMaximumTargetsCount() {
        return 1;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public Object run() {
        this.ensureArgumentsAreValid();
        return this.getOperationFactory().run(this);
    }

    protected void ensureArgumentsAreValid() {
        this.ensureEnoughTargets();
        this.ensureHomohenousTargets();
    }

    protected boolean needsHomohenousTargets() {
        return true;
    }

    protected void ensureHomohenousTargets() {
        if (this.getTargets().size() <= 1) {
            return;
        }
        if (!this.needsHomohenousTargets()) {
            return;
        }
        if (this.hasLocalTargets() && this.hasRemoteTargets()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot mix repository and working copy targets"), SVNLogType.WC);
        }
    }

    @Override
    public ISVNRepositoryPool getRepositoryPool() {
        return this.getOperationFactory().getRepositoryPool();
    }

    @Override
    public ISVNAuthenticationManager getAuthenticationManager() {
        return this.getOperationFactory().getAuthenticationManager();
    }

    @Override
    public ISVNCanceller getCanceller() {
        return this.getOperationFactory().getCanceller();
    }

    public boolean isSleepForTimestamp() {
        return this.isSleepForTimestamp;
    }

    public void setSleepForTimestamp(boolean bl2) {
        this.isSleepForTimestamp = bl2;
    }

    public boolean hasFileTargets() {
        for (SvnTarget svnTarget : this.getTargets()) {
            if (!svnTarget.isFile()) continue;
            return true;
        }
        return false;
    }

    public boolean isUseParentWcFormat() {
        return false;
    }

    public boolean isChangesWorkingCopy() {
        return true;
    }

    public SqlJetPagerJournalMode getSqliteJournalMode() {
        return this.sqliteJournalMode;
    }

    public void setSqliteJournalMode(SqlJetPagerJournalMode sqlJetPagerJournalMode) {
        this.sqliteJournalMode = sqlJetPagerJournalMode;
    }

    protected File getOperationalWorkingCopy() {
        if (this.hasFileTargets()) {
            return this.getFirstTarget().getFile();
        }
        return null;
    }
}

