/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnMerge
extends SvnOperation {
    public static final boolean EMULATE_AUTOMATIC_MERGE = true;
    private SvnTarget firstSource;
    private SvnTarget secondSource;
    private boolean ignoreMergeInfo;
    private boolean ignoreAncestry;
    private boolean force;
    private boolean recordOnly;
    private boolean dryRun;
    private boolean allowMixedRevisions;
    private SvnTarget source;
    private boolean reintegrate;
    private Collection ranges;
    private SVNDiffOptions mergeOptions;

    protected SvnMerge(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public void addRevisionRange(SvnRevisionRange svnRevisionRange) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        SVNRevision sVNRevision = svnRevisionRange.getStart();
        SVNRevision sVNRevision2 = svnRevisionRange.getEnd();
        if (sVNRevision == SVNRevision.UNDEFINED && sVNRevision2 == SVNRevision.UNDEFINED) {
            sVNRevision = SVNRevision.create(0L);
            sVNRevision2 = this.getSource().getResolvedPegRevision();
            svnRevisionRange = SvnRevisionRange.create(sVNRevision, sVNRevision2);
        }
        this.ranges.add(svnRevisionRange);
    }

    public Collection getRevisionRanges() {
        if (this.ranges == null) {
            SvnTarget svnTarget = this.getSource();
            SVNRevision sVNRevision = SVNRevision.create(1L);
            SVNRevision sVNRevision2 = svnTarget.getPegRevision();
            if (sVNRevision2 == null || sVNRevision2 == SVNRevision.UNDEFINED) {
                sVNRevision2 = svnTarget.isURL() ? SVNRevision.HEAD : SVNRevision.WORKING;
            }
            ArrayList<SvnRevisionRange> arrayList = new ArrayList<SvnRevisionRange>();
            arrayList.add(SvnRevisionRange.create(sVNRevision, sVNRevision2));
            return arrayList;
        }
        return this.ranges;
    }

    public void setSource(SvnTarget svnTarget, boolean bl2) {
        this.source = svnTarget;
        this.reintegrate = bl2;
        if (svnTarget != null) {
            this.setSources(null, null);
        }
    }

    public void setSources(SvnTarget svnTarget, SvnTarget svnTarget2) {
        this.firstSource = svnTarget;
        this.secondSource = svnTarget2;
        if (this.firstSource != null) {
            this.setSource(null, false);
        }
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public SvnTarget getFirstSource() {
        return this.firstSource;
    }

    public SvnTarget getSecondSource() {
        return this.secondSource;
    }

    public boolean isReintegrate() {
        return this.reintegrate;
    }

    public boolean isIgnoreMergeInfo() {
        return this.ignoreMergeInfo;
    }

    public void setIgnoreMergeInfo(boolean bl2) {
        this.ignoreMergeInfo = bl2;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public void setIgnoreAncestry(boolean bl2) {
        this.ignoreAncestry = bl2;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean bl2) {
        this.force = bl2;
    }

    public boolean isRecordOnly() {
        return this.recordOnly;
    }

    public void setRecordOnly(boolean bl2) {
        this.recordOnly = bl2;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean bl2) {
        this.dryRun = bl2;
    }

    public boolean isAllowMixedRevisions() {
        return this.allowMixedRevisions;
    }

    public void setAllowMixedRevisions(boolean bl2) {
        this.allowMixedRevisions = bl2;
    }

    public SVNDiffOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public void setMergeOptions(SVNDiffOptions sVNDiffOptions) {
        this.mergeOptions = sVNDiffOptions;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return true;
    }
}

