/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnReceivingOperation;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnLog
extends SvnReceivingOperation {
    private long limit;
    private boolean useMergeHistory;
    private boolean stopOnCopy;
    private boolean discoverChangedPaths;
    private String[] targetPaths;
    private String[] revisionProperties;
    private Collection revisionRanges;

    protected SvnLog(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long l2) {
        this.limit = l2;
    }

    public boolean isUseMergeHistory() {
        return this.useMergeHistory;
    }

    public void setUseMergeHistory(boolean bl2) {
        this.useMergeHistory = bl2;
    }

    public boolean isDiscoverChangedPaths() {
        return this.discoverChangedPaths;
    }

    public void setDiscoverChangedPaths(boolean bl2) {
        this.discoverChangedPaths = bl2;
    }

    public boolean isStopOnCopy() {
        return this.stopOnCopy;
    }

    public void setStopOnCopy(boolean bl2) {
        this.stopOnCopy = bl2;
    }

    public Collection getRevisionRanges() {
        return this.revisionRanges;
    }

    public void setRevisionRanges(Collection collection) {
        this.revisionRanges = collection;
    }

    public String[] getTargetPaths() {
        return this.targetPaths;
    }

    public void setTargetPaths(String[] stringArray) {
        this.targetPaths = stringArray;
    }

    public String[] getRevisionProperties() {
        return this.revisionProperties;
    }

    public void setRevisionProperties(String[] stringArray) {
        this.revisionProperties = stringArray;
    }

    @Override
    protected void ensureArgumentsAreValid() {
        SVNErrorMessage sVNErrorMessage;
        super.ensureArgumentsAreValid();
        if (this.getLimit() > Long.MAX_VALUE) {
            this.setLimit(Long.MAX_VALUE);
        }
        if (this.getRevisionRanges() == null || this.getRevisionRanges().size() == 0) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Missing required revision specification");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (this.hasRemoteTargets() && this.getTargets().size() > 1) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "When specifying URL, only one target may be given.");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
        }
    }

    public void addRange(SvnRevisionRange svnRevisionRange) {
        if (svnRevisionRange != null) {
            if (this.getRevisionRanges() == null) {
                this.revisionRanges = new ArrayList();
            }
            this.revisionRanges.add(svnRevisionRange);
        }
    }

    @Override
    protected int getMaximumTargetsCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return false;
    }
}

