/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnReceivingOperation;
import org.tmatesoft.svn.core.wc2.hooks.ISvnFileListHook;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnGetStatus
extends SvnReceivingOperation {
    private boolean remote;
    private boolean depthAsSticky;
    private boolean reportIgnored;
    private boolean reportAll;
    private boolean reportExternals;
    private ISvnFileListHook fileListHook;
    private boolean collectParentExternals;
    private long remoteRevision;
    private boolean checkWorkingCopy = true;

    protected SvnGetStatus(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isDepthAsSticky() {
        return this.depthAsSticky;
    }

    public boolean isReportIgnored() {
        return this.reportIgnored;
    }

    public boolean isReportAll() {
        return this.reportAll;
    }

    public boolean isReportExternals() {
        return this.reportExternals;
    }

    public ISvnFileListHook getFileListHook() {
        return this.fileListHook;
    }

    public void setRemote(boolean bl2) {
        this.remote = bl2;
    }

    public void setDepthAsSticky(boolean bl2) {
        this.depthAsSticky = bl2;
    }

    public void setReportIgnored(boolean bl2) {
        this.reportIgnored = bl2;
    }

    public void setReportAll(boolean bl2) {
        this.reportAll = bl2;
    }

    public void setReportExternals(boolean bl2) {
        this.reportExternals = bl2;
    }

    public void setFileListHook(ISvnFileListHook iSvnFileListHook) {
        this.fileListHook = iSvnFileListHook;
    }

    @Override
    protected void ensureArgumentsAreValid() {
        super.ensureArgumentsAreValid();
        this.setRemoteRevision(-1L);
        if (this.hasRemoteTargets()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)this.getFirstTarget().getURL());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setRevision(SVNRevision.HEAD);
        this.setReportAll(true);
        this.setReportIgnored(true);
        this.setReportExternals(true);
        this.setRemoteRevision(-1L);
    }

    public boolean isCollectParentExternals() {
        return this.collectParentExternals;
    }

    public void setCollectParentExternals(boolean bl2) {
        this.collectParentExternals = bl2;
    }

    public void setRemoteRevision(long l2) {
        this.remoteRevision = l2;
    }

    public long getRemoteRevision() {
        return this.remoteRevision;
    }

    public boolean isCheckWorkingCopy() {
        return this.checkWorkingCopy;
    }

    public void setCheckWorkingCopy(boolean bl2) {
        this.checkWorkingCopy = bl2;
    }

    @Override
    public boolean isUseParentWcFormat() {
        return true;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return false;
    }
}

