/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.AbstractSvnUpdate;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnExport
extends AbstractSvnUpdate {
    private boolean force;
    private boolean expandKeywords;
    private String eolStyle;
    private SvnTarget source;

    protected SvnExport(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isExpandKeywords() {
        return this.expandKeywords;
    }

    public String getEolStyle() {
        return this.eolStyle;
    }

    public void setForce(boolean bl2) {
        this.force = bl2;
    }

    public void setExpandKeywords(boolean bl2) {
        this.expandKeywords = bl2;
    }

    public void setEolStyle(String string) {
        this.eolStyle = string;
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public void setSource(SvnTarget svnTarget) {
        this.source = svnTarget;
    }

    @Override
    protected void ensureArgumentsAreValid() {
        SVNErrorMessage sVNErrorMessage;
        if (this.getFirstTarget() == null || !this.getFirstTarget().isLocal()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Destination path is required for export.");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (this.getSource() == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Source is required for export.");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (this.getDepth() == null || this.getDepth() == SVNDepth.UNKNOWN) {
            this.setDepth(SVNDepth.INFINITY);
        }
        if (this.getRevision() == SVNRevision.UNDEFINED) {
            this.setRevision(this.getSource().getResolvedPegRevision());
        }
        super.ensureArgumentsAreValid();
    }

    @Override
    protected void initDefaults() {
        super.initDefaults();
        this.setExpandKeywords(true);
        this.setDepth(SVNDepth.INFINITY);
    }

    @Override
    protected File getOperationalWorkingCopy() {
        if (this.getSource().isLocal()) {
            return this.getSource().getFile();
        }
        return null;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return true;
    }
}

