/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnReceivingOperation;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffSummarize
extends SvnReceivingOperation {
    private SvnTarget firstSource;
    private SvnTarget secondSource;
    private SvnTarget source;
    private SVNRevision startRevision;
    private SVNRevision endRevision;
    private boolean ignoreAncestry;
    private boolean recurseIntoDeletedDirectories;

    protected SvnDiffSummarize(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
        this.setRecurseIntoDeletedDirectories(true);
    }

    public void setSource(SvnTarget svnTarget, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        this.source = svnTarget;
        this.startRevision = sVNRevision;
        this.endRevision = sVNRevision2;
        if (svnTarget != null) {
            this.setSources(null, null);
        }
    }

    public void setSources(SvnTarget svnTarget, SvnTarget svnTarget2) {
        this.firstSource = svnTarget;
        this.secondSource = svnTarget2;
        if (this.firstSource != null) {
            this.setSource(null, null, null);
        }
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public SVNRevision getStartRevision() {
        return this.startRevision;
    }

    public SVNRevision getEndRevision() {
        return this.endRevision;
    }

    public SvnTarget getFirstSource() {
        return this.firstSource;
    }

    public SvnTarget getSecondSource() {
        return this.secondSource;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public void setIgnoreAncestry(boolean bl2) {
        this.ignoreAncestry = bl2;
    }

    public boolean isRecurseIntoDeletedDirectories() {
        return this.recurseIntoDeletedDirectories;
    }

    public void setRecurseIntoDeletedDirectories(boolean bl2) {
        this.recurseIntoDeletedDirectories = bl2;
    }

    @Override
    protected File getOperationalWorkingCopy() {
        if (this.getSource() != null && this.getSource().isFile()) {
            return this.getSource().getFile();
        }
        if (this.getFirstSource() != null && this.getFirstSource().isFile()) {
            return this.getFirstSource().getFile();
        }
        if (this.getSecondSource() != null && this.getSecondSource().isFile()) {
            return this.getSecondSource().getFile();
        }
        return null;
    }

    @Override
    protected void ensureArgumentsAreValid() {
        if (this.getSource() == null || this.getSource().getPegRevision() == null || this.getSource().getPegRevision() == SVNRevision.UNDEFINED) {
            SvnTarget svnTarget = this.getFirstSource();
            SvnTarget svnTarget2 = this.getSecondSource();
            this.ensureArgumentsAreValid(svnTarget.getURL(), svnTarget.getFile(), svnTarget.getPegRevision(), svnTarget2.getURL(), svnTarget2.getFile(), svnTarget2.getPegRevision(), null);
        } else {
            SvnTarget svnTarget = this.getSource();
            this.ensureArgumentsAreValid(svnTarget.getURL(), svnTarget.getFile(), this.getStartRevision(), svnTarget.getURL(), svnTarget.getFile(), this.getEndRevision(), svnTarget.getPegRevision());
        }
    }

    private void ensureArgumentsAreValid(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNURL sVNURL2, File file2, SVNRevision sVNRevision2, SVNRevision sVNRevision3) {
        boolean bl2;
        boolean bl3;
        SVNErrorMessage sVNErrorMessage;
        boolean bl4;
        if (sVNRevision3 == null) {
            sVNRevision3 = SVNRevision.UNDEFINED;
        }
        this.ensureRevisionIsValid(sVNRevision);
        this.ensureRevisionIsValid(sVNRevision2);
        boolean bl5 = this.startRevision == SVNRevision.WORKING || this.startRevision == SVNRevision.BASE;
        boolean bl6 = bl4 = this.endRevision == SVNRevision.WORKING || this.endRevision == SVNRevision.BASE;
        if (sVNRevision3 != SVNRevision.UNDEFINED) {
            if (bl5 && bl4) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            }
            bl3 = !bl5;
            bl2 = !bl4;
        } else {
            bl3 = !bl5 || sVNURL != null;
            boolean bl7 = bl2 = !bl4 || sVNURL2 != null;
        }
        if (!bl3 || !bl2) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    private void ensureRevisionIsValid(SVNRevision sVNRevision) {
        boolean bl2;
        boolean bl3 = bl2 = sVNRevision != null && sVNRevision.isValid();
        if (!bl2) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return false;
    }
}

