/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNewDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnOldDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiff
extends SvnOperation {
    private ISvnDiffGenerator diffGenerator;
    private SVNDiffOptions diffOptions;
    private OutputStream output;
    private SvnTarget source;
    private SvnTarget firstSource;
    private SvnTarget secondSource;
    private SVNRevision startRevision;
    private SVNRevision endRevision;
    private boolean ignoreAncestry;
    private boolean noDiffDeleted;
    private boolean showCopiesAsAdds;
    private boolean ignoreContentType;
    private File relativeToDirectory;
    private boolean useGitDiffFormat;
    private boolean recurseIntoDeletedDirectories;

    protected SvnDiff(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
        this.setIgnoreAncestry(true);
        this.setRecurseIntoDeletedDirectories(true);
    }

    public void setSource(SvnTarget svnTarget, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        this.source = svnTarget;
        this.startRevision = sVNRevision;
        this.endRevision = sVNRevision2;
        if (svnTarget != null) {
            this.setSources(null, null);
        }
    }

    public void setSources(SvnTarget svnTarget, SvnTarget svnTarget2) {
        this.firstSource = svnTarget;
        this.secondSource = svnTarget2;
        if (this.firstSource != null) {
            this.setSource(null, null, null);
        }
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public SVNRevision getStartRevision() {
        return this.startRevision;
    }

    public SVNRevision getEndRevision() {
        return this.endRevision;
    }

    public SvnTarget getFirstSource() {
        return this.firstSource;
    }

    public SvnTarget getSecondSource() {
        return this.secondSource;
    }

    public void setRelativeToDirectory(File file) {
        this.relativeToDirectory = file;
    }

    public File getRelativeToDirectory() {
        return this.relativeToDirectory;
    }

    public ISvnDiffGenerator getDiffGenerator() {
        return this.diffGenerator;
    }

    public void setDiffGenerator(ISVNDiffGenerator iSVNDiffGenerator) {
        if (iSVNDiffGenerator == null) {
            this.setDiffGenerator((ISvnDiffGenerator)null);
        } else if (iSVNDiffGenerator instanceof SvnNewDiffGenerator) {
            this.setDiffGenerator(((SvnNewDiffGenerator)iSVNDiffGenerator).getDelegate());
        } else {
            this.setDiffGenerator(new SvnOldDiffGenerator(iSVNDiffGenerator));
        }
    }

    public void setDiffGenerator(ISvnDiffGenerator iSvnDiffGenerator) {
        this.diffGenerator = iSvnDiffGenerator;
    }

    public SVNDiffOptions getDiffOptions() {
        return this.diffOptions;
    }

    public void setDiffOptions(SVNDiffOptions sVNDiffOptions) {
        this.diffOptions = sVNDiffOptions;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void setOutput(OutputStream outputStream) {
        this.output = outputStream;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public void setIgnoreAncestry(boolean bl2) {
        this.ignoreAncestry = bl2;
    }

    public boolean isNoDiffDeleted() {
        return this.noDiffDeleted;
    }

    public void setNoDiffDeleted(boolean bl2) {
        this.noDiffDeleted = bl2;
    }

    public boolean isShowCopiesAsAdds() {
        return this.showCopiesAsAdds;
    }

    public void setShowCopiesAsAdds(boolean bl2) {
        this.showCopiesAsAdds = bl2;
    }

    public boolean isIgnoreContentType() {
        return this.ignoreContentType;
    }

    public void setIgnoreContentType(boolean bl2) {
        this.ignoreContentType = bl2;
    }

    public boolean isUseGitDiffFormat() {
        return this.useGitDiffFormat;
    }

    public void setUseGitDiffFormat(boolean bl2) {
        this.useGitDiffFormat = bl2;
    }

    public boolean isRecurseIntoDeletedDirectories() {
        return this.recurseIntoDeletedDirectories;
    }

    public void setRecurseIntoDeletedDirectories(boolean bl2) {
        this.recurseIntoDeletedDirectories = bl2;
    }

    @Override
    protected int getMinimumTargetsCount() {
        return super.getMinimumTargetsCount();
    }

    @Override
    protected int getMaximumTargetsCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void ensureArgumentsAreValid() {
        SVNErrorMessage sVNErrorMessage;
        if (this.getRelativeToDirectory() != null && this.hasRemoteTargets()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Relative directory cannot be specified with remote targets");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
        }
        if (this.getOutput() == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "No output is specified.");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
        }
    }

    @Override
    protected File getOperationalWorkingCopy() {
        if (this.getSource() != null && this.getSource().isFile()) {
            return this.getSource().getFile();
        }
        if (this.getFirstSource() != null && this.getFirstSource().isFile()) {
            return this.getFirstSource().getFile();
        }
        if (this.getSecondSource() != null && this.getSecondSource().isFile()) {
            return this.getSecondSource().getFile();
        }
        return null;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return false;
    }
}

