/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ISvnCommitRunner;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec$SVNCommitPacketWrapper;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;

public class SvnCommitPacket {
    private Map items;
    private Map itemsByPath;
    private Object lockingContext;
    private ISvnCommitRunner runner;
    private Map lockTokens;
    private Set skippedPaths;
    private AtomicInteger sharedIndex;

    public SvnCommitPacket() {
        this.items = new HashMap();
        this.itemsByPath = new HashMap();
        this.lockTokens = new HashMap();
        this.skippedPaths = new HashSet();
    }

    private SvnCommitPacket(Map map, Map map2, Object object, Map map3, ISvnCommitRunner iSvnCommitRunner, Set set) {
        this.items = map;
        this.itemsByPath = map2;
        this.lockingContext = object;
        this.lockTokens = map3;
        this.runner = iSvnCommitRunner;
        this.skippedPaths = set;
    }

    public boolean hasItem(File file) {
        return this.itemsByPath.containsKey(SVNFileUtil.getFilePath(file));
    }

    public SvnCommitItem getItem(File file) {
        return (SvnCommitItem)this.itemsByPath.get(SVNFileUtil.getFilePath(file));
    }

    public Collection getRepositoryRoots() {
        return Collections.unmodifiableCollection(this.items.keySet());
    }

    public Collection getItems(SVNURL sVNURL) {
        return Collections.unmodifiableCollection((Collection)this.items.get(sVNURL));
    }

    public void addItem(SvnCommitItem svnCommitItem, SVNURL sVNURL) {
        if (!this.items.containsKey(sVNURL)) {
            this.items.put(sVNURL, new HashSet());
        }
        ((Collection)this.items.get(sVNURL)).add(svnCommitItem);
        this.itemsByPath.put(svnCommitItem.getPath() != null ? SVNFileUtil.getFilePath(svnCommitItem.getPath()) : null, svnCommitItem);
    }

    public SvnCommitItem addItem(File file, SVNNodeKind sVNNodeKind, SVNURL sVNURL, String string, long l2, String string2, long l3, File file2, int n2) {
        SvnCommitItem svnCommitItem = new SvnCommitItem();
        svnCommitItem.setPath(file);
        svnCommitItem.setKind(sVNNodeKind);
        svnCommitItem.setUrl(sVNURL.appendPath(string, false));
        svnCommitItem.setRevision(l2);
        if (string2 != null) {
            svnCommitItem.setCopyFromUrl(sVNURL.appendPath(string2, false));
            svnCommitItem.setCopyFromRevision(l3);
        } else {
            svnCommitItem.setCopyFromRevision(-1L);
        }
        svnCommitItem.setMovedFromAbsPath(file2);
        svnCommitItem.setFlags(n2);
        this.addItem(svnCommitItem, sVNURL);
        return svnCommitItem;
    }

    public SvnCommitItem addItem(File file, SVNURL sVNURL, SVNNodeKind sVNNodeKind, SVNURL sVNURL2, long l2, SVNURL sVNURL3, long l3, int n2) {
        SvnCommitItem svnCommitItem = new SvnCommitItem();
        svnCommitItem.setPath(file);
        svnCommitItem.setKind(sVNNodeKind);
        svnCommitItem.setUrl(sVNURL2);
        svnCommitItem.setRevision(l2);
        if (sVNURL3 != null) {
            svnCommitItem.setCopyFromUrl(sVNURL3);
            svnCommitItem.setCopyFromRevision(l3);
        } else {
            svnCommitItem.setCopyFromRevision(-1L);
        }
        svnCommitItem.setFlags(n2);
        if (!this.items.containsKey(sVNURL)) {
            this.items.put(sVNURL, new HashSet());
        }
        ((Collection)this.items.get(sVNURL)).add(svnCommitItem);
        this.itemsByPath.put(SVNFileUtil.getFilePath(file), svnCommitItem);
        return svnCommitItem;
    }

    public void setLockingContext(ISvnCommitRunner iSvnCommitRunner, Object object) {
        this.lockingContext = object;
        this.runner = iSvnCommitRunner;
    }

    public void dispose() {
        try {
            if (this.runner != null) {
                this.runner.disposeCommitPacket(this.lockingContext, this.isLastPacket());
            }
        }
        finally {
            if (this.sharedIndex != null) {
                this.sharedIndex.decrementAndGet();
            }
            if (this.items != null) {
                this.items.clear();
            }
            if (this.itemsByPath != null) {
                this.itemsByPath.clear();
            }
            this.runner = null;
            this.lockingContext = null;
        }
    }

    public void setLockTokens(Map map) {
        this.lockTokens = map;
    }

    public Map getLockTokens() {
        return this.lockTokens;
    }

    public boolean isEmpty() {
        for (SVNURL sVNURL : this.getRepositoryRoots()) {
            if (this.isEmpty(sVNURL)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(SVNURL sVNURL) {
        for (SvnCommitItem svnCommitItem : this.getItems(sVNURL)) {
            if (svnCommitItem.getFlags() == 32) continue;
            return false;
        }
        return true;
    }

    public Object getLockingContext() {
        return this.lockingContext;
    }

    public ISvnCommitRunner getRunner() {
        return this.runner;
    }

    public void setItemSkipped(File file, boolean bl2) {
        SvnCommitItem svnCommitItem;
        String string = SVNFileUtil.getFilePath(file);
        if (bl2) {
            this.skippedPaths.add(string);
        } else {
            this.skippedPaths.remove(string);
        }
        if (this.lockingContext != null && this.lockingContext instanceof SVNCommitPacket && !(this.lockingContext instanceof SvnCodec$SVNCommitPacketWrapper) && (svnCommitItem = (SvnCommitItem)this.itemsByPath.get(string)) != null) {
            SVNCommitItem[] sVNCommitItemArray;
            SVNCommitPacket sVNCommitPacket = (SVNCommitPacket)this.lockingContext;
            for (SVNCommitItem sVNCommitItem : sVNCommitItemArray = sVNCommitPacket.getCommitItems()) {
                if (!SVNFileUtil.getFilePath(sVNCommitItem.getFile()).equals(string)) continue;
                sVNCommitPacket.setCommitItemSkipped(sVNCommitItem, true);
                break;
            }
        }
    }

    public boolean isItemSkipped(File file) {
        return this.skippedPaths.contains(SVNFileUtil.getFilePath(file));
    }

    public SvnCommitPacket removeSkippedItems() {
        Object object;
        Object object2;
        HashMap<Object, SvnCommitItem> hashMap = new HashMap<Object, SvnCommitItem>();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap(this.lockTokens);
        Object object3 = this.lockingContext;
        for (Map.Entry entry : this.itemsByPath.entrySet()) {
            object2 = (String)entry.getKey();
            object = (SvnCommitItem)entry.getValue();
            if (this.skippedPaths.contains(object2)) continue;
            hashMap.put(object2, (SvnCommitItem)object);
        }
        for (Map.Entry entry : this.items.entrySet()) {
            object2 = (SVNURL)entry.getKey();
            object = (Collection)entry.getValue();
            ArrayList<SvnCommitItem> arrayList = new ArrayList<SvnCommitItem>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SvnCommitItem svnCommitItem = (SvnCommitItem)iterator.next();
                String string = SVNFileUtil.getFilePath(svnCommitItem.getPath());
                if (!this.skippedPaths.contains(string)) {
                    arrayList.add(svnCommitItem);
                    continue;
                }
                this.lockTokens.remove(svnCommitItem.getUrl());
            }
            if (arrayList.size() <= 0) continue;
            hashMap2.put(object2, arrayList);
        }
        SvnCommitPacket svnCommitPacket = new SvnCommitPacket(hashMap2, hashMap, object3, hashMap3, this.runner, this.skippedPaths);
        svnCommitPacket.sharedIndex = this.sharedIndex;
        return svnCommitPacket;
    }

    SvnCommitPacket[] split(boolean bl2) {
        HashMap<String, SvnCommitPacket> hashMap = new HashMap<String, SvnCommitPacket>();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        for (Object object : this.getRepositoryRoots()) {
            Collection collection = this.getItems((SVNURL)object);
            for (SvnCommitItem svnCommitItem : collection) {
                if (this.isItemSkipped(svnCommitItem.getPath())) continue;
                String string = this.getItemKey(svnCommitItem, (SVNURL)object, bl2);
                if (!hashMap.containsKey(string)) {
                    SvnCommitPacket svnCommitPacket = new SvnCommitPacket();
                    svnCommitPacket.runner = this.runner;
                    svnCommitPacket.sharedIndex = atomicInteger;
                    svnCommitPacket.setLockTokens(this.getLockTokens());
                    atomicInteger.incrementAndGet();
                    hashMap.put(string, svnCommitPacket);
                }
                ((SvnCommitPacket)hashMap.get(string)).addItem(svnCommitItem, (SVNURL)object);
            }
        }
        for (Object object : hashMap.values()) {
            ((SvnCommitPacket)object).lockingContext = this.lockingContext;
        }
        return hashMap.values().toArray(new SvnCommitPacket[hashMap.size()]);
    }

    private String getItemKey(SvnCommitItem svnCommitItem, SVNURL sVNURL, boolean bl2) {
        if (bl2) {
            return sVNURL.toString();
        }
        File file = SvnOperationFactory.getWorkingCopyRoot(svnCommitItem.getKind() == SVNNodeKind.FILE ? svnCommitItem.getPath().getParentFile() : svnCommitItem.getPath(), true);
        return sVNURL.toString() + ":" + file.getAbsolutePath();
    }

    public boolean isLastPacket() {
        return this.sharedIndex == null || this.sharedIndex.get() == 1;
    }
}

