/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.AbstractSvnUpdate;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnCheckout
extends AbstractSvnUpdate {
    private SvnTarget source;
    private int targetWorkingCopyFormat = -1;

    protected SvnCheckout(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public void setSource(SvnTarget svnTarget) {
        this.source = svnTarget;
    }

    @Override
    protected void ensureArgumentsAreValid() {
        SVNErrorMessage sVNErrorMessage;
        super.ensureArgumentsAreValid();
        if (this.getRevision() == null) {
            this.setRevision(SVNRevision.UNDEFINED);
        }
        if (this.getSource() == null || !this.getSource().isURL() || this.getSource().getURL() == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (!this.getRevision().isValid() && this.getFirstTarget() != null) {
            this.setRevision(this.getSource().getResolvedPegRevision());
        }
        if (!this.getRevision().isValid()) {
            this.setRevision(SVNRevision.HEAD);
        }
        if (this.getFirstTarget() == null || this.getFirstTarget().getFile() == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "Checkout destination path can not be NULL");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (this.getRevision().getNumber() < 0L && this.getRevision().getDate() == null && this.getRevision() != SVNRevision.HEAD) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return true;
    }

    public void setTargetWorkingCopyFormat(int n2) {
        this.targetWorkingCopyFormat = n2;
    }

    public int getTargetWorkingCopyFormat() {
        return this.targetWorkingCopyFormat;
    }
}

