/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import java.util.Date;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNDate;

public class SvnAnnotateItem {
    private long revision;
    private SVNProperties revisionProperties;
    private SVNProperties mergedRevisionProperties;
    private String line;
    private long mergedRevision;
    private String mergedPath;
    private int lineNumber;
    private File contents;
    private boolean isEof;
    private boolean isRevision;
    private boolean isLine;
    private boolean returnResult;

    public SvnAnnotateItem(boolean bl2) {
        this.isEof = true;
    }

    public SvnAnnotateItem(Date date, long l2, String string, String string2, Date date2, long l3, String string3, String string4, int n2) {
        this.isLine = true;
        this.revisionProperties = this.createRevisionProperties(string, date);
        this.revision = l2;
        this.line = string2;
        this.mergedRevisionProperties = this.createRevisionProperties(string3, date2);
        this.mergedRevision = l3;
        this.mergedPath = string4;
        this.lineNumber = n2;
    }

    public SvnAnnotateItem(Date date, long l2, String string, File file) {
        this.isRevision = true;
        this.revisionProperties = this.createRevisionProperties(string, date);
        this.revision = l2;
        this.contents = file;
    }

    public Date getDate() {
        return this.getDate(this.getRevisionProperties());
    }

    public long getRevision() {
        return this.revision;
    }

    public SVNProperties getRevisionProperties() {
        return this.revisionProperties;
    }

    public String getAuthor() {
        return this.getAuthor(this.getRevisionProperties());
    }

    public Date getMergedDate() {
        return this.getDate(this.getMergedRevisionProperties());
    }

    public String getLine() {
        return this.line;
    }

    public long getMergedRevision() {
        return this.mergedRevision;
    }

    public SVNProperties getMergedRevisionProperties() {
        return this.mergedRevisionProperties;
    }

    public String getMergedAuthor() {
        return this.getAuthor(this.getMergedRevisionProperties());
    }

    public String getMergedPath() {
        return this.mergedPath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public File getContents() {
        return this.contents;
    }

    public boolean isEof() {
        return this.isEof;
    }

    public boolean isLine() {
        return this.isLine;
    }

    public boolean isRevision() {
        return this.isRevision;
    }

    public void setReturnResult(boolean bl2) {
        this.returnResult = bl2;
    }

    public boolean getReturnResult() {
        return this.returnResult;
    }

    private SVNProperties createRevisionProperties(String string, Date date) {
        if (string == null && date == null) {
            return null;
        }
        SVNProperties sVNProperties = new SVNProperties();
        if (string != null) {
            sVNProperties.put("svn:author", string);
        }
        if (date != null) {
            sVNProperties.put("svn:date", SVNDate.fromDate(date).format());
        }
        return sVNProperties;
    }

    private String getAuthor(SVNProperties sVNProperties) {
        if (sVNProperties == null) {
            return null;
        }
        return sVNProperties.getStringValue("svn:author");
    }

    private Date getDate(SVNProperties sVNProperties) {
        if (sVNProperties == null) {
            return null;
        }
        String string = sVNProperties.getStringValue("svn:date");
        if (string == null) {
            return null;
        }
        return SVNDate.parseDate(string);
    }
}

