/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLStatusHandler
extends AbstractXMLHandler
implements ISVNStatusHandler {
    private static final String AGAINST_TAG = "against";
    private static final String TARGET_TAG = "target";
    public static final String EXPIRES_TAG = "expires";
    public static final String CREATED_TAG = "created";
    public static final String COMMENT_TAG = "comment";
    public static final String OWNER_TAG = "owner";
    public static final String TOKEN_TAG = "token";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    public static final String REMOTE_STATUS_TAG = "repos-status";
    public static final String LOCK_TAG = "lock";
    public static final String COMMIT_TAG = "commit";
    public static final String WC_STATUS_TAG = "wc-status";
    public static final String ENTRY_TAG = "entry";
    public static final String STATUS_TAG = "status";
    public static final String REVISION_ATTR = "revision";
    public static final String SWITCHED_ATTR = "switched";
    public static final String COPIED_ATTR = "copied";
    public static final String WC_LOCKED_ATTR = "wc-locked";
    public static final String PROPS_ATTR = "props";
    public static final String ITEM_ATTR = "item";
    public static final String PATH_ATTR = "path";
    private static final String TRUE = "true";
    private File myTargetPath;

    public SVNXMLStatusHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLStatusHandler(ContentHandler contentHandler, ISVNDebugLog iSVNDebugLog) {
        super(contentHandler, iSVNDebugLog);
    }

    public void startTarget(File file) {
        try {
            this.myTargetPath = file;
            this.addAttribute(PATH_ATTR, file.getPath());
            this.openTag(TARGET_TAG);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
        }
    }

    @Override
    public void handleStatus(SVNStatus sVNStatus) {
        try {
            this.sendToHandler(sVNStatus);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, sAXException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, sAXException, SVNLogType.DEFAULT);
        }
    }

    public void endTarget(long l2) {
        try {
            this.myTargetPath = null;
            if (l2 >= 0L) {
                this.addAttribute(REVISION_ATTR, l2 + "");
                this.openTag(AGAINST_TAG);
                this.closeTag(AGAINST_TAG);
            }
            this.closeTag(TARGET_TAG);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
        }
    }

    private void sendToHandler(SVNStatus sVNStatus) {
        this.addAttribute(PATH_ATTR, this.getRelativePath(sVNStatus.getFile()));
        this.openTag(ENTRY_TAG);
        this.addAttribute(PROPS_ATTR, sVNStatus.getPropertiesStatus().toString());
        this.addAttribute(ITEM_ATTR, sVNStatus.getContentsStatus().toString());
        if (sVNStatus.isLocked()) {
            this.addAttribute(WC_LOCKED_ATTR, TRUE);
        }
        if (sVNStatus.isCopied()) {
            this.addAttribute(COPIED_ATTR, TRUE);
        }
        if (sVNStatus.isSwitched()) {
            this.addAttribute(SWITCHED_ATTR, TRUE);
        }
        if (!sVNStatus.isCopied() && sVNStatus.getRevision() != null && sVNStatus.getRevision().getNumber() >= 0L) {
            this.addAttribute(REVISION_ATTR, sVNStatus.getRevision().toString());
        }
        this.openTag(WC_STATUS_TAG);
        if (sVNStatus.getCommittedRevision() != null && sVNStatus.getCommittedRevision().getNumber() >= 0L) {
            this.addAttribute(REVISION_ATTR, sVNStatus.getCommittedRevision().toString());
            this.openTag(COMMIT_TAG);
            this.addTag(AUTHOR_TAG, sVNStatus.getAuthor());
            if (sVNStatus.getCommittedDate() != null) {
                this.addTag(DATE_TAG, SVNDate.formatDate(sVNStatus.getCommittedDate()));
            }
            this.closeTag(COMMIT_TAG);
        }
        if (sVNStatus.getLocalLock() != null) {
            this.openTag(LOCK_TAG);
            this.addTag(TOKEN_TAG, sVNStatus.getLocalLock().getID());
            this.addTag(OWNER_TAG, sVNStatus.getLocalLock().getOwner());
            this.addTag(COMMENT_TAG, sVNStatus.getLocalLock().getComment());
            this.addTag(CREATED_TAG, SVNDate.formatDate(sVNStatus.getLocalLock().getCreationDate()));
            this.closeTag(LOCK_TAG);
        }
        this.closeTag(WC_STATUS_TAG);
        if (sVNStatus.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE || sVNStatus.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE || sVNStatus.getRemoteLock() != null) {
            this.addAttribute(PROPS_ATTR, sVNStatus.getRemotePropertiesStatus().toString());
            this.addAttribute(ITEM_ATTR, sVNStatus.getRemoteContentsStatus().toString());
            this.openTag(REMOTE_STATUS_TAG);
            if (sVNStatus.getRemoteLock() != null) {
                this.openTag(LOCK_TAG);
                this.addTag(TOKEN_TAG, sVNStatus.getRemoteLock().getID());
                this.addTag(OWNER_TAG, sVNStatus.getRemoteLock().getOwner());
                this.addTag(COMMENT_TAG, sVNStatus.getRemoteLock().getComment());
                this.addTag(CREATED_TAG, SVNDate.formatDate(sVNStatus.getRemoteLock().getCreationDate()));
                if (sVNStatus.getRemoteLock().getExpirationDate() != null) {
                    this.addTag(EXPIRES_TAG, SVNDate.formatDate(sVNStatus.getRemoteLock().getExpirationDate()));
                }
                this.closeTag(LOCK_TAG);
            }
            this.closeTag(REMOTE_STATUS_TAG);
        }
        this.closeTag(ENTRY_TAG);
    }

    protected String getRelativePath(File file) {
        String string = file.getAbsoluteFile().getAbsolutePath();
        if (this.myTargetPath == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = File.separatorChar;
        boolean bl2 = false;
        if (!file.getAbsoluteFile().equals(this.myTargetPath.getAbsoluteFile())) {
            do {
                if (stringBuffer.length() > 0) {
                    stringBuffer.insert(0, c2);
                }
                stringBuffer = stringBuffer.insert(0, file.getName());
                if ((file = file.getParentFile()) == null) continue;
                bl2 = file.getAbsoluteFile().equals(this.myTargetPath.getAbsoluteFile());
            } while (file != null && !bl2);
        } else {
            return this.myTargetPath.getPath();
        }
        if (file != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, c2);
            }
        } else {
            return string;
        }
        stringBuffer = stringBuffer.insert(0, this.myTargetPath.getPath());
        return stringBuffer.toString();
    }

    protected String getTargetPath() {
        return this.getRelativePath(this.myTargetPath);
    }

    @Override
    protected String getHeaderName() {
        return STATUS_TAG;
    }
}

