/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SVNXMLSerializer
implements ContentHandler {
    private Writer myWriter;
    private String myEol = System.getProperty("line.separator");
    private boolean myCharacters = false;

    public SVNXMLSerializer(OutputStream outputStream) {
        try {
            this.myWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.myWriter = new OutputStreamWriter(outputStream);
        }
    }

    public SVNXMLSerializer(Writer writer) {
        this.myWriter = writer;
    }

    public void flush() {
        this.myWriter.flush();
    }

    @Override
    public void startDocument() {
        try {
            this.myWriter.write("<?xml version=\"1.0\"?>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        try {
            this.myWriter.write(this.myEol);
            this.myWriter.write("<");
            this.myWriter.write(string3);
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                this.myWriter.write(this.myEol);
                this.myWriter.write("   ");
                this.myWriter.write(attributes.getQName(i2));
                this.myWriter.write("=\"");
                this.myWriter.write(SVNEncodingUtil.xmlEncodeAttr(attributes.getValue(i2)));
                this.myWriter.write("\"");
            }
            if ("against".equals(string3)) {
                this.myWriter.write("/>");
            } else {
                this.myWriter.write(">");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        this.myCharacters = true;
        try {
            String string = SVNEncodingUtil.xmlEncodeCDATA(new String(cArray, n2, n3));
            this.myWriter.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if ("against".equals(string3)) {
            return;
        }
        try {
            if (!this.myCharacters) {
                this.myWriter.write(this.myEol);
            }
            this.myWriter.write("</");
            this.myWriter.write(string3);
            this.myWriter.write(">");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        finally {
            this.myCharacters = false;
        }
    }

    @Override
    public void endDocument() {
        try {
            this.myWriter.write(this.myEol);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
    }

    @Override
    public void endPrefixMapping(String string) {
    }

    @Override
    public void skippedEntity(String string) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
    }
}

