/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.util.LinkedList;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.core.wc.xml.SVNXMLLogHandler$MergeFrame;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLLogHandler
extends AbstractXMLHandler
implements ISVNLogEntryHandler {
    public static final String COPYFROM_REV_ATTR = "copyfrom-rev";
    public static final String COPYFROM_PATH_ATTR = "copyfrom-path";
    public static final String ACTION_ATTR = "action";
    public static final String REVISION_ATTR = "revision";
    public static final String MSG_TAG = "msg";
    public static final String PATH_TAG = "path";
    public static final String PATHS_TAG = "paths";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    public static final String LOGENTRY_TAG = "logentry";
    public static final String LOG_TAG = "log";
    private boolean myIsOmitLogMessage;
    private LinkedList myMergeStack;

    public SVNXMLLogHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLLogHandler(ContentHandler contentHandler, ISVNDebugLog iSVNDebugLog) {
        super(contentHandler, iSVNDebugLog);
    }

    @Override
    public String getHeaderName() {
        return LOG_TAG;
    }

    @Override
    public void handleLogEntry(SVNLogEntry sVNLogEntry) {
        try {
            this.sendToHandler(sVNLogEntry);
        }
        catch (SAXException sAXException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, sAXException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, sAXException, SVNLogType.DEFAULT);
        }
    }

    public void setOmitLogMessage(boolean bl2) {
        this.myIsOmitLogMessage = bl2;
    }

    private void sendToHandler(SVNLogEntry sVNLogEntry) {
        Object object;
        if (sVNLogEntry.getRevision() == 0L && sVNLogEntry.getMessage() == null) {
            return;
        }
        this.addAttribute(REVISION_ATTR, sVNLogEntry.getRevision() + "");
        this.openTag(LOGENTRY_TAG);
        if (sVNLogEntry.getAuthor() != null) {
            this.addTag(AUTHOR_TAG, sVNLogEntry.getAuthor());
        }
        if (sVNLogEntry.getDate() != null && sVNLogEntry.getDate().getTime() != 0L) {
            this.addTag(DATE_TAG, SVNDate.formatDate(sVNLogEntry.getDate()));
        }
        if (sVNLogEntry.getChangedPaths() != null && !sVNLogEntry.getChangedPaths().isEmpty()) {
            this.openTag(PATHS_TAG);
            object = sVNLogEntry.getChangedPaths().keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                SVNLogEntryPath sVNLogEntryPath = (SVNLogEntryPath)sVNLogEntry.getChangedPaths().get(string);
                this.addAttribute(ACTION_ATTR, sVNLogEntryPath.getType() + "");
                if (sVNLogEntryPath.getCopyPath() != null) {
                    this.addAttribute(COPYFROM_PATH_ATTR, sVNLogEntryPath.getCopyPath());
                    this.addAttribute(COPYFROM_REV_ATTR, sVNLogEntryPath.getCopyRevision() + "");
                }
                this.addTag(PATH_TAG, sVNLogEntryPath.getPath());
            }
            this.closeTag(PATHS_TAG);
        }
        if (!this.myIsOmitLogMessage) {
            object = sVNLogEntry.getMessage();
            object = object == null ? "" : object;
            this.addTag(MSG_TAG, (String)object);
        }
        if (this.myMergeStack != null && !this.myMergeStack.isEmpty()) {
            object = (SVNXMLLogHandler$MergeFrame)this.myMergeStack.getLast();
            SVNXMLLogHandler$MergeFrame.access$010((SVNXMLLogHandler$MergeFrame)object);
        }
        if (sVNLogEntry.hasChildren()) {
            object = new SVNXMLLogHandler$MergeFrame(this);
            if (this.myMergeStack == null) {
                this.myMergeStack = new LinkedList();
            }
            this.myMergeStack.addLast(object);
        } else {
            while (this.myMergeStack != null && !this.myMergeStack.isEmpty() && SVNXMLLogHandler$MergeFrame.access$000((SVNXMLLogHandler$MergeFrame)(object = (SVNXMLLogHandler$MergeFrame)this.myMergeStack.getLast())) == 0L) {
                this.closeTag(LOGENTRY_TAG);
                this.myMergeStack.removeLast();
            }
            this.closeTag(LOGENTRY_TAG);
        }
    }
}

