/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLInfoHandler
extends AbstractXMLHandler
implements ISVNInfoHandler {
    private static final String INFO_TAG = "info";
    private static final String ENTRY_TAG = "entry";
    private static final String REVISION_ATTR = "revision";
    private static final String PATH_ATTR = "path";
    private static final String KIND_ATTR = "kind";
    private static final String URL_TAG = "url";
    private static final String REPOSITORY_TAG = "repository";
    private static final String UUID_TAG = "uuid";
    private static final String ROOT_TAG = "root";
    private static final String WC_INFO_TAG = "wc-info";
    private static final String SCHEDULE_TAG = "schedule";
    private static final String COPY_FROM_URL_TAG = "copy-from-url";
    private static final String COPY_FROM_REVISION_TAG = "copy-from-rev";
    private static final String CHECKSUM_TAG = "checksum";
    private static final String TEXT_TIME_TAG = "text-update";
    private static final String PROP_TIME_TAG = "prop-updated";
    private static final String COMMIT_TAG = "commit";
    private static final String AUTHOR_TAG = "author";
    private static final String DATE_TAG = "date";
    private static final String CONFLICT_TAG = "conflict";
    private static final String OLD_CONFLICT_TAG = "prev-base-file";
    private static final String WRK_CONFLICT_TAG = "prev-wc-file";
    private static final String NEW_CONFLICT_TAG = "cur-base-file";
    private static final String PROP_CONFLICT_TAG = "prop-file";
    private static final String TOKEN_TAG = "token";
    private static final String OWNER_TAG = "owner";
    private static final String COMMENT_TAG = "comment";
    private static final String CREATED_TAG = "created";
    private static final String EXPIRES_TAG = "expires";
    private static final String LOCK_TAG = "lock";
    private static final String DEPTH_TAG = "depth";
    private static final String CHANGELIST_TAG = "changelist";
    private File myTargetPath;

    public SVNXMLInfoHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLInfoHandler(ContentHandler contentHandler, ISVNDebugLog iSVNDebugLog) {
        super(contentHandler, iSVNDebugLog);
    }

    public void setTargetPath(File file) {
        this.myTargetPath = file;
    }

    @Override
    protected String getHeaderName() {
        return INFO_TAG;
    }

    @Override
    public void handleInfo(SVNInfo sVNInfo) {
        try {
            this.sendToHandler(sVNInfo);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, sAXException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, sAXException, SVNLogType.DEFAULT);
        }
    }

    private void sendToHandler(SVNInfo sVNInfo) {
        Object object;
        this.addAttribute(KIND_ATTR, sVNInfo.getKind().toString());
        if (sVNInfo.getFile() != null) {
            this.addAttribute(PATH_ATTR, this.getRelativePath(sVNInfo.getFile()));
        } else if (sVNInfo.getPath() != null) {
            this.addAttribute(PATH_ATTR, sVNInfo.getPath());
        }
        this.addAttribute(REVISION_ATTR, sVNInfo.getRevision().toString());
        this.openTag(ENTRY_TAG);
        if (sVNInfo.getURL() != null) {
            this.addTag(URL_TAG, sVNInfo.getURL().toString());
        }
        SVNURL sVNURL = sVNInfo.getRepositoryRootURL();
        String string = sVNInfo.getRepositoryUUID();
        if (sVNURL != null || string != null) {
            this.openTag(REPOSITORY_TAG);
            if (sVNURL != null) {
                this.addTag(ROOT_TAG, sVNURL.toString());
            }
            if (string != null) {
                this.addTag(UUID_TAG, string);
            }
            this.closeTag(REPOSITORY_TAG);
        }
        if (sVNInfo.getFile() != null) {
            this.openTag(WC_INFO_TAG);
            object = sVNInfo.getSchedule();
            if (object == null || "".equals(object)) {
                object = "normal";
            }
            this.addTag(SCHEDULE_TAG, (String)object);
            if (sVNInfo.getDepth() != null) {
                this.addTag(DEPTH_TAG, sVNInfo.getDepth().getName());
            }
            if (sVNInfo.getCopyFromURL() != null) {
                this.addTag(COPY_FROM_URL_TAG, sVNInfo.getCopyFromURL().toString());
            }
            if (sVNInfo.getCopyFromRevision() != null && sVNInfo.getCopyFromRevision().isValid()) {
                this.addTag(COPY_FROM_REVISION_TAG, sVNInfo.getCopyFromRevision().toString());
            }
            if (sVNInfo.getTextTime() != null) {
                this.addTag(TEXT_TIME_TAG, SVNDate.formatDate(sVNInfo.getTextTime()));
            }
            if (sVNInfo.getPropTime() != null) {
                this.addTag(PROP_TIME_TAG, SVNDate.formatDate(sVNInfo.getPropTime()));
            }
            if (sVNInfo.getChecksum() != null) {
                this.addTag(CHECKSUM_TAG, sVNInfo.getChecksum());
            }
            if (sVNInfo.getChangelistName() != null) {
                this.addTag(CHANGELIST_TAG, sVNInfo.getChangelistName());
            }
            this.closeTag(WC_INFO_TAG);
        }
        if (sVNInfo.getAuthor() != null || sVNInfo.getCommittedRevision().isValid() || sVNInfo.getCommittedDate() != null) {
            if (sVNInfo.getCommittedRevision().isValid()) {
                this.addAttribute(REVISION_ATTR, sVNInfo.getCommittedRevision().toString());
            }
            this.openTag(COMMIT_TAG);
            this.addTag(AUTHOR_TAG, sVNInfo.getAuthor());
            if (sVNInfo.getCommittedDate() != null) {
                this.addTag(DATE_TAG, SVNDate.formatDate(sVNInfo.getCommittedDate()));
            }
            this.closeTag(COMMIT_TAG);
        }
        if (sVNInfo.getConflictNewFile() != null || sVNInfo.getConflictOldFile() != null || sVNInfo.getConflictWrkFile() != null || sVNInfo.getPropConflictFile() != null) {
            this.openTag(CONFLICT_TAG);
            if (sVNInfo.getConflictOldFile() != null) {
                this.addTag(OLD_CONFLICT_TAG, sVNInfo.getConflictOldFile().getName());
            }
            if (sVNInfo.getConflictWrkFile() != null) {
                this.addTag(WRK_CONFLICT_TAG, sVNInfo.getConflictWrkFile().getName());
            }
            if (sVNInfo.getConflictNewFile() != null) {
                this.addTag(NEW_CONFLICT_TAG, sVNInfo.getConflictNewFile().getName());
            }
            if (sVNInfo.getPropConflictFile() != null) {
                this.addTag(PROP_CONFLICT_TAG, sVNInfo.getPropConflictFile().getName());
            }
            this.closeTag(CONFLICT_TAG);
        }
        if (sVNInfo.getLock() != null) {
            object = sVNInfo.getLock();
            this.openTag(LOCK_TAG);
            if (((SVNLock)object).getID() != null) {
                this.addTag(TOKEN_TAG, ((SVNLock)object).getID());
            }
            if (((SVNLock)object).getOwner() != null) {
                this.addTag(OWNER_TAG, ((SVNLock)object).getOwner());
            }
            if (((SVNLock)object).getComment() != null) {
                this.addTag(COMMENT_TAG, ((SVNLock)object).getComment());
            }
            if (((SVNLock)object).getCreationDate() != null) {
                this.addTag(CREATED_TAG, SVNDate.formatDate(((SVNLock)object).getCreationDate()));
            }
            if (((SVNLock)object).getExpirationDate() != null) {
                this.addTag(EXPIRES_TAG, SVNDate.formatDate(((SVNLock)object).getExpirationDate()));
            }
            this.closeTag(LOCK_TAG);
        }
        this.closeTag(ENTRY_TAG);
    }

    protected String getRelativePath(File file) {
        String string = file.getAbsoluteFile().getAbsolutePath();
        if (this.myTargetPath == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = File.separatorChar;
        boolean bl2 = false;
        if (!file.getAbsoluteFile().equals(this.myTargetPath.getAbsoluteFile())) {
            do {
                if (stringBuffer.length() > 0) {
                    stringBuffer.insert(0, c2);
                }
                stringBuffer = stringBuffer.insert(0, file.getName());
                if ((file = file.getParentFile()) == null) continue;
                bl2 = file.getAbsoluteFile().equals(this.myTargetPath.getAbsoluteFile());
            } while (file != null && !bl2);
        } else {
            return this.myTargetPath.getPath();
        }
        if (file != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, c2);
            }
        } else {
            return string;
        }
        stringBuffer = stringBuffer.insert(0, this.myTargetPath.getPath());
        return stringBuffer.toString();
    }

    protected String getTargetPath() {
        return this.getRelativePath(this.myTargetPath);
    }
}

