/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLDirEntryHandler
extends AbstractXMLHandler
implements Comparator,
ISVNDirEntryHandler {
    public static final String EXPIRES_TAG = "expires";
    public static final String CREATED_TAG = "created";
    public static final String COMMENT_TAG = "comment";
    public static final String OWNER_TAG = "owner";
    public static final String TOKEN_TAG = "token";
    public static final String LOCK_TAG = "lock";
    public static final String PATH_ATTR = "path";
    public static final String REVISION_ATTR = "revision";
    public static final String LISTS_TAG = "lists";
    public static final String LIST_TAG = "list";
    public static final String ENTRY_TAG = "entry";
    public static final String NAME_TAG = "name";
    public static final String SIZE_TAG = "size";
    public static final String COMMIT_TAG = "commit";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    private Collection myDirEntries;

    public SVNXMLDirEntryHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLDirEntryHandler(ContentHandler contentHandler, ISVNDebugLog iSVNDebugLog) {
        super(contentHandler, iSVNDebugLog);
    }

    public void startTarget(String string) {
        this.myDirEntries = new TreeSet(this);
        try {
            this.addAttribute(PATH_ATTR, string == null || string.length() == 9 ? "." : string);
            this.openTag(LIST_TAG);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
        }
    }

    @Override
    public void handleDirEntry(SVNDirEntry sVNDirEntry) {
        this.myDirEntries.add(sVNDirEntry);
    }

    public void endTarget() {
        try {
            for (SVNDirEntry sVNDirEntry : this.myDirEntries) {
                this.sendToHandler(sVNDirEntry);
            }
            this.myDirEntries = null;
            this.closeTag(LIST_TAG);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
        }
    }

    private void sendToHandler(SVNDirEntry sVNDirEntry) {
        if ("".equals(sVNDirEntry.getRelativePath()) && sVNDirEntry.getKind() == SVNNodeKind.DIR) {
            return;
        }
        this.openTag(ENTRY_TAG);
        this.addTag(NAME_TAG, sVNDirEntry.getRelativePath());
        if (sVNDirEntry.getKind() == SVNNodeKind.FILE) {
            this.addTag(SIZE_TAG, sVNDirEntry.getSize() + "");
        }
        this.addAttribute(REVISION_ATTR, sVNDirEntry.getRevision() + "");
        this.openTag(COMMIT_TAG);
        this.addTag(AUTHOR_TAG, sVNDirEntry.getAuthor());
        this.addTag(DATE_TAG, SVNDate.formatDate(sVNDirEntry.getDate()));
        this.closeTag(COMMIT_TAG);
        SVNLock sVNLock = sVNDirEntry.getLock();
        if (sVNLock != null) {
            this.openTag(LOCK_TAG);
            this.addTag(TOKEN_TAG, sVNLock.getID());
            this.addTag(OWNER_TAG, sVNLock.getOwner());
            this.addTag(COMMENT_TAG, sVNLock.getComment());
            this.addTag(CREATED_TAG, SVNDate.formatDate(sVNLock.getCreationDate()));
            if (sVNLock.getExpirationDate() != null && sVNLock.getExpirationDate().getTime() > 0L) {
                this.addTag(EXPIRES_TAG, SVNDate.formatDate(sVNLock.getExpirationDate()));
            }
            this.closeTag(LOCK_TAG);
        }
        this.closeTag(ENTRY_TAG);
    }

    @Override
    protected String getHeaderName() {
        return LISTS_TAG;
    }

    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        SVNDirEntry sVNDirEntry = (SVNDirEntry)object;
        SVNDirEntry sVNDirEntry2 = (SVNDirEntry)object2;
        if (sVNDirEntry == null) {
            return -1;
        }
        if (sVNDirEntry2 == null) {
            return 1;
        }
        return SVNPathUtil.PATH_COMPARATOR.compare(sVNDirEntry.getRelativePath(), sVNDirEntry2.getRelativePath());
    }
}

