/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.io.File;
import java.util.Date;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLAnnotateHandler
extends AbstractXMLHandler
implements ISVNAnnotateHandler {
    public static final String PATH_ATTR = "path";
    public static final String REVISION_ATTR = "revision";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    public static final String COMMIT_TAG = "commit";
    public static final String ENTRY_TAG = "entry";
    public static final String LINE_NUMBER_TAG = "line-number";
    public static final String TARGET_TAG = "target";
    public static final String BLAME_TAG = "blame";
    public static final String MERGED_TAG = "merged";
    private long myLineNumber;
    private boolean myIsUseMergeHistory;

    public SVNXMLAnnotateHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLAnnotateHandler(ContentHandler contentHandler, ISVNDebugLog iSVNDebugLog) {
        this(contentHandler, iSVNDebugLog, false);
    }

    public SVNXMLAnnotateHandler(ContentHandler contentHandler, ISVNDebugLog iSVNDebugLog, boolean bl2) {
        super(contentHandler, iSVNDebugLog);
        this.myIsUseMergeHistory = bl2;
    }

    @Override
    protected String getHeaderName() {
        return BLAME_TAG;
    }

    public void startTarget(String string) {
        this.myLineNumber = 1L;
        try {
            this.addAttribute(PATH_ATTR, string);
            this.openTag(TARGET_TAG);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
        }
    }

    public void endTarget() {
        this.myLineNumber = 1L;
        try {
            this.closeTag(TARGET_TAG);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLine(Date date, long l2, String string, String string2) {
        try {
            this.addAttribute(LINE_NUMBER_TAG, this.myLineNumber + "");
            this.openTag(ENTRY_TAG);
            if (l2 >= 0L) {
                this.addAttribute(REVISION_ATTR, l2 + "");
                this.openTag(COMMIT_TAG);
                this.addTag(AUTHOR_TAG, string);
                this.addTag(DATE_TAG, SVNDate.formatDate(date));
                this.closeTag(COMMIT_TAG);
            }
            this.closeTag(ENTRY_TAG);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, sAXException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, sAXException, SVNLogType.DEFAULT);
        }
        finally {
            ++this.myLineNumber;
        }
    }

    @Override
    public void handleLine(Date date, long l2, String string, String string2, Date date2, long l3, String string3, String string4, int n2) {
        try {
            this.addAttribute(LINE_NUMBER_TAG, ++n2 + "");
            this.openTag(ENTRY_TAG);
            if (l2 >= 0L) {
                this.addAttribute(REVISION_ATTR, l2 + "");
                this.openTag(COMMIT_TAG);
                this.addTag(AUTHOR_TAG, string);
                this.addTag(DATE_TAG, SVNDate.formatDate(date));
                this.closeTag(COMMIT_TAG);
            }
            if (this.myIsUseMergeHistory && l3 >= 0L) {
                this.addAttribute(PATH_ATTR, string4);
                this.openTag(MERGED_TAG);
                this.addAttribute(REVISION_ATTR, l3 + "");
                this.openTag(COMMIT_TAG);
                this.addTag(AUTHOR_TAG, string3);
                this.addTag(DATE_TAG, SVNDate.formatDate(date2));
                this.closeTag(COMMIT_TAG);
                this.closeTag(MERGED_TAG);
            }
            this.closeTag(ENTRY_TAG);
        }
        catch (SAXException sAXException) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, sAXException);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, sAXException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, sAXException, SVNLogType.DEFAULT);
        }
    }

    @Override
    public boolean handleRevision(Date date, long l2, String string, File file) {
        return false;
    }

    @Override
    public void handleEOF() {
    }
}

