/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractXMLHandler
implements Locator {
    private AttributesImpl mySharedAttributes;
    private ContentHandler myHandler;
    private ISVNDebugLog myLog;

    protected AbstractXMLHandler(ContentHandler contentHandler, ISVNDebugLog iSVNDebugLog) {
        this.myHandler = contentHandler;
        this.myLog = iSVNDebugLog == null ? SVNDebugLog.getDefaultLog() : iSVNDebugLog;
    }

    protected ISVNDebugLog getDebugLog() {
        return this.myLog;
    }

    public void startDocument() {
        try {
            this.getHandler().setDocumentLocator(this);
            this.getHandler().startDocument();
            this.openTag(this.getHeaderName());
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void endDocument() {
        try {
            this.closeTag(this.getHeaderName());
            this.getHandler().endDocument();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private ContentHandler getHandler() {
        return this.myHandler;
    }

    protected abstract String getHeaderName();

    protected void openTag(String string) {
        if (this.mySharedAttributes == null) {
            this.mySharedAttributes = new AttributesImpl();
        }
        this.getHandler().startElement("", "", string, this.mySharedAttributes);
        this.mySharedAttributes.clear();
    }

    protected void closeTag(String string) {
        this.getHandler().endElement("", "", string);
    }

    protected void addTag(String string, String string2) {
        if (this.mySharedAttributes == null) {
            this.mySharedAttributes = new AttributesImpl();
        }
        this.getHandler().startElement("", "", string, this.mySharedAttributes);
        this.mySharedAttributes.clear();
        string2 = string2 == null ? "" : string2;
        this.getHandler().characters(string2.toCharArray(), 0, string2.length());
        this.getHandler().endElement("", "", string);
    }

    protected void addAttribute(String string, String string2) {
        if (this.mySharedAttributes == null) {
            this.mySharedAttributes = new AttributesImpl();
        }
        this.mySharedAttributes.addAttribute("", "", string, "CDATA", string2);
    }

    @Override
    public int getColumnNumber() {
        return 0;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }
}

