/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import java.io.Serializable;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNSynchronizeEditor;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNReplayHandler
implements ISVNReplayHandler {
    private SVNRepository myTargetRepository;
    private boolean myHasCommitRevPropsCapability;
    private ISVNLogEntryHandler myLogEntryHandler;
    private ISVNDebugLog myDebugLog;
    private ISVNEventHandler myCanceller;
    private SVNSynchronizeEditor mySyncEditor;
    private SVNAdminClient myAdminClient;
    private int myNormalizedRevPropsCount;

    public SVNReplayHandler(SVNRepository sVNRepository, boolean bl2, ISVNLogEntryHandler iSVNLogEntryHandler, ISVNDebugLog iSVNDebugLog, ISVNEventHandler iSVNEventHandler, SVNAdminClient sVNAdminClient) {
        this.myTargetRepository = sVNRepository;
        this.myHasCommitRevPropsCapability = bl2;
        this.myLogEntryHandler = iSVNLogEntryHandler;
        this.myDebugLog = iSVNDebugLog;
        this.myCanceller = iSVNEventHandler;
        this.myAdminClient = sVNAdminClient;
        this.myNormalizedRevPropsCount = 0;
    }

    @Override
    public ISVNEditor handleStartRevision(long l2, SVNProperties sVNProperties) {
        this.myTargetRepository.setRevisionPropertyValue(0L, "svn:sync-currently-copying", SVNPropertyValue.create(SVNProperty.toString(l2)));
        SVNProperties sVNProperties2 = new SVNProperties();
        this.filterProperties(sVNProperties, sVNProperties2, true);
        if (!sVNProperties2.containsName("svn:log")) {
            sVNProperties2.put("svn:log", "");
        }
        SVNProperties sVNProperties3 = SVNAdminClient.normalizeRevisionProperties(sVNProperties2);
        this.myNormalizedRevPropsCount += sVNProperties3.size();
        if (this.mySyncEditor == null) {
            this.mySyncEditor = new SVNSynchronizeEditor(this.myTargetRepository, this.myLogEntryHandler, l2 - 1L, sVNProperties2);
        } else {
            this.mySyncEditor.reset(l2 - 1L, sVNProperties2);
        }
        ISVNEditor iSVNEditor = SVNCancellableEditor.newInstance(this.mySyncEditor, this.myCanceller, this.myDebugLog);
        return iSVNEditor;
    }

    @Override
    public void handleEndRevision(long l2, SVNProperties sVNProperties, ISVNEditor iSVNEditor) {
        Serializable serializable;
        iSVNEditor.closeEdit();
        if (this.mySyncEditor.getCommitInfo().getNewRevision() != l2) {
            serializable = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Commit created rev {0} but should have created {1}", String.valueOf(this.mySyncEditor.getCommitInfo().getNewRevision()), String.valueOf(l2));
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
        }
        serializable = this.myTargetRepository.getRevisionProperties(l2, null);
        SVNProperties sVNProperties2 = new SVNProperties();
        this.filterProperties(sVNProperties, sVNProperties2, false);
        SVNProperties sVNProperties3 = SVNAdminClient.normalizeRevisionProperties(sVNProperties2);
        this.myNormalizedRevPropsCount += sVNProperties3.size();
        int n2 = SVNAdminHelper.writeRevisionProperties(this.myTargetRepository, l2, sVNProperties2);
        SVNAdminHelper.removePropertiesNotInSource(this.myTargetRepository, l2, sVNProperties, serializable);
        this.myTargetRepository.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNPropertyValue.create(SVNProperty.toString(l2)));
        this.myTargetRepository.setRevisionPropertyValue(0L, "svn:sync-currently-copying", null);
        this.myAdminClient.handlePropertesCopied(n2 > 0, l2);
    }

    public int getNormalizedRevPropsCount() {
        return this.myNormalizedRevPropsCount;
    }

    public int getNormalizedNodePropsCount() {
        return this.mySyncEditor == null ? 0 : this.mySyncEditor.getNormalizedNodePropsCounter();
    }

    private int filterProperties(SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean bl2) {
        int n2 = 0;
        for (String string : sVNProperties.nameSet()) {
            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
            boolean bl3 = false;
            bl3 = bl2 ? (this.myHasCommitRevPropsCapability ? this.filterExcludeDateAuthorSync(string) : this.filterIncludeLog(string)) : (this.myHasCommitRevPropsCapability ? this.filterIncludeDateAuthorSync(string) : this.filterExcludeLog(string));
            if (!bl3) {
                sVNProperties2.put(string, sVNPropertyValue);
                continue;
            }
            ++n2;
        }
        return n2;
    }

    private boolean filterIncludeDateAuthorSync(String string) {
        return !this.filterExcludeDateAuthorSync(string);
    }

    private boolean filterExcludeDateAuthorSync(String string) {
        return "svn:author".equals(string) || "svn:date".equals(string) || string.startsWith("svn:sync-");
    }

    private boolean filterIncludeLog(String string) {
        return !this.filterExcludeLog(string);
    }

    private boolean filterExcludeLog(String string) {
        return "svn:log".equals(string);
    }
}

