/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNGNUDiffGenerator;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNNodeEditor;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNChangeEntryHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNChangedDirectoriesHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNGNUDiffGenerator;
import org.tmatesoft.svn.core.wc.admin.ISVNHistoryHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNTreeHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminBasicClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminPath;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLookClient
extends SVNAdminBasicClient {
    private ISVNGNUDiffGenerator myDiffGenerator;

    public SVNLookClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNLookClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNLookClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLogEntry doGetInfo(File file, SVNRevision sVNRevision) {
        FSFS fSFS = this.open(file, sVNRevision);
        try {
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, fSFS.getYoungestRevision(), fSFS);
            SVNProperties sVNProperties = fSFS.getRevisionProperties(l2);
            String string = sVNProperties.getStringValue("svn:date");
            String string2 = sVNProperties.getStringValue("svn:author");
            String string3 = sVNProperties.getStringValue("svn:log");
            SVNLogEntry sVNLogEntry = new SVNLogEntry(null, l2, string2, SVNDate.parseDateString(string), string3);
            return sVNLogEntry;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLogEntry doGetInfo(File file, String string) {
        FSFS fSFS = this.open(file, string);
        try {
            FSTransactionInfo fSTransactionInfo = fSFS.openTxn(string);
            SVNProperties sVNProperties = fSFS.getTransactionProperties(fSTransactionInfo.getTxnId());
            String string2 = sVNProperties.getStringValue("svn:date");
            String string3 = sVNProperties.getStringValue("svn:author");
            String string4 = sVNProperties.getStringValue("svn:log");
            SVNLogEntry sVNLogEntry = new SVNLogEntry(null, -1L, string3, SVNDate.parseDateString(string2), string4);
            return sVNLogEntry;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doGetYoungestRevision(File file) {
        FSFS fSFS = null;
        try {
            fSFS = SVNAdminHelper.openRepository(file, true);
            long l2 = fSFS.getYoungestRevision();
            return l2;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetUUID(File file) {
        FSFS fSFS = null;
        try {
            fSFS = SVNAdminHelper.openRepository(file, true);
            String string = fSFS.getUUID();
            return string;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetAuthor(File file, SVNRevision sVNRevision) {
        FSFS fSFS = this.open(file, sVNRevision);
        try {
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, fSFS.getYoungestRevision(), fSFS);
            SVNProperties sVNProperties = fSFS.getRevisionProperties(l2);
            String string = sVNProperties.getStringValue("svn:author");
            return string;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetAuthor(File file, String string) {
        FSFS fSFS = this.open(file, string);
        try {
            FSTransactionInfo fSTransactionInfo = fSFS.openTxn(string);
            SVNProperties sVNProperties = fSFS.getTransactionProperties(fSTransactionInfo.getTxnId());
            String string2 = sVNProperties.getStringValue("svn:author");
            return string2;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCat(File file, String string, SVNRevision sVNRevision, OutputStream outputStream) {
        Object object;
        if (string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = this.open(file, sVNRevision);
        try {
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, ((FSFS)object).getYoungestRevision(), (FSFS)object);
            FSRevisionRoot fSRevisionRoot = ((FSFS)object).createRevisionRoot(l2);
            this.catFile(fSRevisionRoot, string, outputStream);
        }
        finally {
            SVNAdminHelper.closeRepository((FSFS)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCat(File file, String string, String string2, OutputStream outputStream) {
        Object object;
        if (string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = this.open(file, string2);
        try {
            FSTransactionInfo fSTransactionInfo = ((FSFS)object).openTxn(string2);
            FSTransactionRoot fSTransactionRoot = ((FSFS)object).createTransactionRoot(fSTransactionInfo);
            this.catFile(fSTransactionRoot, string, outputStream);
        }
        finally {
            SVNAdminHelper.closeRepository((FSFS)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date doGetDate(File file, SVNRevision sVNRevision) {
        FSFS fSFS = this.open(file, sVNRevision);
        try {
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, fSFS.getYoungestRevision(), fSFS);
            SVNProperties sVNProperties = fSFS.getRevisionProperties(l2);
            String string = sVNProperties.getStringValue("svn:date");
            if (string != null) {
                SVNDate sVNDate = SVNDate.parseDate(string);
                return sVNDate;
            }
            Date date = null;
            return date;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date doGetDate(File file, String string) {
        FSFS fSFS = this.open(file, string);
        try {
            FSTransactionInfo fSTransactionInfo = fSFS.openTxn(string);
            SVNProperties sVNProperties = fSFS.getTransactionProperties(fSTransactionInfo.getTxnId());
            String string2 = sVNProperties.getStringValue("svn:date");
            if (string2 != null) {
                SVNDate sVNDate = SVNDate.parseDate(string2);
                return sVNDate;
            }
            Date date = null;
            return date;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetLog(File file, SVNRevision sVNRevision) {
        FSFS fSFS = this.open(file, sVNRevision);
        try {
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, fSFS.getYoungestRevision(), fSFS);
            SVNProperties sVNProperties = fSFS.getRevisionProperties(l2);
            String string = sVNProperties.getStringValue("svn:log");
            return string;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetLog(File file, String string) {
        FSFS fSFS = this.open(file, string);
        try {
            FSTransactionInfo fSTransactionInfo = fSFS.openTxn(string);
            SVNProperties sVNProperties = fSFS.getTransactionProperties(fSTransactionInfo.getTxnId());
            String string2 = sVNProperties.getStringValue("svn:log");
            return string2;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetChanged(File file, SVNRevision sVNRevision, ISVNChangeEntryHandler iSVNChangeEntryHandler, boolean bl2) {
        FSFS fSFS = this.open(file, sVNRevision);
        try {
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, fSFS.getYoungestRevision(), fSFS);
            FSRevisionRoot fSRevisionRoot = fSFS.createRevisionRoot(l2);
            long l3 = l2 - 1L;
            SVNNodeEditor sVNNodeEditor = this.generateDeltaTree(fSFS, fSRevisionRoot, l3);
            sVNNodeEditor.traverseTree(bl2, iSVNChangeEntryHandler);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetChanged(File file, String string, ISVNChangeEntryHandler iSVNChangeEntryHandler, boolean bl2) {
        FSFS fSFS = this.open(file, string);
        try {
            Object object;
            FSTransactionInfo fSTransactionInfo = fSFS.openTxn(string);
            FSTransactionRoot fSTransactionRoot = fSFS.createTransactionRoot(fSTransactionInfo);
            long l2 = fSTransactionInfo.getBaseRevision();
            if (!SVNRevision.isValidRevisionNumber(l2)) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Transaction ''{0}'' is not based on a revision; how odd", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            object = this.generateDeltaTree(fSFS, fSTransactionRoot, l2);
            ((SVNNodeEditor)object).traverseTree(bl2, iSVNChangeEntryHandler);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetChangedDirectories(File file, SVNRevision sVNRevision, ISVNChangedDirectoriesHandler iSVNChangedDirectoriesHandler) {
        FSFS fSFS = this.open(file, sVNRevision);
        try {
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, fSFS.getYoungestRevision(), fSFS);
            FSRevisionRoot fSRevisionRoot = fSFS.createRevisionRoot(l2);
            long l3 = l2 - 1L;
            if (!SVNRevision.isValidRevisionNumber(l3)) {
                return;
            }
            SVNNodeEditor sVNNodeEditor = this.generateDeltaTree(fSFS, fSRevisionRoot, l3);
            sVNNodeEditor.traverseChangedDirs(iSVNChangedDirectoriesHandler);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetChangedDirectories(File file, String string, ISVNChangedDirectoriesHandler iSVNChangedDirectoriesHandler) {
        FSFS fSFS = this.open(file, string);
        try {
            Object object;
            FSTransactionInfo fSTransactionInfo = fSFS.openTxn(string);
            FSTransactionRoot fSTransactionRoot = fSFS.createTransactionRoot(fSTransactionInfo);
            long l2 = fSTransactionInfo.getBaseRevision();
            if (!SVNRevision.isValidRevisionNumber(l2)) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Transaction ''{0}'' is not based on a revision; how odd", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            object = this.generateDeltaTree(fSFS, fSTransactionRoot, l2);
            ((SVNNodeEditor)object).traverseChangedDirs(iSVNChangedDirectoriesHandler);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetHistory(File file, String string, SVNRevision sVNRevision, boolean bl2, long l2, ISVNHistoryHandler iSVNHistoryHandler) {
        FSFS fSFS = this.open(file, sVNRevision);
        try {
            long l3 = SVNAdminHelper.getRevisionNumber(sVNRevision, fSFS.getYoungestRevision(), fSFS);
            string = string == null ? "/" : string;
            this.getHistory(fSFS, string, 0L, l3, l2, true, bl2, iSVNHistoryHandler);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock doGetLock(File file, String string) {
        Object object;
        if (string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing path argument");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = this.open(file, SVNRevision.HEAD);
        try {
            SVNLock sVNLock = ((FSFS)object).getLockHelper(string, false);
            return sVNLock;
        }
        finally {
            SVNAdminHelper.closeRepository((FSFS)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetTree(File file, String string, SVNRevision sVNRevision, boolean bl2, boolean bl3, ISVNTreeHandler iSVNTreeHandler) {
        FSFS fSFS = this.open(file, sVNRevision);
        try {
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, fSFS.getYoungestRevision(), fSFS);
            FSRevisionRoot fSRevisionRoot = fSFS.createRevisionRoot(l2);
            string = string == null ? "/" : string;
            FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string);
            FSID fSID = bl2 ? fSRevisionNode.getId() : null;
            SVNNodeKind sVNNodeKind = fSRevisionRoot.checkNodeKind(string);
            this.getTree(fSFS, fSRevisionRoot, string, sVNNodeKind, fSID, bl2, 0, bl3, iSVNTreeHandler);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetTree(File file, String string, String string2, boolean bl2, boolean bl3, ISVNTreeHandler iSVNTreeHandler) {
        FSFS fSFS = this.open(file, string2);
        try {
            FSTransactionInfo fSTransactionInfo = fSFS.openTxn(string2);
            FSTransactionRoot fSTransactionRoot = fSFS.createTransactionRoot(fSTransactionInfo);
            string = string == null ? "/" : string;
            FSRevisionNode fSRevisionNode = fSTransactionRoot.getRevisionNode(string);
            FSID fSID = bl2 ? fSRevisionNode.getId() : null;
            SVNNodeKind sVNNodeKind = fSTransactionRoot.checkNodeKind(string);
            this.getTree(fSFS, fSTransactionRoot, string, sVNNodeKind, fSID, bl2, 0, bl3, iSVNTreeHandler);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDiff(File file, SVNRevision sVNRevision, boolean bl2, boolean bl3, boolean bl4, OutputStream outputStream) {
        FSFS fSFS = this.open(file, sVNRevision);
        try {
            Object object;
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, fSFS.getYoungestRevision(), fSFS);
            FSRevisionRoot fSRevisionRoot = fSFS.createRevisionRoot(l2);
            long l3 = l2 - 1L;
            if (!SVNRevision.isValidRevisionNumber(l3)) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid base revision {0}", (Object)l3);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            object = this.generateDeltaTree(fSFS, fSRevisionRoot, l3);
            ISVNGNUDiffGenerator iSVNGNUDiffGenerator = this.getDiffGenerator();
            iSVNGNUDiffGenerator.setDiffAdded(bl3);
            iSVNGNUDiffGenerator.setDiffCopied(bl4);
            iSVNGNUDiffGenerator.setDiffDeleted(bl2);
            ((SVNNodeEditor)object).diff(fSRevisionRoot, l3, iSVNGNUDiffGenerator, outputStream);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDiff(File file, String string, boolean bl2, boolean bl3, boolean bl4, OutputStream outputStream) {
        FSFS fSFS = this.open(file, string);
        try {
            Object object;
            FSTransactionInfo fSTransactionInfo = fSFS.openTxn(string);
            FSTransactionRoot fSTransactionRoot = fSFS.createTransactionRoot(fSTransactionInfo);
            long l2 = fSTransactionInfo.getBaseRevision();
            if (!SVNRevision.isValidRevisionNumber(l2)) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Transaction ''{0}'' is not based on a revision; how odd", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            object = this.generateDeltaTree(fSFS, fSTransactionRoot, l2);
            ISVNGNUDiffGenerator iSVNGNUDiffGenerator = this.getDiffGenerator();
            iSVNGNUDiffGenerator.setDiffAdded(bl3);
            iSVNGNUDiffGenerator.setDiffCopied(bl4);
            iSVNGNUDiffGenerator.setDiffDeleted(bl2);
            ((SVNNodeEditor)object).diff(fSTransactionRoot, l2, iSVNGNUDiffGenerator, outputStream);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    public SVNPropertyValue doGetProperty(File file, String string, String string2, SVNRevision sVNRevision) {
        SVNProperties sVNProperties = this.getProperties(file, string, string2, sVNRevision, null, true, false);
        return sVNProperties.getSVNPropertyValue(string);
    }

    public SVNProperties doGetProperties(File file, String string, SVNRevision sVNRevision) {
        return this.getProperties(file, null, string, sVNRevision, null, false, false);
    }

    public SVNPropertyValue doGetProperty(File file, String string, String string2, String string3) {
        SVNProperties sVNProperties = this.getProperties(file, string, string2, null, string3, true, false);
        return sVNProperties.getSVNPropertyValue(string);
    }

    public SVNProperties doGetProperties(File file, String string, String string2) {
        return this.getProperties(file, null, string, null, string2, false, false);
    }

    public SVNPropertyValue doGetRevisionProperty(File file, String string, SVNRevision sVNRevision) {
        SVNProperties sVNProperties = this.getProperties(file, string, null, sVNRevision, null, true, true);
        return sVNProperties.getSVNPropertyValue(string);
    }

    public SVNProperties doGetRevisionProperties(File file, SVNRevision sVNRevision) {
        return this.getProperties(file, null, null, sVNRevision, null, false, true);
    }

    public SVNPropertyValue doGetRevisionProperty(File file, String string, String string2) {
        SVNProperties sVNProperties = this.getProperties(file, string, null, null, string2, true, true);
        return sVNProperties.getSVNPropertyValue(string);
    }

    public SVNProperties doGetRevisionProperties(File file, String string) {
        return this.getProperties(file, null, null, null, string, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doGetFileSize(File file, String string, String string2) {
        Object object;
        if (string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = this.open(file, string2);
        try {
            FSTransactionInfo fSTransactionInfo = ((FSFS)object).openTxn(string2);
            FSTransactionRoot fSTransactionRoot = ((FSFS)object).createTransactionRoot(fSTransactionInfo);
            long l2 = this.getFileSize(fSTransactionRoot, string);
            return l2;
        }
        finally {
            SVNAdminHelper.closeRepository((FSFS)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doGetFileSize(File file, String string, SVNRevision sVNRevision) {
        Object object;
        if (string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = this.open(file, sVNRevision);
        try {
            long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, ((FSFS)object).getYoungestRevision(), (FSFS)object);
            FSRevisionRoot fSRevisionRoot = ((FSFS)object).createRevisionRoot(l2);
            long l3 = this.getFileSize(fSRevisionRoot, string);
            return l3;
        }
        finally {
            SVNAdminHelper.closeRepository((FSFS)object);
        }
    }

    public void setDiffGenerator(ISVNGNUDiffGenerator iSVNGNUDiffGenerator) {
        this.myDiffGenerator = iSVNGNUDiffGenerator;
    }

    public ISVNGNUDiffGenerator getDiffGenerator() {
        if (this.myDiffGenerator == null) {
            DefaultSVNGNUDiffGenerator defaultSVNGNUDiffGenerator = new DefaultSVNGNUDiffGenerator();
            defaultSVNGNUDiffGenerator.setOptions(this.getOptions());
            this.myDiffGenerator = defaultSVNGNUDiffGenerator;
        }
        return this.myDiffGenerator;
    }

    private void getTree(FSFS fSFS, FSRoot fSRoot, String string, SVNNodeKind sVNNodeKind, FSID fSID, boolean bl2, int n2, boolean bl3, ISVNTreeHandler iSVNTreeHandler) {
        this.checkCancelled();
        if (iSVNTreeHandler != null) {
            iSVNTreeHandler.handlePath(new SVNAdminPath(string, bl2 ? fSID.toString() : null, n2, sVNNodeKind == SVNNodeKind.DIR));
        }
        if (sVNNodeKind != SVNNodeKind.DIR) {
            return;
        }
        if (bl3 || n2 == 0) {
            FSRevisionNode fSRevisionNode = fSRoot.getRevisionNode(string);
            Map map = fSRevisionNode.getDirEntries(fSFS);
            for (String string2 : map.keySet()) {
                FSEntry fSEntry = (FSEntry)map.get(string2);
                this.getTree(fSFS, fSRoot, SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, fSEntry.getName())), fSEntry.getType(), bl2 ? fSEntry.getId() : null, bl2, n2 + 1, bl3, iSVNTreeHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNProperties getProperties(File file, String string, String string2, SVNRevision sVNRevision, String string3, boolean bl2, boolean bl3) {
        Object object;
        if (string == null && bl2) {
            object = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing propname argument");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (string2 == null && !bl3) {
            object = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = string3 == null ? this.open(file, sVNRevision) : this.open(file, string3);
        try {
            FSRoot fSRoot = null;
            if (string3 == null) {
                long l2 = SVNAdminHelper.getRevisionNumber(sVNRevision, ((FSFS)object).getYoungestRevision(), (FSFS)object);
                if (bl3) {
                    SVNProperties sVNProperties = ((FSFS)object).getRevisionProperties(l2);
                    return sVNProperties;
                }
                fSRoot = ((FSFS)object).createRevisionRoot(l2);
            } else {
                FSTransactionInfo fSTransactionInfo = ((FSFS)object).openTxn(string3);
                if (bl3) {
                    SVNProperties sVNProperties = ((FSFS)object).getTransactionProperties(fSTransactionInfo.getTxnId());
                    return sVNProperties;
                }
                fSRoot = ((FSFS)object).createTransactionRoot(fSTransactionInfo);
            }
            this.verifyPath(fSRoot, string2);
            FSRevisionNode fSRevisionNode = fSRoot.getRevisionNode(string2);
            SVNProperties sVNProperties = fSRevisionNode.getProperties((FSFS)object);
            return sVNProperties;
        }
        finally {
            SVNAdminHelper.closeRepository((FSFS)object);
        }
    }

    private void getHistory(FSFS fSFS, String string, long l2, long l3, long l4, boolean bl2, boolean bl3, ISVNHistoryHandler iSVNHistoryHandler) {
        long l5;
        SVNErrorMessage sVNErrorMessage;
        if (!SVNRevision.isValidRevisionNumber(l2)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid start revision {0}", (Object)String.valueOf(l2));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (!SVNRevision.isValidRevisionNumber(l3)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid end revision {0}", (Object)String.valueOf(l3));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (l2 > l3) {
            long l6 = l2;
            l2 = l3;
            l3 = l6;
        }
        FSRevisionRoot fSRevisionRoot = fSFS.createRevisionRoot(l3);
        FSNodeHistory fSNodeHistory = fSRevisionRoot.getNodeHistory(string);
        long l7 = 0L;
        while ((fSNodeHistory = fSNodeHistory.getPreviousHistory(bl2)) != null && (l5 = fSNodeHistory.getHistoryEntry().getRevision()) >= l2) {
            String string2 = null;
            if (bl3) {
                FSRevisionRoot fSRevisionRoot2 = fSFS.createRevisionRoot(l5);
                FSRevisionNode fSRevisionNode = fSRevisionRoot2.getRevisionNode(fSNodeHistory.getHistoryEntry().getPath());
                string2 = fSRevisionNode.getId().toString();
            }
            if (iSVNHistoryHandler != null) {
                try {
                    iSVNHistoryHandler.handlePath(new SVNAdminPath(fSNodeHistory.getHistoryEntry().getPath(), string2, l5));
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.CEASE_INVOCATION) break;
                    throw sVNException;
                }
            }
            if ((l4 <= 0L || ++l7 < l4) && fSNodeHistory != null) continue;
        }
    }

    private SVNNodeEditor generateDeltaTree(FSFS fSFS, FSRoot fSRoot, long l2) {
        FSRevisionRoot fSRevisionRoot = fSFS.createRevisionRoot(l2);
        SVNNodeEditor sVNNodeEditor = new SVNNodeEditor(fSFS, fSRevisionRoot, this);
        FSRepositoryUtil.replay(fSFS, fSRoot, "", -1L, false, sVNNodeEditor);
        return sVNNodeEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void catFile(FSRoot fSRoot, String string, OutputStream outputStream) {
        Object object;
        SVNNodeKind sVNNodeKind = this.verifyPath(fSRoot, string);
        if (sVNNodeKind != SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Path ''{0}'' is not a file", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (outputStream != null) {
            object = null;
            try {
                object = fSRoot.getFileStreamForPath(new SVNDeltaCombiner(), string);
                byte[] byArray = new byte[16384];
                int n2 = 0;
                do {
                    this.checkCancelled();
                    n2 = SVNFileUtil.readIntoBuffer((InputStream)object, byArray, 0, byArray.length);
                    if (n2 <= 0) continue;
                    outputStream.write(byArray, 0, n2);
                } while (n2 == 16384);
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
            }
            finally {
                SVNFileUtil.closeFile((InputStream)object);
            }
        }
    }

    private long getFileSize(FSRoot fSRoot, String string) {
        SVNNodeKind sVNNodeKind = this.verifyPath(fSRoot, string);
        if (sVNNodeKind != SVNNodeKind.FILE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Path ''{0}'' is not a file", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return fSRoot.getFileSize(string);
    }

    private SVNNodeKind verifyPath(FSRoot fSRoot, String string) {
        SVNNodeKind sVNNodeKind = fSRoot.checkNodeKind(string);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage sVNErrorMessage;
            if (SVNPathUtil.isURL(string)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' is a URL, probably should be a path", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' does not exist", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return sVNNodeKind;
    }

    private FSFS open(File file, SVNRevision sVNRevision) {
        if (sVNRevision == null || !sVNRevision.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Invalid revision number supplied");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return SVNAdminHelper.openRepository(file, true);
    }

    private FSFS open(File file, String string) {
        if (string == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing transaction name");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return SVNAdminHelper.openRepository(file, true);
    }
}

