/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;

public class SVNAdminEvent {
    private String myTxnName;
    private File myTxnDir;
    private long myShard;
    private long myRevision;
    private long myOriginalRevision;
    private long myDroppedRevisionsCount;
    private int myDroppedNodesCount;
    private SVNAdminEventAction myAction;
    private String myPath;
    private String myMessage;
    private SVNLock myLock;
    private SVNErrorMessage myError;

    public SVNAdminEvent(long l2, long l3, SVNAdminEventAction sVNAdminEventAction, String string) {
        this.myRevision = l2;
        this.myOriginalRevision = l3;
        this.myAction = sVNAdminEventAction;
        this.myMessage = string;
    }

    public SVNAdminEvent(SVNAdminEventAction sVNAdminEventAction, String string, String string2) {
        this.myAction = sVNAdminEventAction;
        this.myPath = string;
        if (this.myPath != null && this.myPath.startsWith("/")) {
            this.myPath = this.myPath.substring("/".length());
        }
        this.myMessage = string2;
    }

    public SVNAdminEvent(SVNAdminEventAction sVNAdminEventAction, long l2) {
        this.myAction = sVNAdminEventAction;
        this.myShard = l2;
    }

    public SVNAdminEvent(long l2, SVNAdminEventAction sVNAdminEventAction, String string) {
        this.myOriginalRevision = -1L;
        this.myRevision = -1L;
        this.myMessage = string;
        if (sVNAdminEventAction == SVNAdminEventAction.REVISION_LOAD) {
            this.myOriginalRevision = l2;
        } else {
            this.myRevision = l2;
        }
        this.myAction = sVNAdminEventAction;
    }

    public SVNAdminEvent(String string, File file, SVNAdminEventAction sVNAdminEventAction) {
        this.myTxnName = string;
        this.myTxnDir = file;
        this.myRevision = -1L;
        this.myOriginalRevision = -1L;
        this.myAction = sVNAdminEventAction;
    }

    public SVNAdminEvent(SVNAdminEventAction sVNAdminEventAction, SVNLock sVNLock, SVNErrorMessage sVNErrorMessage, String string) {
        this.myError = sVNErrorMessage;
        this.myMessage = string;
        this.myAction = sVNAdminEventAction;
        this.myLock = sVNLock;
    }

    public SVNAdminEvent(SVNAdminEventAction sVNAdminEventAction, String string) {
        this.myAction = sVNAdminEventAction;
        this.myMessage = string;
    }

    public SVNAdminEvent(SVNAdminEventAction sVNAdminEventAction) {
        this(sVNAdminEventAction, null);
    }

    public SVNAdminEventAction getAction() {
        return this.myAction;
    }

    public String getMessage() {
        return this.myMessage == null ? "" : this.myMessage;
    }

    public long getOriginalRevision() {
        return this.myOriginalRevision;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public File getTxnDir() {
        return this.myTxnDir;
    }

    public String getTxnName() {
        return this.myTxnName;
    }

    public String getPath() {
        return this.myPath;
    }

    public SVNLock getLock() {
        return this.myLock;
    }

    public SVNErrorMessage getError() {
        return this.myError;
    }

    public long getDroppedRevisionsCount() {
        return this.myDroppedRevisionsCount;
    }

    public int getDroppedNodesCount() {
        return this.myDroppedNodesCount;
    }

    public void setDroppedRevisionsCount(long l2) {
        this.myDroppedRevisionsCount = l2;
    }

    public void setDroppedNodesCount(int n2) {
        this.myDroppedNodesCount = n2;
    }

    public long getShard() {
        return this.myShard;
    }
}

