/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSHotCopier;
import org.tmatesoft.svn.core.internal.io.fs.FSPacker;
import org.tmatesoft.svn.core.internal.io.fs.FSRecoverer;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.wc.DefaultDumpFilterHandler;
import org.tmatesoft.svn.core.internal.wc.DefaultDumpFilterHandler$RevisionItem;
import org.tmatesoft.svn.core.internal.wc.DefaultLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminDeltifier;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNDumpEditor;
import org.tmatesoft.svn.core.internal.wc.SVNDumpStreamParser;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.replicator.SVNRepositoryReplicator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminBasicClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient$1;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient$SessionInfo;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNReplayHandler;
import org.tmatesoft.svn.core.wc.admin.SVNSyncInfo;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminClient
extends SVNAdminBasicClient {
    private ISVNLogEntryHandler mySyncHandler;
    private DefaultDumpFilterHandler myDumpFilterHandler;
    private ISVNAdminEventHandler myEventHandler;
    private FSHotCopier myHotCopier;
    private SVNDumpStreamParser myDumpStreamParser;
    private SVNDumpEditor myDumpEditor;
    private static final int LOCK_RETRY_COUNT = 10;

    public SVNAdminClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNAdminClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNAdminClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public void setReplayHandler(ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.mySyncHandler = iSVNLogEntryHandler;
    }

    @Override
    public void setEventHandler(ISVNEventHandler iSVNEventHandler) {
        super.setEventHandler(iSVNEventHandler);
        if (iSVNEventHandler instanceof ISVNAdminEventHandler) {
            this.myEventHandler = (ISVNAdminEventHandler)iSVNEventHandler;
        }
    }

    public SVNURL doCreateRepository(File file, String string, boolean bl2, boolean bl3) {
        return this.doCreateRepository(file, string, bl2, bl3, false);
    }

    public SVNURL doCreateRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4) {
        return this.doCreateRepository(file, string, bl2, bl3, bl4, false);
    }

    public SVNURL doCreateRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        return this.doCreateRepository(file, string, bl2, bl3, bl4, bl5, bl6, false, false);
    }

    public SVNURL doCreateRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        return this.doCreateRepository(file, string, bl2, bl3, bl4, bl5, bl6, bl7, bl8, false);
    }

    public SVNURL doCreateRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        return SVNRepositoryFactory.createLocalRepository(file, string, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9);
    }

    public SVNURL doCreateRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return this.doCreateRepository(file, string, bl2, bl3, bl4, bl5, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopyRevisionProperties(SVNURL sVNURL, long l2, long l3) {
        SVNRepository sVNRepository = null;
        SVNAdminClient$SessionInfo sVNAdminClient$SessionInfo = null;
        SVNException sVNException = null;
        SVNException sVNException2 = null;
        try {
            SVNErrorMessage sVNErrorMessage;
            sVNRepository = this.createRepository(sVNURL, null, true);
            this.checkIfRepositoryIsAtRoot(sVNRepository, sVNURL);
            this.lock(sVNRepository);
            sVNAdminClient$SessionInfo = this.openSourceRepository(sVNRepository);
            if (!SVNRevision.isValidRevisionNumber(l2)) {
                l2 = sVNAdminClient$SessionInfo.myLastMergedRevision;
            }
            if (!SVNRevision.isValidRevisionNumber(l3)) {
                l3 = sVNAdminClient$SessionInfo.myLastMergedRevision;
            }
            if (l2 > sVNAdminClient$SessionInfo.myLastMergedRevision) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy revprops for a revision ({0}) that has not been synchronized yet", (Object)String.valueOf(l2));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (l3 > sVNAdminClient$SessionInfo.myLastMergedRevision) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy revprops for a revision ({0}) that has not been synchronized yet", (Object)String.valueOf(l3));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            int n2 = 0;
            long l4 = l2 > l3 ? -1L : 1L;
            for (long i2 = l2; i2 != l3 + l4; i2 += l4) {
                this.checkCancelled();
                SVNProperties sVNProperties = this.copyRevisionProperties(sVNAdminClient$SessionInfo.myRepository, sVNRepository, i2, false);
                n2 += sVNProperties.size();
            }
            this.handleNormalizedProperties(n2, 0);
        }
        catch (SVNException sVNException3) {
            sVNException = sVNException3;
        }
        finally {
            try {
                this.unlock(sVNRepository);
                if (sVNRepository != null) {
                    sVNRepository.closeSession();
                }
                if (sVNAdminClient$SessionInfo != null && sVNAdminClient$SessionInfo.myRepository != null) {
                    sVNAdminClient$SessionInfo.myRepository.closeSession();
                }
            }
            catch (SVNException sVNException4) {
                sVNException2 = sVNException4;
            }
        }
        if (sVNException != null) {
            throw sVNException;
        }
        if (sVNException2 != null) {
            throw sVNException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInitialize(SVNURL sVNURL, SVNURL sVNURL2) {
        SVNRepository sVNRepository = null;
        SVNRepository sVNRepository2 = null;
        SVNException sVNException = null;
        SVNException sVNException2 = null;
        try {
            Serializable serializable;
            Object object;
            Serializable serializable2;
            sVNRepository = this.createRepository(sVNURL2, null, true);
            this.checkIfRepositoryIsAtRoot(sVNRepository, sVNURL2);
            this.lock(sVNRepository);
            long l2 = sVNRepository.getLatestRevision();
            if (l2 != 0L) {
                serializable2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot initialize a repository with content in it");
                SVNErrorManager.error(serializable2, SVNLogType.FSFS);
            }
            if ((serializable2 = sVNRepository.getRevisionPropertyValue(0L, "svn:sync-from-url")) != null) {
                object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination repository is already synchronizing from ''{0}''", (Object)serializable2);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            if (SVNPathUtil.getPathAsChild(((SVNURL)(object = (sVNRepository2 = this.createRepository(sVNURL, null, false)).getRepositoryRoot(true))).toString(), sVNURL.toString()) != null) {
                boolean bl2;
                block21: {
                    bl2 = false;
                    try {
                        bl2 = sVNRepository2.hasCapability(SVNCapability.PARTIAL_REPLAY);
                    }
                    catch (SVNException sVNException3) {
                        if (sVNException3.getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) break block21;
                        throw sVNException3;
                    }
                }
                if (!bl2) {
                    serializable = SVNErrorMessage.create(SVNErrorCode.RA_PARTIAL_REPLAY_NOT_SUPPORTED);
                    SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
                }
            }
            sVNRepository.setRevisionPropertyValue(0L, "svn:sync-from-url", SVNPropertyValue.create(sVNURL.toString()));
            String string = sVNRepository2.getRepositoryUUID(true);
            sVNRepository.setRevisionPropertyValue(0L, "svn:sync-from-uuid", SVNPropertyValue.create(string));
            sVNRepository.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNPropertyValue.create("0"));
            serializable = this.copyRevisionProperties(sVNRepository2, sVNRepository, 0L, false);
            this.handleNormalizedProperties(((SVNProperties)serializable).size(), 0);
        }
        catch (SVNException sVNException4) {
            sVNException = sVNException4;
        }
        finally {
            try {
                this.unlock(sVNRepository);
                if (sVNRepository != null) {
                    sVNRepository.closeSession();
                }
                if (sVNRepository2 != null) {
                    sVNRepository2.closeSession();
                }
            }
            catch (SVNException sVNException5) {
                sVNException2 = sVNException5;
            }
        }
        if (sVNException != null) {
            throw sVNException;
        }
        if (sVNException2 != null) {
            throw sVNException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNSyncInfo doInfo(SVNURL sVNURL) {
        SVNRepository sVNRepository = null;
        try {
            Serializable serializable;
            sVNRepository = this.createRepository(sVNURL, null, true);
            this.checkIfRepositoryIsAtRoot(sVNRepository, sVNURL);
            SVNPropertyValue sVNPropertyValue = sVNRepository.getRevisionPropertyValue(0L, "svn:sync-from-url");
            if (sVNPropertyValue == null) {
                serializable = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Repository ''{0}'' is not initialized for synchronization", (Object)sVNURL);
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
            }
            serializable = sVNRepository.getRevisionPropertyValue(0L, "svn:sync-from-uuid");
            SVNPropertyValue sVNPropertyValue2 = sVNRepository.getRevisionPropertyValue(0L, "svn:sync-last-merged-rev");
            long l2 = sVNPropertyValue2 != null ? Long.parseLong(sVNPropertyValue2.getString()) : -1L;
            SVNSyncInfo sVNSyncInfo = new SVNSyncInfo(sVNPropertyValue.getString(), serializable != null ? ((SVNPropertyValue)serializable).getString() : null, l2);
            return sVNSyncInfo;
        }
        finally {
            if (sVNRepository != null) {
                sVNRepository.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPack(File file) {
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            FSPacker fSPacker = new FSPacker(this.myEventHandler);
            fSPacker.pack(fSFS);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCompleteSynchronize(SVNURL sVNURL, SVNURL sVNURL2) {
        try {
            this.doInitialize(sVNURL, sVNURL2);
            this.doSynchronize(sVNURL2);
            return;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                throw sVNException;
            }
            SVNRepositoryReplicator sVNRepositoryReplicator = SVNRepositoryReplicator.newInstance();
            SVNRepository sVNRepository = null;
            SVNRepository sVNRepository2 = null;
            try {
                sVNRepository = this.createRepository(sVNURL, null, true);
                sVNRepository2 = this.createRepository(sVNURL2, null, false);
                sVNRepositoryReplicator.replicateRepository(sVNRepository, sVNRepository2, 1L, -1L);
            }
            finally {
                if (sVNRepository != null) {
                    sVNRepository.closeSession();
                }
                if (sVNRepository2 != null) {
                    sVNRepository2.closeSession();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSynchronize(SVNURL sVNURL) {
        SVNRepository sVNRepository = null;
        SVNRepository sVNRepository2 = null;
        SVNException sVNException = null;
        SVNException sVNException2 = null;
        try {
            sVNRepository = this.createRepository(sVNURL, null, true);
            this.checkIfRepositoryIsAtRoot(sVNRepository, sVNURL);
            this.lock(sVNRepository);
            SVNAdminClient$SessionInfo sVNAdminClient$SessionInfo = this.openSourceRepository(sVNRepository);
            sVNRepository2 = sVNAdminClient$SessionInfo.myRepository;
            long l2 = sVNAdminClient$SessionInfo.myLastMergedRevision;
            SVNPropertyValue sVNPropertyValue = sVNRepository.getRevisionPropertyValue(0L, "svn:sync-currently-copying");
            long l3 = sVNRepository.getLatestRevision();
            int n2 = 0;
            if (sVNPropertyValue != null) {
                Serializable serializable;
                long l4 = -1L;
                try {
                    l4 = Long.parseLong(sVNPropertyValue.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, numberFormatException), SVNLogType.WC);
                }
                if (l4 < l2 || l4 > l2 + 1L || l3 != l2 && l3 != l4) {
                    serializable = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Revision being currently copied ({0}), last merged revision ({1}), and destination HEAD ({2}) are inconsistent; have you committed to the destination without using svnsync?", String.valueOf(l4), String.valueOf(l2), String.valueOf(l3));
                    SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
                } else if (l4 == l3) {
                    if (l4 > l2) {
                        serializable = this.copyRevisionProperties(sVNRepository2, sVNRepository, l3, true);
                        n2 += ((SVNProperties)serializable).size();
                        l2 = l4;
                    }
                    sVNRepository.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNPropertyValue.create(SVNProperty.toString(l2)));
                    sVNRepository.setRevisionPropertyValue(0L, "svn:sync-currently-copying", null);
                }
            } else if (l3 != l2) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination HEAD ({0}) is not the last merged revision ({1}); have you committed to the destination without using svnsync?", String.valueOf(l3), String.valueOf(l2));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            long l5 = sVNRepository2.getLatestRevision();
            if (l5 < l2) {
                return;
            }
            boolean bl2 = sVNRepository.hasCapability(SVNCapability.COMMIT_REVPROPS);
            this.checkCancelled();
            long l6 = l2 + 1L;
            long l7 = l5;
            SVNReplayHandler sVNReplayHandler = new SVNReplayHandler(sVNRepository, bl2, this.mySyncHandler, this.getDebugLog(), this, this);
            sVNRepository2.replayRange(l6, l7, 0L, true, sVNReplayHandler);
            this.handleNormalizedProperties(n2 + sVNReplayHandler.getNormalizedRevPropsCount(), sVNReplayHandler.getNormalizedNodePropsCount());
        }
        catch (SVNException sVNException3) {
            sVNException = sVNException3;
        }
        finally {
            try {
                this.unlock(sVNRepository);
                if (sVNRepository != null) {
                    sVNRepository.closeSession();
                }
                if (sVNRepository2 != null) {
                    sVNRepository2.closeSession();
                }
            }
            catch (SVNException sVNException4) {
                sVNException2 = sVNException4;
            }
        }
        if (sVNException != null) {
            throw sVNException;
        }
        if (sVNException2 != null) {
            throw sVNException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doListLocks(File file) {
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            File file2 = fSFS.getDigestFileFromRepositoryPath("/");
            SVNAdminClient$1 sVNAdminClient$1 = new SVNAdminClient$1(this);
            fSFS.walkDigestFiles(file2, sVNAdminClient$1, false);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveLocks(File file, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                if (string == null) continue;
                this.checkCancelled();
                SVNLock sVNLock = null;
                try {
                    SVNAdminEvent sVNAdminEvent;
                    sVNLock = fSFS.getLockHelper(string, false);
                    if (sVNLock == null) {
                        if (this.myEventHandler == null) continue;
                        sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.NOT_LOCKED, null, null, "Path '" + string + "' isn't locked.");
                        this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                        continue;
                    }
                    fSFS.unlockPath(string, sVNLock.getID(), null, true, false);
                    if (this.myEventHandler == null) continue;
                    sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.UNLOCKED, sVNLock, null, "Removed lock on '" + string + "'.");
                    this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                    continue;
                }
                catch (SVNException sVNException) {
                    if (this.myEventHandler == null) continue;
                    SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.UNLOCK_FAILED, sVNLock, sVNException.getErrorMessage(), "svnadmin: " + sVNException.getErrorMessage().getFullMessage());
                    this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                }
            }
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doListTransactions(File file) {
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            Map map = fSFS.listTransactions();
            for (String string : map.keySet()) {
                File file2 = (File)map.get(string);
                if (this.myEventHandler == null) continue;
                SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(string, file2, SVNAdminEventAction.TRANSACTION_LISTED);
                this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
            }
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveTransactions(File file, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                fSFS.openTxn(string);
                fSFS.purgeTxn(string);
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "Transaction '" + string + "' removed.\n");
                if (this.myEventHandler == null) continue;
                SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(string, fSFS.getTransactionDir(string), SVNAdminEventAction.TRANSACTION_REMOVED);
                this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
            }
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    public void doVerify(File file) {
        this.doVerify(file, SVNRevision.create(0L), SVNRevision.HEAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doVerify(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            long l2 = fSFS.getYoungestRevision();
            long l3 = SVNAdminHelper.getRevisionNumber(sVNRevision, l2, fSFS);
            long l4 = SVNAdminHelper.getRevisionNumber(sVNRevision2, l2, fSFS);
            if (!SVNRevision.isValidRevisionNumber(l4)) {
                l4 = l3;
            }
            this.verify(fSFS, l3, l4);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDump(File file, OutputStream outputStream, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3) {
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            long l2 = fSFS.getYoungestRevision();
            long l3 = SVNAdminHelper.getRevisionNumber(sVNRevision, l2, fSFS);
            long l4 = SVNAdminHelper.getRevisionNumber(sVNRevision2, l2, fSFS);
            if (!SVNRevision.isValidRevisionNumber(l3)) {
                l3 = 0L;
                l4 = l2;
            } else if (!SVNRevision.isValidRevisionNumber(l4)) {
                l4 = l3;
            }
            if (l3 > l4) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "First revision cannot be higher than second");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            this.dump(fSFS, outputStream, l3, l4, bl2, bl3);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    public void doLoad(File file, InputStream inputStream) {
        this.doLoad(file, inputStream, false, false, SVNUUIDAction.DEFAULT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoad(File file, InputStream inputStream, boolean bl2, boolean bl3, SVNUUIDAction sVNUUIDAction, String string) {
        CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
        FSFS fSFS = null;
        try {
            fSFS = SVNAdminHelper.openRepository(file, true);
            DefaultLoadHandler defaultLoadHandler = this.createLoadHandler(fSFS, bl2, bl3, sVNUUIDAction, string);
            SVNDumpStreamParser sVNDumpStreamParser = this.getDumpStreamParser();
            sVNDumpStreamParser.parseDumpStream(inputStream, defaultLoadHandler, charsetDecoder);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecover(File file) {
        try (FSFS fSFS = null;){
            Object object;
            fSFS = SVNAdminHelper.openRepositoryForRecovery(file);
            if (this.myEventHandler != null) {
                object = new SVNAdminEvent(SVNAdminEventAction.RECOVERY_STARTED);
                this.myEventHandler.handleAdminEvent((SVNAdminEvent)object, -1.0);
            }
            object = new FSRecoverer(fSFS, this);
            ((FSRecoverer)object).runRecovery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade(File file) {
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            Object object;
            if (this.myEventHandler != null) {
                object = new SVNAdminEvent(SVNAdminEventAction.UPGRADE);
                this.myEventHandler.handleAdminEvent((SVNAdminEvent)object, -1.0);
            }
            object = fSFS.getRepositoryFormatFile();
            int n2 = fSFS.getReposFormat();
            SVNFileUtil.writeVersionFile((File)object, n2);
            fSFS.upgrade();
            SVNFileUtil.writeVersionFile((File)object, 5);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetUUID(File file, String string) {
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            if (string == null) {
                string = SVNUUIDGenerator.generateUUIDString();
            } else {
                String[] stringArray = string.split("-");
                if (stringArray.length != 5) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_UUID, "Malformed UUID ''{0}''", (Object)string);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
            }
            fSFS.setUUID(string);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHotCopy(File file, File file2) {
        FSFS fSFS = SVNAdminHelper.openRepository(file, false);
        try {
            FSHotCopier fSHotCopier = this.getHotCopier();
            fSHotCopier.runHotCopy(fSFS, file2);
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getYoungestRevision(File file) {
        FSFS fSFS = SVNAdminHelper.openRepository(file, true);
        try {
            long l2 = fSFS.getYoungestRevision();
            return l2;
        }
        finally {
            SVNAdminHelper.closeRepository(fSFS);
        }
    }

    public void doFilter(InputStream inputStream, OutputStream outputStream, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Collection collection, boolean bl6) {
        CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
        this.writeDumpData(outputStream, "SVN-fs-dump-format-version: 2\n\n");
        DefaultDumpFilterHandler defaultDumpFilterHandler = this.getDumpFilterHandler(outputStream, bl2, bl3, bl4, bl5, collection, bl6);
        SVNDumpStreamParser sVNDumpStreamParser = this.getDumpStreamParser();
        sVNDumpStreamParser.parseDumpStream(inputStream, defaultDumpFilterHandler, charsetDecoder);
        if (this.myEventHandler != null) {
            String string;
            String[] stringArray;
            Object object;
            Object object2;
            if (defaultDumpFilterHandler.getDroppedRevisionsCount() > 0L) {
                object2 = MessageFormat.format("Dropped {0} revision(s).", String.valueOf(defaultDumpFilterHandler.getDroppedRevisionsCount()));
                object = new SVNAdminEvent(SVNAdminEventAction.DUMP_FILTER_TOTAL_REVISIONS_DROPPED, (String)object2);
                object.setDroppedRevisionsCount(defaultDumpFilterHandler.getDroppedRevisionsCount());
                this.myEventHandler.handleAdminEvent((SVNAdminEvent)object, -1.0);
            }
            if (bl3) {
                object2 = defaultDumpFilterHandler.getRenumberHistory();
                object = object2.keySet().toArray(new Long[object2.size()]);
                Arrays.sort(object);
                for (int i2 = ((Object[])object).length; i2 > 0; --i2) {
                    SVNAdminEvent sVNAdminEvent;
                    stringArray = object[i2 - 1];
                    DefaultDumpFilterHandler$RevisionItem defaultDumpFilterHandler$RevisionItem = (DefaultDumpFilterHandler$RevisionItem)object2.get(stringArray);
                    if (defaultDumpFilterHandler$RevisionItem.wasDropped()) {
                        string = MessageFormat.format("{0} => (dropped)", stringArray.toString());
                        sVNAdminEvent = new SVNAdminEvent(stringArray.longValue(), SVNAdminEventAction.DUMP_FILTER_DROPPED_RENUMBERED_REVISION, string);
                        this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                        continue;
                    }
                    string = MessageFormat.format("{0} => {1}", stringArray.toString(), String.valueOf(defaultDumpFilterHandler$RevisionItem.getRevision()));
                    sVNAdminEvent = new SVNAdminEvent(defaultDumpFilterHandler$RevisionItem.getRevision(), stringArray.longValue(), SVNAdminEventAction.DUMP_FILTER_RENUMBERED_REVISION, string);
                    this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                }
            }
            if (!(object2 = defaultDumpFilterHandler.getDroppedNodes()).isEmpty()) {
                object = MessageFormat.format("Dropped {0} node(s)", String.valueOf(object2.size()));
                SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.DUMP_FILTER_TOTAL_NODES_DROPPED, (String)object);
                sVNAdminEvent.setDroppedNodesCount(object2.size());
                this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                stringArray = object2.keySet().toArray(new String[object2.size()]);
                Arrays.sort(stringArray, SVNPathUtil.PATH_COMPARATOR);
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    string = stringArray[i3];
                    object = "'" + string + "'";
                    sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.DUMP_FILTER_DROPPED_NODE, string, (String)object);
                    this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                }
            }
        }
    }

    protected void handlePropertesCopied(boolean bl2, long l2) {
        if (this.myEventHandler != null) {
            String string = null;
            string = bl2 ? MessageFormat.format("Copied properties for revision {0} ({1}* properties skipped).", String.valueOf(l2), "svn:sync-") : MessageFormat.format("Copied properties for revision {0}.", String.valueOf(l2));
            SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(l2, SVNAdminEventAction.REVISION_PROPERTIES_COPIED, string);
            this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
        }
    }

    protected void handleNormalizedProperties(int n2, int n3) {
        if (this.myEventHandler != null && (n2 > 0 || n3 > 0)) {
            String string = MessageFormat.format("NOTE: Normalized {0}* properties to LF line endings ({1} rev-props, {2} node-props).", "svn:", String.valueOf(n2), String.valueOf(n3));
            SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.NORMALIZED_PROPERTIES, string);
            this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
        }
    }

    private FSHotCopier getHotCopier() {
        if (this.myHotCopier == null) {
            this.myHotCopier = new FSHotCopier();
        }
        return this.myHotCopier;
    }

    private void verify(FSFS fSFS, long l2, long l3) {
        SVNErrorMessage sVNErrorMessage;
        long l4 = fSFS.getYoungestRevision();
        if (!SVNRevision.isValidRevisionNumber(l2)) {
            l2 = 0L;
        }
        if (!SVNRevision.isValidRevisionNumber(l3)) {
            l3 = l4;
        }
        if (l2 > l3) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Start revision {0} is greater than end revision {1}", String.valueOf(l2), String.valueOf(l3));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (l3 > l4) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "End revision {0} is invalid (youngest revision is {1})", String.valueOf(l3), String.valueOf(l4));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        for (long i2 = l2; i2 <= l3; ++i2) {
            FSRevisionRoot fSRevisionRoot = fSFS.createRevisionRoot(i2);
            ISVNEditor iSVNEditor = this.getDumpEditor(fSFS, fSRevisionRoot, i2, l2, "/", SVNFileUtil.DUMMY_OUT, false, true);
            iSVNEditor = SVNCancellableEditor.newInstance(iSVNEditor, this.getEventDispatcher(), this.getDebugLog());
            FSRepositoryUtil.replay(fSFS, fSRevisionRoot, "", -1L, false, iSVNEditor);
            fSFS.getRevisionProperties(i2);
            String string = "* Verified revision " + i2 + ".";
            if (this.myEventHandler == null) continue;
            SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(i2, SVNAdminEventAction.REVISION_DUMPED, string);
            this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
        }
    }

    private void dump(FSFS fSFS, OutputStream outputStream, long l2, long l3, boolean bl2, boolean bl3) {
        Object object;
        boolean bl4 = outputStream != null && outputStream != SVNFileUtil.DUMMY_OUT;
        long l4 = fSFS.getYoungestRevision();
        SVNAdminDeltifier sVNAdminDeltifier = new SVNAdminDeltifier(fSFS, SVNDepth.INFINITY, false, false, false, null);
        if (!SVNRevision.isValidRevisionNumber(l2)) {
            l2 = 0L;
        }
        if (!SVNRevision.isValidRevisionNumber(l3)) {
            l3 = l4;
        }
        if (outputStream == null) {
            outputStream = SVNFileUtil.DUMMY_OUT;
        }
        if (l2 > l3) {
            object = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Start revision {0} is greater than end revision {1}", String.valueOf(l2), String.valueOf(l3));
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (l3 > l4) {
            object = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "End revision {0} is invalid (youngest revision is {1})", String.valueOf(l3), String.valueOf(l4));
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (l2 == 0L && bl2) {
            bl2 = false;
        }
        object = fSFS.getUUID();
        int n2 = 3;
        if (!bl3) {
            --n2;
        }
        this.writeDumpData(outputStream, "SVN-fs-dump-format-version: " + n2 + "\n\n");
        this.writeDumpData(outputStream, "UUID: " + (String)object + "\n\n");
        for (long i2 = l2; i2 <= l3; ++i2) {
            Object object2;
            long l5;
            Object object3;
            long l6;
            this.checkCancelled();
            if (i2 == l2 && !bl2) {
                if (i2 == 0L) {
                    this.writeRevisionRecord(outputStream, fSFS, 0L);
                    l6 = 0L;
                    String string = (bl4 ? "* Dumped" : "* Verified") + " revision " + l6 + ".";
                    if (this.myEventHandler == null) continue;
                    object3 = new SVNAdminEvent(l6, SVNAdminEventAction.REVISION_DUMPED, string);
                    this.myEventHandler.handleAdminEvent((SVNAdminEvent)object3, -1.0);
                    continue;
                }
                l5 = 0L;
                l6 = i2;
            } else {
                l5 = i2 - 1L;
                l6 = i2;
            }
            this.writeRevisionRecord(outputStream, fSFS, l6);
            boolean bl5 = bl3 && (bl2 || i2 != l2);
            object3 = fSFS.createRevisionRoot(l6);
            SVNDumpEditor sVNDumpEditor = this.getDumpEditor(fSFS, (FSRoot)object3, l6, l2, "/", outputStream, bl5, false);
            if (i2 == l2 && !bl2) {
                object2 = fSFS.createRevisionRoot(l5);
                sVNAdminDeltifier.setEditor(sVNDumpEditor);
                sVNAdminDeltifier.deltifyDir((FSRevisionRoot)object2, "/", "", (FSRevisionRoot)object3, "/");
            } else {
                FSRepositoryUtil.replay(fSFS, (FSRoot)object3, "", -1L, false, sVNDumpEditor);
            }
            object2 = (bl4 ? "* Dumped" : "* Verified") + " revision " + l6 + ".";
            if (this.myEventHandler == null) continue;
            SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(l6, SVNAdminEventAction.REVISION_DUMPED, (String)object2);
            this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
        }
    }

    private void writeRevisionRecord(OutputStream outputStream, FSFS fSFS, long l2) {
        Object object;
        SVNProperties sVNProperties = fSFS.getRevisionProperties(l2);
        String string = sVNProperties.getStringValue("svn:date");
        if (string != null) {
            object = SVNDate.parseDate(string);
            sVNProperties.put("svn:date", ((SVNDate)object).format());
        }
        object = new ByteArrayOutputStream();
        SVNAdminHelper.writeProperties(sVNProperties, null, (OutputStream)object);
        this.writeDumpData(outputStream, "Revision-number: " + l2 + "\n");
        String string2 = null;
        try {
            string2 = new String(((ByteArrayOutputStream)object).toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, unsupportedEncodingException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, unsupportedEncodingException, SVNLogType.FSFS);
        }
        this.writeDumpData(outputStream, "Prop-content-length: " + string2.length() + "\n");
        this.writeDumpData(outputStream, "Content-length: " + string2.length() + "\n\n");
        this.writeDumpData(outputStream, string2);
        this.writeDumpData(outputStream, "\n");
    }

    private void writeDumpData(OutputStream outputStream, String string) {
        try {
            outputStream.write(string.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
    }

    private DefaultLoadHandler createLoadHandler(FSFS fSFS, boolean bl2, boolean bl3, SVNUUIDAction sVNUUIDAction, String string) {
        DefaultLoadHandler defaultLoadHandler = new DefaultLoadHandler(bl2, bl3, sVNUUIDAction, string, this.myEventHandler);
        defaultLoadHandler.setFSFS(fSFS);
        defaultLoadHandler.setUsePreCommitHook(bl2);
        defaultLoadHandler.setUsePostCommitHook(bl3);
        defaultLoadHandler.setUUIDAction(sVNUUIDAction);
        defaultLoadHandler.setParentDir(string);
        return defaultLoadHandler;
    }

    private DefaultDumpFilterHandler getDumpFilterHandler(OutputStream outputStream, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Collection collection, boolean bl6) {
        if (this.myDumpFilterHandler == null) {
            this.myDumpFilterHandler = new DefaultDumpFilterHandler(outputStream, this.myEventHandler, bl2, bl3, bl4, bl5, collection, bl6);
        } else {
            this.myDumpFilterHandler.reset(outputStream, this.myEventHandler, bl2, bl3, bl4, bl5, collection, bl6);
        }
        return this.myDumpFilterHandler;
    }

    private SVNDumpStreamParser getDumpStreamParser() {
        if (this.myDumpStreamParser == null) {
            this.myDumpStreamParser = new SVNDumpStreamParser(this);
        }
        return this.myDumpStreamParser;
    }

    private SVNDumpEditor getDumpEditor(FSFS fSFS, FSRoot fSRoot, long l2, long l3, String string, OutputStream outputStream, boolean bl2, boolean bl3) {
        if (this.myDumpEditor == null) {
            this.myDumpEditor = new SVNDumpEditor(fSFS, fSRoot, l2, l3, string, outputStream, bl2, bl3);
        } else {
            this.myDumpEditor.reset(fSFS, fSRoot, l2, l3, string, outputStream, bl2, bl3);
        }
        return this.myDumpEditor;
    }

    private SVNProperties copyRevisionProperties(SVNRepository sVNRepository, SVNRepository sVNRepository2, long l2, boolean bl2) {
        int n2 = 0;
        SVNProperties sVNProperties = null;
        if (bl2) {
            sVNProperties = sVNRepository2.getRevisionProperties(l2, null);
        }
        SVNProperties sVNProperties2 = sVNRepository.getRevisionProperties(l2, null);
        SVNProperties sVNProperties3 = SVNAdminClient.normalizeRevisionProperties(sVNProperties2);
        n2 += SVNAdminHelper.writeRevisionProperties(sVNRepository2, l2, sVNProperties2);
        if (bl2) {
            SVNAdminHelper.removePropertiesNotInSource(sVNRepository2, l2, sVNProperties2, sVNProperties);
        }
        this.handlePropertesCopied(n2 > 0, l2);
        return sVNProperties3;
    }

    private SVNAdminClient$SessionInfo openSourceRepository(SVNRepository sVNRepository) {
        Object object;
        SVNPropertyValue sVNPropertyValue = sVNRepository.getRevisionPropertyValue(0L, "svn:sync-from-url");
        SVNPropertyValue sVNPropertyValue2 = sVNRepository.getRevisionPropertyValue(0L, "svn:sync-from-uuid");
        SVNPropertyValue sVNPropertyValue3 = sVNRepository.getRevisionPropertyValue(0L, "svn:sync-last-merged-rev");
        if (sVNPropertyValue == null || sVNPropertyValue2 == null || sVNPropertyValue3 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination repository has not been initialized");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = SVNURL.parseURIEncoded(sVNPropertyValue.getString());
        SVNRepository sVNRepository2 = this.createRepository((SVNURL)object, sVNPropertyValue2.getString(), false);
        try {
            return new SVNAdminClient$SessionInfo(this, sVNRepository2, Long.parseLong(sVNPropertyValue3.getString()));
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, numberFormatException), SVNLogType.FSFS);
            return null;
        }
    }

    private void checkIfRepositoryIsAtRoot(SVNRepository sVNRepository, SVNURL sVNURL) {
        SVNURL sVNURL2 = sVNRepository.getRepositoryRoot(true);
        if (!sVNURL2.equals(sVNURL)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Session is rooted at ''{0}'' but the repos root is ''{1}''", sVNURL, sVNURL2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    private void lock(SVNRepository sVNRepository) {
        Serializable serializable;
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can't get local hostname");
            SVNErrorManager.error(sVNErrorMessage, unknownHostException, SVNLogType.FSFS);
        }
        if (string.length() > 256) {
            string = string.substring(0, 256);
        }
        String string2 = string + ":" + SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
        int n2 = 0;
        SVNErrorMessage sVNErrorMessage = null;
        for (n2 = 0; n2 < 10; ++n2) {
            this.checkCancelled();
            serializable = sVNRepository.getRevisionPropertyValue(0L, "svn:sync-lock");
            if (serializable != null) {
                if (string2.equals(((SVNPropertyValue)serializable).getString())) {
                    return;
                }
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Failed to get lock on destination repos, currently held by ''{0}''", (Object)((SVNPropertyValue)serializable).getString());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (n2 >= 9) continue;
            sVNRepository.setRevisionPropertyValue(0L, "svn:sync-lock", SVNPropertyValue.create(string2));
        }
        serializable = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Couldn''t get lock on destination repos after {0} attempts", (Object)String.valueOf(n2));
        if (sVNErrorMessage != null) {
            ((SVNErrorMessage)serializable).setChildErrorMessage(sVNErrorMessage);
        }
        SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
    }

    private void unlock(SVNRepository sVNRepository) {
        sVNRepository.setRevisionPropertyValue(0L, "svn:sync-lock", null);
    }

    public static SVNProperties normalizeRevisionProperties(SVNProperties sVNProperties) {
        SVNProperties sVNProperties2 = new SVNProperties();
        for (String string : sVNProperties.nameSet()) {
            SVNPropertyValue sVNPropertyValue;
            String string2;
            if (!SVNPropertiesManager.propNeedsTranslation(string) || (string2 = SVNAdminClient.normalizeString(SVNPropertyValue.getPropertyAsString(sVNPropertyValue = sVNProperties.getSVNPropertyValue(string)))) == null) continue;
            sVNProperties2.put(string, SVNPropertyValue.create(string2));
        }
        sVNProperties.putAll(sVNProperties2);
        return sVNProperties2;
    }

    public static String normalizeString(String string) {
        if (string != null && string.indexOf(SVNProperty.EOL_CR_BYTES[0]) != -1) {
            return SVNTranslator.translateString(string, SVNProperty.EOL_LF_BYTES, null, true, false);
        }
        return null;
    }

    static /* synthetic */ ISVNAdminEventHandler access$000(SVNAdminClient sVNAdminClient) {
        return sVNAdminClient.myEventHandler;
    }
}

