/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminBasicClient
implements ISVNEventHandler {
    private ISVNRepositoryPool myRepositoryPool;
    private ISVNOptions myOptions;
    private ISVNEventHandler myEventDispatcher;
    private ISVNDebugLog myDebugLog;

    protected SVNRepository createRepository(SVNURL sVNURL, String string, boolean bl2) {
        String string2;
        SVNRepository sVNRepository = null;
        sVNRepository = this.myRepositoryPool == null ? SVNRepositoryFactory.create(sVNURL, null) : this.myRepositoryPool.createRepository(sVNURL, bl2);
        if (string != null && !string.equals(string2 = sVNRepository.getRepositoryUUID(true))) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_UUID_MISMATCH, "Repository UUID ''{0}'' doesn''t match expected UUID ''{1}''", string2, string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNRepository.setDebugLog(this.getDebugLog());
        sVNRepository.setCanceller(this.getEventDispatcher());
        return sVNRepository;
    }

    protected void dispatchEvent(SVNEvent sVNEvent, double d2) {
        if (this.myEventDispatcher != null) {
            try {
                this.myEventDispatcher.handleEvent(sVNEvent, d2);
            }
            catch (SVNException sVNException) {
                throw sVNException;
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logSevere(SVNLogType.WC, throwable);
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Error while dispatching event: {0}", new Object[]{throwable.getMessage()}, 0, throwable);
                SVNErrorManager.error(sVNErrorMessage, throwable, SVNLogType.DEFAULT);
            }
        }
    }

    public void setDebugLog(ISVNDebugLog iSVNDebugLog) {
        this.myDebugLog = iSVNDebugLog;
    }

    public ISVNOptions getOptions() {
        return this.myOptions;
    }

    @Override
    public void checkCancelled() {
        if (this.myEventDispatcher != null) {
            this.myEventDispatcher.checkCancelled();
        }
    }

    public void setEventHandler(ISVNEventHandler iSVNEventHandler) {
        this.myEventDispatcher = iSVNEventHandler;
    }

    protected ISVNEventHandler getEventDispatcher() {
        return this.myEventDispatcher;
    }

    protected SVNAdminBasicClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        this(new DefaultSVNRepositoryPool(iSVNAuthenticationManager == null ? SVNWCUtil.createDefaultAuthenticationManager() : iSVNAuthenticationManager, (ISVNTunnelProvider)iSVNOptions, 0L, false), iSVNOptions);
    }

    protected SVNAdminBasicClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        this.myRepositoryPool = iSVNRepositoryPool;
        this.setOptions(iSVNOptions);
    }

    protected SVNAdminBasicClient(SvnOperationFactory svnOperationFactory) {
        this.myRepositoryPool = svnOperationFactory.getRepositoryPool();
        this.setOptions(svnOperationFactory.getOptions());
    }

    public void setOptions(ISVNOptions iSVNOptions) {
        this.myOptions = iSVNOptions;
        if (this.myOptions == null) {
            this.myOptions = SVNWCUtil.createDefaultOptions(true);
        }
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }

    @Override
    public void handleEvent(SVNEvent sVNEvent, double d2) {
        this.dispatchEvent(sVNEvent, d2);
    }
}

