/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNWCUtil$EclipseVersion;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;

public class SVNWCUtil {
    private static final String ECLIPSE_AUTH_MANAGER_CLASSNAME = "org.tmatesoft.svn.core.internal.wc.EclipseSVNAuthenticationManager";
    private static Boolean ourIsEclipse;

    public static File getDefaultConfigurationDirectory() {
        if (SVNFileUtil.isWindows && !SVNFileUtil.isOS2) {
            return new File(SVNFileUtil.getApplicationDataPath(), "Subversion");
        }
        if (SVNFileUtil.isOpenVMS) {
            return new File("/sys$login", ".subversion").getAbsoluteFile();
        }
        return new File(System.getProperty("user.home"), ".subversion");
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager() {
        return SVNWCUtil.createDefaultAuthenticationManager(SVNWCUtil.getDefaultConfigurationDirectory(), null, (char[])null);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File file) {
        return SVNWCUtil.createDefaultAuthenticationManager(file, null, (char[])null, true);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(String string, char[] cArray) {
        return SVNWCUtil.createDefaultAuthenticationManager(null, string, cArray);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(String string, String string2) {
        return SVNWCUtil.createDefaultAuthenticationManager(null, string, string2);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File file, String string, char[] cArray) {
        DefaultSVNOptions defaultSVNOptions = SVNWCUtil.createDefaultOptions(file, true);
        boolean bl2 = defaultSVNOptions.isAuthStorageEnabled();
        return SVNWCUtil.createDefaultAuthenticationManager(file, string, cArray, bl2);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File file, String string, String string2) {
        DefaultSVNOptions defaultSVNOptions = SVNWCUtil.createDefaultOptions(file, true);
        boolean bl2 = defaultSVNOptions.isAuthStorageEnabled();
        return SVNWCUtil.createDefaultAuthenticationManager(file, string, string2, bl2);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File file, String string, char[] cArray, boolean bl2) {
        return SVNWCUtil.createDefaultAuthenticationManager(file, string, cArray, null, null, bl2);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File file, String string, String string2, boolean bl2) {
        return SVNWCUtil.createDefaultAuthenticationManager(file, string, string2, null, null, bl2);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File file, String string, char[] cArray, File file2, char[] cArray2, boolean bl2) {
        if (SVNWCUtil.isEclipseKeyringSupported()) {
            try {
                Constructor<?> constructor;
                Class<?> clazz;
                ClassLoader classLoader = SVNWCUtil.class.getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                if ((clazz = classLoader.loadClass(ECLIPSE_AUTH_MANAGER_CLASSNAME)) != null && (constructor = clazz.getConstructor(File.class, Boolean.TYPE, String.class, char[].class, File.class, char[].class)) != null) {
                    return (ISVNAuthenticationManager)constructor.newInstance(file, bl2 ? Boolean.TRUE : Boolean.FALSE, string, cArray, file2, cArray2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new DefaultSVNAuthenticationManager(file, bl2, string, cArray, file2, cArray2);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File file, String string, String string2, File file2, String string3, boolean bl2) {
        char[] cArray = string2 != null ? string2.toCharArray() : null;
        char[] cArray2 = string3 != null ? string3.toCharArray() : null;
        return SVNWCUtil.createDefaultAuthenticationManager(file, string, cArray, file2, cArray2, bl2);
    }

    public static DefaultSVNOptions createDefaultOptions(File file, boolean bl2) {
        return new DefaultSVNOptions(file, bl2);
    }

    public static DefaultSVNOptions createDefaultOptions(boolean bl2) {
        return new DefaultSVNOptions(null, bl2);
    }

    public static boolean isVersionedDirectory(File file) {
        return SvnOperationFactory.isVersionedDirectory(file);
    }

    public static boolean isWorkingCopyRoot(File file) {
        return SvnOperationFactory.isWorkingCopyRoot(file);
    }

    public static boolean isWorkingCopyRoot(File file, boolean bl2) {
        if (SVNWCUtil.isWorkingCopyRoot(file)) {
            if (!bl2) {
                return true;
            }
            File file2 = SvnOperationFactory.getWorkingCopyRoot(file, false);
            return file2.equals(file);
        }
        return false;
    }

    public static File getWorkingCopyRoot(File file, boolean bl2) {
        return SvnOperationFactory.getWorkingCopyRoot(file, bl2);
    }

    public static synchronized boolean isEclipseKeyringSupported() {
        if (ourIsEclipse == null) {
            ourIsEclipse = Boolean.FALSE;
            try {
                Class<?> clazz;
                Method method;
                Object object;
                ClassLoader classLoader = SVNWCUtil.class.getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                if ((object = (method = (clazz = classLoader.loadClass("org.eclipse.core.runtime.Platform")).getMethod("isRunning", new Class[0])).invoke(null, new Object[0])) != null && Boolean.TRUE.equals(object)) {
                    SVNWCUtil$EclipseVersion sVNWCUtil$EclipseVersion = SVNWCUtil.getBundle("org.eclipse.core.runtime.compatibility.auth");
                    boolean bl2 = false;
                    if (sVNWCUtil$EclipseVersion != null && sVNWCUtil$EclipseVersion.major >= 3) {
                        bl2 = true;
                    } else {
                        SVNWCUtil$EclipseVersion sVNWCUtil$EclipseVersion2 = SVNWCUtil.getBundle("org.eclipse.core.runtime");
                        bl2 = sVNWCUtil$EclipseVersion2.major < 3 || sVNWCUtil$EclipseVersion2.major == 3 && sVNWCUtil$EclipseVersion2.minor <= 2;
                    }
                    ourIsEclipse = bl2 ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ourIsEclipse;
    }

    private static SVNWCUtil$EclipseVersion getBundle(String string) {
        Class<?> clazz;
        ClassLoader classLoader = SVNWCUtil.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((clazz = classLoader.loadClass("org.eclipse.core.runtime.Platform")) == null) {
            return null;
        }
        Method method = clazz.getMethod("getBundle", String.class);
        Object object = method.invoke(null, string);
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = classLoader.loadClass("org.osgi.framework.Bundle");
        Method method2 = clazz2.getMethod("getVersion", new Class[0]);
        Object object2 = method2.invoke(object, new Object[0]);
        if (object2 == null) {
            return null;
        }
        Class<?> clazz3 = classLoader.loadClass("org.osgi.framework.Version");
        Method method3 = clazz3.getMethod("getMajor", new Class[0]);
        Method method4 = clazz3.getMethod("getMinor", new Class[0]);
        Object object3 = method3.invoke(object2, new Object[0]);
        Object object4 = method4.invoke(object2, new Object[0]);
        SVNWCUtil$EclipseVersion sVNWCUtil$EclipseVersion = new SVNWCUtil$EclipseVersion(null);
        sVNWCUtil$EclipseVersion.major = (Integer)object3;
        sVNWCUtil$EclipseVersion.minor = (Integer)object4;
        return sVNWCUtil$EclipseVersion;
    }
}

