/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNAddParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyValueProvider;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient$1;
import org.tmatesoft.svn.core.wc.SVNWCClient$10;
import org.tmatesoft.svn.core.wc.SVNWCClient$11;
import org.tmatesoft.svn.core.wc.SVNWCClient$12;
import org.tmatesoft.svn.core.wc.SVNWCClient$2;
import org.tmatesoft.svn.core.wc.SVNWCClient$3;
import org.tmatesoft.svn.core.wc.SVNWCClient$4;
import org.tmatesoft.svn.core.wc.SVNWCClient$5;
import org.tmatesoft.svn.core.wc.SVNWCClient$6;
import org.tmatesoft.svn.core.wc.SVNWCClient$7;
import org.tmatesoft.svn.core.wc.SVNWCClient$8;
import org.tmatesoft.svn.core.wc.SVNWCClient$9;
import org.tmatesoft.svn.core.wc2.SvnCat;
import org.tmatesoft.svn.core.wc2.SvnCleanup;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnGetStatusSummary;
import org.tmatesoft.svn.core.wc2.SvnMarkReplaced;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRemoteSetProperty;
import org.tmatesoft.svn.core.wc2.SvnResolve;
import org.tmatesoft.svn.core.wc2.SvnRevert;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnScheduleForRemoval;
import org.tmatesoft.svn.core.wc2.SvnSetLock;
import org.tmatesoft.svn.core.wc2.SvnSetProperty;
import org.tmatesoft.svn.core.wc2.SvnStatusSummary;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUnlock;
import org.tmatesoft.svn.core.wc2.SvnUpgrade;

public class SVNWCClient
extends SVNBasicClient {
    private ISVNAddParameters addParameters;
    private ISVNCommitHandler commitHandler;
    private boolean revertMissingDirectories;
    public static ISVNAddParameters DEFAULT_ADD_PARAMETERS = new SVNWCClient$1();

    public SVNWCClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNWCClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNWCClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    @Override
    protected void initDefaults() {
        this.setCommitHandler(null);
        this.setAddParameters(null);
    }

    public void setAddParameters(ISVNAddParameters iSVNAddParameters) {
        if (iSVNAddParameters == null) {
            iSVNAddParameters = DEFAULT_ADD_PARAMETERS;
        }
        this.addParameters = iSVNAddParameters;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.commitHandler;
    }

    public void setCommitHandler(ISVNCommitHandler iSVNCommitHandler) {
        if (iSVNCommitHandler == null) {
            iSVNCommitHandler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = iSVNCommitHandler;
    }

    public void setRevertMissingDirectories(boolean bl2) {
        this.revertMissingDirectories = bl2;
    }

    public boolean isRevertMissingDirectories() {
        return this.revertMissingDirectories;
    }

    public void doGetFileContents(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, OutputStream outputStream) {
        SvnCat svnCat = this.getOperationsFactory().createCat();
        if (sVNRevision2 == SVNRevision.UNDEFINED) {
            sVNRevision2 = sVNRevision != null && sVNRevision.isValid() ? sVNRevision : SVNRevision.BASE;
        }
        svnCat.setSingleTarget(SvnTarget.fromFile(file, sVNRevision));
        svnCat.setRevision(sVNRevision2);
        svnCat.setExpandKeywords(bl2);
        svnCat.setOutput(outputStream);
        svnCat.run();
    }

    public void doGetFileContents(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, OutputStream outputStream) {
        SvnCat svnCat = this.getOperationsFactory().createCat();
        if (sVNRevision2 == SVNRevision.UNDEFINED) {
            sVNRevision2 = sVNRevision != null && sVNRevision.isValid() ? sVNRevision : SVNRevision.HEAD;
        }
        svnCat.setSingleTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnCat.setRevision(sVNRevision2);
        svnCat.setExpandKeywords(bl2);
        svnCat.setOutput(outputStream);
        svnCat.run();
    }

    public void doCleanup(File file) {
        SvnCleanup svnCleanup = this.getOperationsFactory().createCleanup();
        svnCleanup.setSingleTarget(SvnTarget.fromFile(file));
        svnCleanup.run();
    }

    public void doCleanup(File file, boolean bl2) {
        SvnCleanup svnCleanup = this.getOperationsFactory().createCleanup();
        svnCleanup.setSingleTarget(SvnTarget.fromFile(file));
        svnCleanup.setDeleteWCProperties(bl2);
        svnCleanup.run();
    }

    public void doCleanup(File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        SvnCleanup svnCleanup = this.getOperationsFactory().createCleanup();
        svnCleanup.setSingleTarget(SvnTarget.fromFile(file));
        svnCleanup.setDeleteWCProperties(bl2);
        svnCleanup.setBreakLocks(bl3);
        svnCleanup.setVacuumPristines(bl4);
        svnCleanup.setRemoveUnversionedItems(bl5);
        svnCleanup.setRemoveIgnoredItems(bl6);
        svnCleanup.setIncludeExternals(bl7);
        svnCleanup.run();
    }

    public void doSetProperty(File file, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, SVNDepth sVNDepth, ISVNPropertyHandler iSVNPropertyHandler, Collection collection) {
        SvnSetProperty svnSetProperty = this.getOperationsFactory().createSetProperty();
        svnSetProperty.setPropertyName(string);
        svnSetProperty.setPropertyValue(sVNPropertyValue);
        svnSetProperty.setForce(bl2);
        svnSetProperty.setDepth(sVNDepth);
        svnSetProperty.setSingleTarget(SvnTarget.fromFile(file));
        svnSetProperty.setApplicalbeChangelists(collection);
        svnSetProperty.setReceiver(SvnCodec.propertyReceiver(iSVNPropertyHandler));
        svnSetProperty.run();
    }

    public void doSetProperty(File file, ISVNPropertyValueProvider iSVNPropertyValueProvider, boolean bl2, SVNDepth sVNDepth, ISVNPropertyHandler iSVNPropertyHandler, Collection collection) {
        SvnSetProperty svnSetProperty = this.getOperationsFactory().createSetProperty();
        svnSetProperty.setPropertyValueProvider(SvnCodec.propertyValueProvider(iSVNPropertyValueProvider));
        svnSetProperty.setForce(bl2);
        svnSetProperty.setDepth(sVNDepth);
        svnSetProperty.setSingleTarget(SvnTarget.fromFile(file));
        svnSetProperty.setApplicalbeChangelists(collection);
        svnSetProperty.setReceiver(SvnCodec.propertyReceiver(iSVNPropertyHandler));
        svnSetProperty.run();
    }

    public SVNCommitInfo doSetProperty(SVNURL sVNURL, String string, SVNPropertyValue sVNPropertyValue, SVNRevision sVNRevision, String string2, SVNProperties sVNProperties, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        SvnRemoteSetProperty svnRemoteSetProperty = this.getOperationsFactory().createRemoteSetProperty();
        svnRemoteSetProperty.setSingleTarget(SvnTarget.fromURL(sVNURL));
        svnRemoteSetProperty.setPropertyName(string);
        svnRemoteSetProperty.setPropertyValue(sVNPropertyValue);
        svnRemoteSetProperty.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        svnRemoteSetProperty.setRevisionProperties(sVNProperties);
        svnRemoteSetProperty.setCommitMessage(string2);
        svnRemoteSetProperty.setPropertyReceiver(new SVNWCClient$2(this, iSVNPropertyHandler));
        return (SVNCommitInfo)svnRemoteSetProperty.run();
    }

    public void doSetRevisionProperty(File file, SVNRevision sVNRevision, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        SvnSetProperty svnSetProperty = this.getOperationsFactory().createSetProperty();
        svnSetProperty.setRevisionProperty(true);
        svnSetProperty.setSingleTarget(SvnTarget.fromFile(file));
        svnSetProperty.setRevision(sVNRevision);
        svnSetProperty.setPropertyName(string);
        svnSetProperty.setPropertyValue(sVNPropertyValue);
        svnSetProperty.setForce(bl2);
        SVNPropertyData sVNPropertyData = (SVNPropertyData)svnSetProperty.run();
        if (iSVNPropertyHandler != null) {
            iSVNPropertyHandler.handleProperty(sVNRevision != null ? sVNRevision.getNumber() : -1L, sVNPropertyData);
        }
    }

    public void doSetRevisionProperty(SVNURL sVNURL, SVNRevision sVNRevision, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        SvnSetProperty svnSetProperty = this.getOperationsFactory().createSetProperty();
        svnSetProperty.setRevisionProperty(true);
        svnSetProperty.setSingleTarget(SvnTarget.fromURL(sVNURL));
        svnSetProperty.setRevision(sVNRevision);
        svnSetProperty.setPropertyName(string);
        svnSetProperty.setPropertyValue(sVNPropertyValue);
        svnSetProperty.setForce(bl2);
        SVNPropertyData sVNPropertyData = (SVNPropertyData)svnSetProperty.run();
        if (iSVNPropertyHandler != null) {
            iSVNPropertyHandler.handleProperty(sVNRevision != null ? sVNRevision.getNumber() : -1L, sVNPropertyData);
        }
    }

    public SVNPropertyData doGetProperty(File file, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        SVNPropertyData[] sVNPropertyDataArray = new SVNPropertyData[1];
        SvnGetProperties svnGetProperties = this.getOperationsFactory().createGetProperties();
        svnGetProperties.setSingleTarget(SvnTarget.fromFile(file, sVNRevision));
        svnGetProperties.setRevision(sVNRevision2);
        svnGetProperties.setDepth(SVNDepth.EMPTY);
        svnGetProperties.setReceiver(new SVNWCClient$3(this, string, sVNPropertyDataArray));
        svnGetProperties.run();
        return sVNPropertyDataArray[0];
    }

    public SVNPropertyData doGetProperty(SVNURL sVNURL, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        SVNPropertyData[] sVNPropertyDataArray = new SVNPropertyData[1];
        SvnGetProperties svnGetProperties = this.getOperationsFactory().createGetProperties();
        svnGetProperties.setSingleTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnGetProperties.setRevision(sVNRevision2);
        svnGetProperties.setDepth(SVNDepth.EMPTY);
        svnGetProperties.setReceiver(new SVNWCClient$4(this, string, sVNPropertyDataArray));
        svnGetProperties.run();
        return sVNPropertyDataArray[0];
    }

    public void doGetProperty(File file, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        this.doGetProperty(file, string, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrEmptyDepth(bl2), iSVNPropertyHandler, null);
    }

    public void doGetProperty(File file, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, ISVNPropertyHandler iSVNPropertyHandler, Collection collection) {
        SvnGetProperties svnGetProperties = this.getOperationsFactory().createGetProperties();
        svnGetProperties.setSingleTarget(SvnTarget.fromFile(file, sVNRevision));
        svnGetProperties.setRevision(sVNRevision2);
        svnGetProperties.setDepth(sVNDepth);
        svnGetProperties.setApplicalbeChangelists(collection);
        svnGetProperties.setReceiver(new SVNWCClient$5(this, string, iSVNPropertyHandler));
        svnGetProperties.run();
    }

    public void doGetProperty(SVNURL sVNURL, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        this.doGetProperty(sVNURL, string, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrEmptyDepth(bl2), iSVNPropertyHandler);
    }

    public void doGetProperty(SVNURL sVNURL, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, ISVNPropertyHandler iSVNPropertyHandler) {
        SvnGetProperties svnGetProperties = this.getOperationsFactory().createGetProperties();
        svnGetProperties.setSingleTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnGetProperties.setRevision(sVNRevision2);
        svnGetProperties.setDepth(sVNDepth);
        svnGetProperties.setReceiver(new SVNWCClient$6(this, string, iSVNPropertyHandler));
        svnGetProperties.run();
    }

    public long doGetRevisionProperty(File file, String string, SVNRevision sVNRevision, ISVNPropertyHandler iSVNPropertyHandler) {
        SvnGetProperties svnGetProperties = this.getOperationsFactory().createGetProperties();
        svnGetProperties.setSingleTarget(SvnTarget.fromFile(file));
        svnGetProperties.setRevisionProperties(true);
        svnGetProperties.setRevision(sVNRevision);
        svnGetProperties.setReceiver(new SVNWCClient$7(this, string, iSVNPropertyHandler, svnGetProperties));
        svnGetProperties.run();
        return svnGetProperties.getRevisionNumber();
    }

    public long doGetRevisionProperty(SVNURL sVNURL, String string, SVNRevision sVNRevision, ISVNPropertyHandler iSVNPropertyHandler) {
        SvnGetProperties svnGetProperties = this.getOperationsFactory().createGetProperties();
        svnGetProperties.setSingleTarget(SvnTarget.fromURL(sVNURL));
        svnGetProperties.setRevisionProperties(true);
        svnGetProperties.setRevision(sVNRevision);
        svnGetProperties.setReceiver(new SVNWCClient$8(this, string, iSVNPropertyHandler, svnGetProperties));
        svnGetProperties.run();
        return svnGetProperties.getRevisionNumber();
    }

    public void doDelete(File file, boolean bl2, boolean bl3) {
        this.doDelete(file, bl2, true, bl3);
    }

    public void doDelete(File file, boolean bl2, boolean bl3, boolean bl4) {
        SvnScheduleForRemoval svnScheduleForRemoval = this.getOperationsFactory().createScheduleForRemoval();
        svnScheduleForRemoval.setSingleTarget(SvnTarget.fromFile(file));
        svnScheduleForRemoval.setForce(bl2);
        svnScheduleForRemoval.setDeleteFiles(bl3);
        svnScheduleForRemoval.setDryRun(bl4);
        svnScheduleForRemoval.run();
    }

    public void doAdd(File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        File[] fileArray = new File[]{file};
        this.doAdd(fileArray, bl2, bl3, bl4, SVNDepth.fromRecurse(bl5), false, false, bl4);
    }

    public void doAdd(File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        File[] fileArray = new File[]{file};
        this.doAdd(fileArray, bl2, bl3, bl4, SVNDepth.fromRecurse(bl5), false, bl6, bl4);
    }

    public void doAdd(File file, boolean bl2, boolean bl3, boolean bl4, SVNDepth sVNDepth, boolean bl5, boolean bl6) {
        File[] fileArray = new File[]{file};
        this.doAdd(fileArray, bl2, bl3, bl4, sVNDepth, false, bl5, bl6);
    }

    public void doAdd(File[] fileArray, boolean bl2, boolean bl3, boolean bl4, SVNDepth sVNDepth, boolean bl5, boolean bl6, boolean bl7) {
        this.doAdd(fileArray, bl2, bl3, bl4, sVNDepth, bl5, bl6, bl7, true);
    }

    public void doAdd(File[] fileArray, boolean bl2, boolean bl3, boolean bl4, SVNDepth sVNDepth, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        SvnScheduleForAddition svnScheduleForAddition = this.getOperationsFactory().createScheduleForAddition();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            svnScheduleForAddition.addTarget(SvnTarget.fromFile(fileArray[i2]));
        }
        svnScheduleForAddition.setMkDir(bl3);
        svnScheduleForAddition.setForce(bl2);
        svnScheduleForAddition.setDepth(sVNDepth);
        svnScheduleForAddition.setDepth(sVNDepth);
        svnScheduleForAddition.setIncludeIgnored(bl6);
        svnScheduleForAddition.setAddParents(bl7);
        svnScheduleForAddition.setAddParameters(SvnCodec.addParameters(this.addParameters));
        svnScheduleForAddition.setApplyAutoProperties(bl8);
        svnScheduleForAddition.run();
    }

    public void doAdd(File file, boolean bl2, boolean bl3, boolean bl4, SVNDepth sVNDepth, boolean bl5, boolean bl6, boolean bl7) {
        File[] fileArray = new File[]{file};
        this.doAdd(fileArray, bl2, bl3, bl4, sVNDepth, bl5, bl6, bl7);
    }

    public void doMarkReplaced(File file) {
        SvnMarkReplaced svnMarkReplaced = this.getOperationsFactory().createMarkReplaced();
        svnMarkReplaced.setSingleTarget(SvnTarget.fromFile(file));
        svnMarkReplaced.run();
    }

    public void doRevert(File file, boolean bl2) {
        this.doRevert(new File[]{file}, SVNDepth.fromRecurse(bl2), null);
    }

    public void doRevert(File[] fileArray, boolean bl2) {
        this.doRevert(fileArray, SVNDepth.fromRecurse(bl2), null);
    }

    public void doRevert(File[] fileArray, SVNDepth sVNDepth, Collection collection) {
        SvnRevert svnRevert = this.getOperationsFactory().createRevert();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            svnRevert.addTarget(SvnTarget.fromFile(fileArray[i2]));
        }
        svnRevert.setDepth(sVNDepth);
        svnRevert.setApplicalbeChangelists(collection);
        svnRevert.setRevertMissingDirectories(this.revertMissingDirectories);
        svnRevert.run();
    }

    public void doResolve(File file, boolean bl2) {
        this.doResolve(file, SVNDepth.fromRecurse(bl2), SVNConflictChoice.MINE_FULL);
    }

    public void doResolve(File file, SVNDepth sVNDepth, SVNConflictChoice sVNConflictChoice) {
        SvnResolve svnResolve = this.getOperationsFactory().createResolve();
        svnResolve.addTarget(SvnTarget.fromFile(file));
        svnResolve.setDepth(sVNDepth);
        svnResolve.setConflictChoice(sVNConflictChoice);
        svnResolve.run();
    }

    public void doResolve(File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, SVNConflictChoice sVNConflictChoice) {
        SvnResolve svnResolve = this.getOperationsFactory().createResolve();
        svnResolve.addTarget(SvnTarget.fromFile(file));
        svnResolve.setDepth(sVNDepth);
        svnResolve.setResolveContents(bl2);
        svnResolve.setResolveProperties(bl3);
        svnResolve.setConflictChoice(sVNConflictChoice);
        svnResolve.run();
    }

    public void doResolve(File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, SVNConflictChoice sVNConflictChoice) {
        SvnResolve svnResolve = this.getOperationsFactory().createResolve();
        svnResolve.addTarget(SvnTarget.fromFile(file));
        svnResolve.setDepth(sVNDepth);
        svnResolve.setResolveContents(bl2);
        svnResolve.setResolveProperties(bl3);
        svnResolve.setResolveTree(bl4);
        svnResolve.setConflictChoice(sVNConflictChoice);
        svnResolve.run();
    }

    public void doLock(File[] fileArray, boolean bl2, String string) {
        SvnSetLock svnSetLock = this.getOperationsFactory().createSetLock();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            svnSetLock.addTarget(SvnTarget.fromFile(fileArray[i2]));
        }
        svnSetLock.setStealLock(bl2);
        svnSetLock.setLockMessage(string);
        svnSetLock.run();
    }

    public void doLock(SVNURL[] sVNURLArray, boolean bl2, String string) {
        SvnSetLock svnSetLock = this.getOperationsFactory().createSetLock();
        for (int i2 = 0; i2 < sVNURLArray.length; ++i2) {
            svnSetLock.addTarget(SvnTarget.fromURL(sVNURLArray[i2]));
        }
        svnSetLock.setStealLock(bl2);
        svnSetLock.setLockMessage(string);
        svnSetLock.run();
    }

    public void doUnlock(File[] fileArray, boolean bl2) {
        SvnUnlock svnUnlock = this.getOperationsFactory().createUnlock();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            svnUnlock.addTarget(SvnTarget.fromFile(fileArray[i2]));
        }
        svnUnlock.setBreakLock(bl2);
        svnUnlock.run();
    }

    public void doUnlock(SVNURL[] sVNURLArray, boolean bl2) {
        SvnUnlock svnUnlock = this.getOperationsFactory().createUnlock();
        for (int i2 = 0; i2 < sVNURLArray.length; ++i2) {
            svnUnlock.addTarget(SvnTarget.fromURL(sVNURLArray[i2]));
        }
        svnUnlock.setBreakLock(bl2);
        svnUnlock.run();
    }

    public void doInfo(File file, SVNRevision sVNRevision, boolean bl2, ISVNInfoHandler iSVNInfoHandler) {
        this.doInfo(file, SVNRevision.UNDEFINED, sVNRevision, SVNDepth.getInfinityOrEmptyDepth(bl2), null, iSVNInfoHandler);
    }

    public void doInfo(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNInfoHandler iSVNInfoHandler) {
        this.doInfo(file, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrEmptyDepth(bl2), null, iSVNInfoHandler);
    }

    public void doInfo(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, Collection collection, ISVNInfoHandler iSVNInfoHandler) {
        SvnGetInfo svnGetInfo = this.getOperationsFactory().createGetInfo();
        svnGetInfo.setSingleTarget(SvnTarget.fromFile(file, sVNRevision));
        svnGetInfo.setRevision(sVNRevision2);
        svnGetInfo.setDepth(sVNDepth);
        svnGetInfo.setApplicalbeChangelists(collection);
        svnGetInfo.setReceiver(new SVNWCClient$9(this, iSVNInfoHandler));
        svnGetInfo.run();
    }

    public void doInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNInfoHandler iSVNInfoHandler) {
        this.doInfo(sVNURL, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrEmptyDepth(bl2), iSVNInfoHandler);
    }

    public void doInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, ISVNInfoHandler iSVNInfoHandler) {
        SvnGetInfo svnGetInfo = this.getOperationsFactory().createGetInfo();
        svnGetInfo.setSingleTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnGetInfo.setRevision(sVNRevision2);
        svnGetInfo.setDepth(sVNDepth);
        svnGetInfo.setReceiver(new SVNWCClient$10(this, iSVNInfoHandler));
        svnGetInfo.run();
    }

    public String doGetWorkingCopyID(File file, String string) {
        return this.doGetWorkingCopyID(file, string, false);
    }

    public String doGetWorkingCopyID(File file, String string, boolean bl2) {
        SvnStatusSummary svnStatusSummary;
        SvnGetStatusSummary svnGetStatusSummary = this.getOperationsFactory().createGetStatusSummary();
        svnGetStatusSummary.addTarget(SvnTarget.fromFile(file));
        svnGetStatusSummary.setTrailUrl(string);
        svnGetStatusSummary.setCommitted(bl2);
        try {
            svnStatusSummary = (SvnStatusSummary)svnGetStatusSummary.run();
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                SVNFileType sVNFileType = SVNFileType.getType(file);
                if (sVNFileType == SVNFileType.SYMLINK) {
                    return "Unversioned symlink";
                }
                if (sVNFileType == SVNFileType.DIRECTORY) {
                    return "Unversioned directory";
                }
                if (sVNFileType == SVNFileType.FILE) {
                    return "Unversioned file";
                }
                return "'" + file.getPath() + "' doesn't exist";
            }
            throw sVNException;
        }
        if (svnStatusSummary.getMinRevision() < 0L) {
            return "Uncommitted local addition, copy or move";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(svnStatusSummary.getMinRevision());
        if (svnStatusSummary.getMaxRevision() != svnStatusSummary.getMinRevision()) {
            stringBuffer.append(":");
            stringBuffer.append(svnStatusSummary.getMaxRevision());
        }
        stringBuffer.append(svnStatusSummary.isModified() ? "M" : "");
        stringBuffer.append(svnStatusSummary.isSwitched() ? "S" : "");
        stringBuffer.append(svnStatusSummary.isSparseCheckout() ? "P" : "");
        return stringBuffer.toString();
    }

    public SVNInfo doInfo(File file, SVNRevision sVNRevision) {
        SVNInfo[] sVNInfoArray = new SVNInfo[1];
        SvnGetInfo svnGetInfo = this.getOperationsFactory().createGetInfo();
        svnGetInfo.setSingleTarget(SvnTarget.fromFile(file));
        svnGetInfo.setRevision(sVNRevision);
        svnGetInfo.setDepth(SVNDepth.EMPTY);
        svnGetInfo.setReceiver(new SVNWCClient$11(this, sVNInfoArray));
        svnGetInfo.run();
        return sVNInfoArray[0];
    }

    public SVNInfo doInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        SVNInfo[] sVNInfoArray = new SVNInfo[1];
        SvnGetInfo svnGetInfo = this.getOperationsFactory().createGetInfo();
        svnGetInfo.setSingleTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnGetInfo.setRevision(sVNRevision2);
        svnGetInfo.setDepth(SVNDepth.EMPTY);
        svnGetInfo.setReceiver(new SVNWCClient$12(this, sVNInfoArray));
        svnGetInfo.run();
        return sVNInfoArray[0];
    }

    public void doCleanupWCProperties(File file) {
        SVNWCClient16 sVNWCClient16 = new SVNWCClient16(this.getOperationsFactory().getAuthenticationManager(), this.getOptions());
        sVNWCClient16.doCleanupWCProperties(file);
    }

    public void doSetWCFormat(File file, int n2) {
        if (n2 >= 12) {
            SvnUpgrade svnUpgrade = this.getOperationsFactory().createUpgrade();
            svnUpgrade.setSingleTarget(SvnTarget.fromFile(file));
            svnUpgrade.setDepth(SVNDepth.INFINITY);
            svnUpgrade.run();
        } else {
            SVNWCClient16 sVNWCClient16 = new SVNWCClient16(this.getOperationsFactory().getAuthenticationManager(), this.getOptions());
            sVNWCClient16.doSetWCFormat(file, n2);
        }
    }

    public void doSetProperty(File file, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, boolean bl3, ISVNPropertyHandler iSVNPropertyHandler) {
        this.doSetProperty(file, string, sVNPropertyValue, bl2, SVNDepth.fromRecurse(bl3), iSVNPropertyHandler, null);
    }
}

