/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCanonicalizeUrls;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnExport;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRelocate;
import org.tmatesoft.svn.core.wc2.SvnSwitch;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpdate;

public class SVNUpdateClient
extends SVNBasicClient {
    private ISVNExternalsHandler myExternalsHandler;
    private boolean updateLocksOnDemand;
    private boolean exportExpandsKeywords;

    public SVNUpdateClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNUpdateClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNUpdateClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    @Override
    protected void initDefaults() {
        this.setExternalsHandler(null);
    }

    public void setExternalsHandler(ISVNExternalsHandler iSVNExternalsHandler) {
        this.myExternalsHandler = iSVNExternalsHandler;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        if (this.myExternalsHandler == null) {
            return ISVNExternalsHandler.DEFAULT;
        }
        return this.myExternalsHandler;
    }

    public long doUpdate(File file, SVNRevision sVNRevision, boolean bl2) {
        return this.doUpdate(file, sVNRevision, SVNDepth.fromRecurse(bl2), false, false);
    }

    public long doUpdate(File file, SVNRevision sVNRevision, boolean bl2, boolean bl3) {
        return this.doUpdate(file, sVNRevision, SVNDepth.fromRecurse(bl2), bl3, false);
    }

    public long[] doUpdate(File[] fileArray, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl2, boolean bl3) {
        return this.doUpdate(fileArray, sVNRevision, sVNDepth, bl2, bl3, false);
    }

    public long[] doUpdate(File[] fileArray, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4) {
        if (fileArray == null || fileArray.length == 0) {
            return new long[0];
        }
        SvnUpdate svnUpdate = this.getOperationsFactory().createUpdate();
        svnUpdate.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            svnUpdate.addTarget(SvnTarget.fromFile(fileArray[i2]));
        }
        svnUpdate.setRevision(sVNRevision);
        svnUpdate.setDepth(sVNDepth);
        svnUpdate.setDepthIsSticky(bl3);
        svnUpdate.setAllowUnversionedObstructions(bl2);
        svnUpdate.setIgnoreExternals(this.isIgnoreExternals());
        svnUpdate.setMakeParents(bl4);
        svnUpdate.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (long[])svnUpdate.run();
    }

    public long doUpdate(File file, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl2, boolean bl3) {
        long[] lArray = this.doUpdate(new File[]{file}, sVNRevision, sVNDepth, bl2, bl3);
        return lArray[0];
    }

    public void setUpdateLocksOnDemand(boolean bl2) {
        this.updateLocksOnDemand = bl2;
    }

    public boolean isUpdateLocksOnDemand() {
        return this.updateLocksOnDemand;
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, boolean bl2) {
        return this.doSwitch(file, sVNURL, SVNRevision.UNDEFINED, sVNRevision, SVNDepth.getInfinityOrFilesDepth(bl2), false, false);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2) {
        return this.doSwitch(file, sVNURL, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), false, false);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3) {
        return this.doSwitch(file, sVNURL, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, false);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, boolean bl3) {
        return this.doSwitch(file, sVNURL, sVNRevision, sVNRevision2, sVNDepth, bl2, bl3, true);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4) {
        SvnSwitch svnSwitch = this.getOperationsFactory().createSwitch();
        svnSwitch.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        svnSwitch.setSwitchTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnSwitch.setSingleTarget(SvnTarget.fromFile(file));
        svnSwitch.setRevision(sVNRevision2);
        svnSwitch.setDepth(sVNDepth);
        svnSwitch.setDepthIsSticky(bl3);
        svnSwitch.setAllowUnversionedObstructions(bl2);
        svnSwitch.setIgnoreAncestry(bl4);
        svnSwitch.setIgnoreExternals(this.isIgnoreExternals());
        svnSwitch.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (Long)svnSwitch.run();
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2) {
        return this.doCheckout(sVNURL, file, sVNRevision, sVNRevision2, SVNDepth.fromRecurse(bl2), false);
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3) {
        return this.doCheckout(sVNURL, file, sVNRevision, sVNRevision2, SVNDepth.fromRecurse(bl2), bl3);
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2) {
        SvnCheckout svnCheckout = this.getOperationsFactory().createCheckout();
        svnCheckout.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        svnCheckout.setSource(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnCheckout.setSingleTarget(SvnTarget.fromFile(file));
        svnCheckout.setRevision(sVNRevision2);
        svnCheckout.setDepth(sVNDepth);
        svnCheckout.setAllowUnversionedObstructions(bl2);
        svnCheckout.setIgnoreExternals(this.isIgnoreExternals());
        svnCheckout.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (Long)svnCheckout.run();
    }

    public long doExport(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl2, boolean bl3) {
        return this.doExport(sVNURL, file, sVNRevision, sVNRevision2, string, bl2, SVNDepth.fromRecurse(bl3));
    }

    public long doExport(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl2, SVNDepth sVNDepth) {
        SvnExport svnExport = this.getOperationsFactory().createExport();
        svnExport.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        svnExport.setSingleTarget(SvnTarget.fromFile(file));
        svnExport.setSource(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnExport.setRevision(sVNRevision2);
        svnExport.setEolStyle(string);
        svnExport.setForce(bl2);
        svnExport.setDepth(sVNDepth);
        svnExport.setExpandKeywords(this.isExportExpandsKeywords());
        svnExport.setIgnoreExternals(this.isIgnoreExternals());
        svnExport.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (Long)svnExport.run();
    }

    public long doExport(File file, File file2, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl2, boolean bl3) {
        return this.doExport(file, file2, sVNRevision, sVNRevision2, string, bl2, SVNDepth.fromRecurse(bl3));
    }

    public long doExport(File file, File file2, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl2, SVNDepth sVNDepth) {
        SvnExport svnExport = this.getOperationsFactory().createExport();
        svnExport.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        svnExport.setSingleTarget(SvnTarget.fromFile(file2));
        svnExport.setSource(SvnTarget.fromFile(file, sVNRevision));
        svnExport.setRevision(sVNRevision2);
        svnExport.setEolStyle(string);
        svnExport.setForce(bl2);
        svnExport.setIgnoreExternals(this.isIgnoreExternals());
        svnExport.setDepth(sVNDepth);
        svnExport.setExpandKeywords(this.isExportExpandsKeywords());
        svnExport.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (Long)svnExport.run();
    }

    public void doRelocate(File file, SVNURL sVNURL, SVNURL sVNURL2, boolean bl2) {
        SvnRelocate svnRelocate = this.getOperationsFactory().createRelocate();
        svnRelocate.setSingleTarget(SvnTarget.fromFile(file));
        svnRelocate.setFromUrl(sVNURL);
        svnRelocate.setToUrl(sVNURL2);
        svnRelocate.setRecursive(bl2);
        svnRelocate.run();
    }

    public void doCanonicalizeURLs(File file, boolean bl2, boolean bl3) {
        SvnCanonicalizeUrls svnCanonicalizeUrls = this.getOperationsFactory().createCanonicalizeUrls();
        svnCanonicalizeUrls.setSingleTarget(SvnTarget.fromFile(file));
        svnCanonicalizeUrls.setDepth(bl3 ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES);
        svnCanonicalizeUrls.setOmitDefaultPort(bl2);
        svnCanonicalizeUrls.setIgnoreExternals(this.isIgnoreExternals());
        svnCanonicalizeUrls.run();
    }

    public void setExportExpandsKeywords(boolean bl2) {
        this.exportExpandsKeywords = bl2;
    }

    public boolean isExportExpandsKeywords() {
        return this.exportExpandsKeywords;
    }
}

