/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient$1;
import org.tmatesoft.svn.core.wc.SVNStatusClient$2;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNStatusClient
extends SVNBasicClient {
    private ISVNStatusFileProvider myFilesProvider;

    public SVNStatusClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNStatusClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNStatusClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    @Override
    protected void initDefaults() {
        this.setFilesProvider(null);
    }

    public long doStatus(File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ISVNStatusHandler iSVNStatusHandler) {
        return this.doStatus(file, SVNRevision.HEAD, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, false, iSVNStatusHandler, null);
    }

    public long doStatus(File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ISVNStatusHandler iSVNStatusHandler) {
        return this.doStatus(file, SVNRevision.HEAD, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, bl6, iSVNStatusHandler, null);
    }

    public long doStatus(File file, SVNRevision sVNRevision, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ISVNStatusHandler iSVNStatusHandler) {
        return this.doStatus(file, sVNRevision, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, bl6, iSVNStatusHandler, null);
    }

    public long doStatus(File file, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ISVNStatusHandler iSVNStatusHandler, Collection collection) {
        SvnGetStatus svnGetStatus = this.getOperationsFactory().createGetStatus();
        svnGetStatus.setReportExternals(!this.isIgnoreExternals());
        svnGetStatus.setFileListHook(SvnCodec.fileListHook(this.myFilesProvider));
        svnGetStatus.setApplicalbeChangelists(collection);
        svnGetStatus.setCollectParentExternals(bl5);
        svnGetStatus.setDepth(sVNDepth);
        svnGetStatus.setRevision(sVNRevision);
        svnGetStatus.setRemote(bl2);
        svnGetStatus.setReportAll(bl3);
        svnGetStatus.setReportIgnored(bl4);
        svnGetStatus.setSingleTarget(SvnTarget.fromFile(file));
        svnGetStatus.setReceiver(new SVNStatusClient$1(this, svnGetStatus, iSVNStatusHandler));
        svnGetStatus.run();
        return svnGetStatus.getRemoteRevision();
    }

    public SVNStatus doStatus(File file, boolean bl2) {
        return this.doStatus(file, bl2, false);
    }

    public SVNStatus doStatus(File file, boolean bl2, boolean bl3) {
        SVNStatus[] sVNStatusArray = new SVNStatus[]{null};
        File file2 = file.getAbsoluteFile();
        SVNStatusClient$2 sVNStatusClient$2 = new SVNStatusClient$2(this, file2, sVNStatusArray);
        this.doStatus(file2, SVNRevision.HEAD, SVNDepth.EMPTY, bl2, true, true, bl3, sVNStatusClient$2, null);
        return sVNStatusArray[0];
    }

    public void setFilesProvider(ISVNStatusFileProvider iSVNStatusFileProvider) {
        this.myFilesProvider = iSVNStatusFileProvider;
    }
}

