/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class SVNStatus {
    private SVNURL myURL;
    private File myFile;
    private SVNNodeKind myKind;
    private SVNRevision myRevision;
    private SVNRevision myCommittedRevision;
    private Date myCommittedDate;
    private String myAuthor;
    private SVNStatusType myContentsStatus;
    private SVNStatusType myPropertiesStatus;
    private SVNStatusType myRemoteContentsStatus;
    private SVNStatusType myRemoteNodeStatus;
    private SVNStatusType myRemotePropertiesStatus;
    private boolean myIsLocked;
    private boolean myIsCopied;
    private boolean myIsSwitched;
    private boolean myIsFileExternal;
    private File myConflictNewFile;
    private File myConflictOldFile;
    private File myConflictWrkFile;
    private File myPropRejectFile;
    private String myCopyFromURL;
    private SVNRevision myCopyFromRevision;
    private SVNLock myRemoteLock;
    private SVNLock myLocalLock;
    private Map myEntryProperties;
    private SVNRevision myRemoteRevision;
    private SVNURL myRemoteURL;
    private SVNNodeKind myRemoteKind;
    private String myRemoteAuthor;
    private Date myRemoteDate;
    private Date myLocalContentsDate;
    private Date myLocalPropertiesDate;
    private SVNEntry myEntry;
    private String myChangelistName;
    private int myWorkingCopyFormat;
    private SVNTreeConflictDescription myTreeConflict;
    private boolean myIsConflicted;
    private SVNStatusType myNodeStatus;
    private SVNURL myRepositoryRootURL;
    private String myRepositoryUUID;
    private String myRepositoryRelativePath;
    private boolean myIsVersioned;
    private SVNDepth myDepth;
    private File myMovedToPath;
    private File myMovedFromPath;

    public SVNStatus(SVNURL sVNURL, File file, SVNNodeKind sVNNodeKind, SVNRevision sVNRevision, SVNRevision sVNRevision2, Date date, String string, SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2, SVNStatusType sVNStatusType3, SVNStatusType sVNStatusType4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, File file2, File file3, File file4, File file5, String string2, SVNRevision sVNRevision3, SVNLock sVNLock, SVNLock sVNLock2, Map map, String string3, int n2, SVNTreeConflictDescription sVNTreeConflictDescription) {
        this.myURL = sVNURL;
        this.myFile = file;
        this.myKind = sVNNodeKind == null ? SVNNodeKind.NONE : sVNNodeKind;
        this.myRevision = sVNRevision == null ? SVNRevision.UNDEFINED : sVNRevision;
        this.myCommittedRevision = sVNRevision2 == null ? SVNRevision.UNDEFINED : sVNRevision2;
        this.myCommittedDate = date;
        this.myAuthor = string;
        this.myContentsStatus = sVNStatusType == null ? SVNStatusType.STATUS_NONE : sVNStatusType;
        this.myPropertiesStatus = sVNStatusType2 == null ? SVNStatusType.STATUS_NONE : sVNStatusType2;
        this.myRemoteContentsStatus = sVNStatusType3 == null ? SVNStatusType.STATUS_NONE : sVNStatusType3;
        this.myRemotePropertiesStatus = sVNStatusType4 == null ? SVNStatusType.STATUS_NONE : sVNStatusType4;
        this.myRemoteNodeStatus = SVNStatusType.STATUS_NONE;
        this.myIsLocked = bl2;
        this.myIsCopied = bl3;
        this.myIsSwitched = bl4;
        this.myIsFileExternal = bl5;
        this.myConflictNewFile = file2;
        this.myConflictOldFile = file3;
        this.myConflictWrkFile = file4;
        this.myCopyFromURL = string2;
        this.myCopyFromRevision = sVNRevision3 == null ? SVNRevision.UNDEFINED : sVNRevision3;
        this.myRemoteLock = sVNLock;
        this.myLocalLock = sVNLock2;
        this.myPropRejectFile = file5;
        this.myEntryProperties = map;
        this.myChangelistName = string3;
        this.myWorkingCopyFormat = n2;
        this.myTreeConflict = sVNTreeConflictDescription;
        this.myRemoteRevision = SVNRevision.UNDEFINED;
    }

    public SVNStatus() {
        this.setCopyFromRevision(SVNRevision.UNDEFINED);
        this.setRevision(SVNRevision.UNDEFINED);
        this.setRemoteRevision(SVNRevision.UNDEFINED);
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public SVNURL getRemoteURL() {
        return this.myRemoteURL;
    }

    public File getFile() {
        return this.myFile;
    }

    public SVNNodeKind getKind() {
        return this.myKind;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public SVNRevision getCommittedRevision() {
        return this.myCommittedRevision;
    }

    public Date getCommittedDate() {
        return this.myCommittedDate;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public SVNStatusType getContentsStatus() {
        return this.myContentsStatus;
    }

    public SVNStatusType getPropertiesStatus() {
        return this.myPropertiesStatus;
    }

    public SVNStatusType getRemoteContentsStatus() {
        return this.myRemoteContentsStatus;
    }

    public SVNStatusType getRemotePropertiesStatus() {
        return this.myRemotePropertiesStatus;
    }

    public boolean isLocked() {
        return this.myIsLocked;
    }

    public boolean isCopied() {
        return this.myIsCopied;
    }

    public boolean isSwitched() {
        return this.myIsSwitched;
    }

    public boolean isFileExternal() {
        return this.myIsFileExternal;
    }

    public File getConflictNewFile() {
        return this.myConflictNewFile;
    }

    public File getConflictOldFile() {
        return this.myConflictOldFile;
    }

    public File getConflictWrkFile() {
        return this.myConflictWrkFile;
    }

    public File getPropRejectFile() {
        return this.myPropRejectFile;
    }

    public String getCopyFromURL() {
        return this.myCopyFromURL;
    }

    public SVNRevision getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public SVNLock getRemoteLock() {
        return this.myRemoteLock;
    }

    public SVNLock getLocalLock() {
        return this.myLocalLock;
    }

    public Map getEntryProperties() {
        return this.myEntryProperties;
    }

    public SVNRevision getRemoteRevision() {
        return this.myRemoteRevision;
    }

    public SVNNodeKind getRemoteKind() {
        return this.myRemoteKind;
    }

    public Date getRemoteDate() {
        return this.myRemoteDate;
    }

    public String getRemoteAuthor() {
        return this.myRemoteAuthor;
    }

    public Date getWorkingContentsDate() {
        if (this.myLocalContentsDate == null) {
            this.myLocalContentsDate = this.getFile() != null && this.getKind() == SVNNodeKind.FILE ? new Date(SVNFileUtil.getFileLastModified(this.getFile())) : new Date(0L);
        }
        return this.myLocalContentsDate;
    }

    public Date getWorkingPropertiesDate() {
        if (this.myLocalPropertiesDate == null) {
            File file = null;
            if (this.getFile() != null && this.getKind() == SVNNodeKind.DIR) {
                file = new File(this.getFile().getAbsoluteFile(), SVNFileUtil.getAdminDirectoryName());
                file = new File(file, "dir-props");
            } else if (this.getFile() != null && this.getKind() == SVNNodeKind.FILE) {
                file = new File(this.getFile().getAbsoluteFile().getParentFile(), SVNFileUtil.getAdminDirectoryName());
                file = new File(file, "props/" + this.getFile().getName() + ".svn-work");
            }
            this.myLocalPropertiesDate = file != null ? new Date(SVNFileUtil.getFileLastModified(file)) : new Date(0L);
        }
        return this.myLocalPropertiesDate;
    }

    public void markExternal() {
        this.myContentsStatus = SVNStatusType.STATUS_EXTERNAL;
    }

    public void setRemoteStatus(SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2, SVNLock sVNLock, SVNNodeKind sVNNodeKind) {
        if (sVNStatusType == SVNStatusType.STATUS_ADDED && this.myRemoteContentsStatus == SVNStatusType.STATUS_DELETED) {
            sVNStatusType = SVNStatusType.STATUS_REPLACED;
        }
        this.myRemoteContentsStatus = sVNStatusType != null ? sVNStatusType : this.myRemoteContentsStatus;
        SVNStatusType sVNStatusType3 = this.myRemotePropertiesStatus = sVNStatusType2 != null ? sVNStatusType2 : this.myRemotePropertiesStatus;
        if (sVNLock != null) {
            this.myRemoteLock = sVNLock;
        }
        if (sVNNodeKind != null) {
            this.myRemoteKind = sVNNodeKind;
        }
    }

    public void setRemoteStatus(SVNURL sVNURL, SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2, SVNLock sVNLock, SVNNodeKind sVNNodeKind, SVNRevision sVNRevision, Date date, String string) {
        this.setRemoteStatus(sVNStatusType, sVNStatusType2, sVNLock, sVNNodeKind);
        this.myRemoteURL = sVNURL;
        this.myRemoteRevision = sVNRevision == null ? SVNRevision.UNDEFINED : sVNRevision;
        this.myRemoteDate = date;
        this.myRemoteAuthor = string;
        this.myRemoteKind = sVNNodeKind;
    }

    public void setContentsStatus(SVNStatusType sVNStatusType) {
        this.myContentsStatus = sVNStatusType;
    }

    public void setEntry(SVNEntry sVNEntry) {
        this.myEntry = sVNEntry;
    }

    public SVNEntry getEntry() {
        return this.myEntry;
    }

    public String getChangelistName() {
        return this.myChangelistName;
    }

    public SVNTreeConflictDescription getTreeConflict() {
        return this.myTreeConflict;
    }

    public int getWorkingCopyFormat() {
        return this.myWorkingCopyFormat;
    }

    public void setConflicted(boolean bl2) {
        this.myIsConflicted = bl2;
    }

    public boolean isConflicted() {
        return this.myIsConflicted;
    }

    public boolean isVersioned() {
        if (this.myIsVersioned) {
            return this.myIsVersioned;
        }
        return this.getEntry() != null || this.myEntryProperties != null;
    }

    public SVNStatusType getRemoteNodeStatus() {
        return this.myRemoteNodeStatus;
    }

    public SVNStatusType getCombinedNodeAndContentsStatus() {
        int n2 = this.getWorkingCopyFormat();
        SVNStatusType sVNStatusType = this.getNodeStatus();
        SVNStatusType sVNStatusType2 = this.getContentsStatus();
        boolean bl2 = this.isVersioned();
        boolean bl3 = this.isConflicted();
        return SVNStatus.combineNodeAndContentsStatus(n2, sVNStatusType, sVNStatusType2, bl2, bl3);
    }

    public SVNStatusType getCombinedRemoteNodeAndContentsStatus() {
        int n2 = this.getWorkingCopyFormat();
        SVNStatusType sVNStatusType = this.getRemoteNodeStatus();
        SVNStatusType sVNStatusType2 = this.getRemoteContentsStatus();
        return SVNStatus.combineRemoteNodeAndContentsStatus(n2, sVNStatusType, sVNStatusType2);
    }

    public SVNStatusType getNodeStatus() {
        if (this.myNodeStatus == null) {
            return this.myContentsStatus;
        }
        return this.myNodeStatus;
    }

    public SVNURL getRepositoryRootURL() {
        return this.myRepositoryRootURL;
    }

    public String getRepositoryUUID() {
        return this.myRepositoryUUID;
    }

    public String getRepositoryRelativePath() {
        return this.myRepositoryRelativePath;
    }

    public SVNDepth getDepth() {
        return this.myDepth;
    }

    public File getMovedToPath() {
        return this.myMovedToPath;
    }

    public File getMovedFromPath() {
        return this.myMovedFromPath;
    }

    public void setRemoteNodeStatus(SVNStatusType sVNStatusType) {
        this.myRemoteNodeStatus = sVNStatusType;
    }

    public void setNodeStatus(SVNStatusType sVNStatusType) {
        this.myNodeStatus = sVNStatusType;
    }

    public void setRepositoryRootURL(SVNURL sVNURL) {
        this.myRepositoryRootURL = sVNURL;
    }

    public void setRepositoryUUID(String string) {
        this.myRepositoryUUID = string;
    }

    public void setRepositoryRelativePath(String string) {
        this.myRepositoryRelativePath = string;
    }

    public void setURL(SVNURL sVNURL) {
        this.myURL = sVNURL;
    }

    public void setFile(File file) {
        this.myFile = file;
    }

    public void setKind(SVNNodeKind sVNNodeKind) {
        this.myKind = sVNNodeKind;
    }

    public void setRevision(SVNRevision sVNRevision) {
        this.myRevision = sVNRevision;
    }

    public void setCommittedRevision(SVNRevision sVNRevision) {
        this.myCommittedRevision = sVNRevision;
    }

    public void setCommittedDate(Date date) {
        this.myCommittedDate = date;
    }

    public void setAuthor(String string) {
        this.myAuthor = string;
    }

    public void setPropertiesStatus(SVNStatusType sVNStatusType) {
        this.myPropertiesStatus = sVNStatusType;
    }

    public void setRemoteContentsStatus(SVNStatusType sVNStatusType) {
        this.myRemoteContentsStatus = sVNStatusType;
    }

    public void setRemotePropertiesStatus(SVNStatusType sVNStatusType) {
        this.myRemotePropertiesStatus = sVNStatusType;
    }

    public void setIsLocked(boolean bl2) {
        this.myIsLocked = bl2;
    }

    public void setIsCopied(boolean bl2) {
        this.myIsCopied = bl2;
    }

    public void setIsSwitched(boolean bl2) {
        this.myIsSwitched = bl2;
    }

    public void setIsFileExternal(boolean bl2) {
        this.myIsFileExternal = bl2;
    }

    public void setConflictNewFile(File file) {
        this.myConflictNewFile = file;
    }

    public void setConflictOldFile(File file) {
        this.myConflictOldFile = file;
    }

    public void setConflictWrkFile(File file) {
        this.myConflictWrkFile = file;
    }

    public void setPropRejectFile(File file) {
        this.myPropRejectFile = file;
    }

    public void setCopyFromURL(String string) {
        this.myCopyFromURL = string;
    }

    public void setCopyFromRevision(SVNRevision sVNRevision) {
        this.myCopyFromRevision = sVNRevision;
    }

    public void setRemoteLock(SVNLock sVNLock) {
        this.myRemoteLock = sVNLock;
    }

    public void setLocalLock(SVNLock sVNLock) {
        this.myLocalLock = sVNLock;
    }

    public void setEntryProperties(Map map) {
        this.myEntryProperties = map;
    }

    public void setRemoteRevision(SVNRevision sVNRevision) {
        this.myRemoteRevision = sVNRevision;
    }

    public void setRemoteURL(SVNURL sVNURL) {
        this.myRemoteURL = sVNURL;
    }

    public void setRemoteKind(SVNNodeKind sVNNodeKind) {
        this.myRemoteKind = sVNNodeKind;
    }

    public void setRemoteAuthor(String string) {
        this.myRemoteAuthor = string;
    }

    public void setRemoteDate(Date date) {
        this.myRemoteDate = date;
    }

    public void setLocalContentsDate(Date date) {
        this.myLocalContentsDate = date;
    }

    public void setLocalPropertiesDate(Date date) {
        this.myLocalPropertiesDate = date;
    }

    public void setChangelistName(String string) {
        this.myChangelistName = string;
    }

    public void setWorkingCopyFormat(int n2) {
        this.myWorkingCopyFormat = n2;
    }

    public void setTreeConflict(SVNTreeConflictDescription sVNTreeConflictDescription) {
        this.myTreeConflict = sVNTreeConflictDescription;
    }

    public void setIsConflicted(boolean bl2) {
        this.myIsConflicted = bl2;
    }

    public void setIsVersioned(boolean bl2) {
        this.myIsVersioned = bl2;
    }

    public void setDepth(SVNDepth sVNDepth) {
        this.myDepth = sVNDepth;
    }

    public void setMovedFromPath(File file) {
        this.myMovedFromPath = file;
    }

    public void setMovedToPath(File file) {
        this.myMovedToPath = file;
    }

    public static SVNStatusType combineNodeAndContentsStatus(int n2, SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2, boolean bl2, boolean bl3) {
        if (n2 >= 29) {
            if (sVNStatusType == SVNStatusType.STATUS_CONFLICTED) {
                if (!bl2 && bl3) {
                    return SVNStatusType.STATUS_MISSING;
                }
                return sVNStatusType2;
            }
            if (sVNStatusType == SVNStatusType.STATUS_MODIFIED) {
                return sVNStatusType2;
            }
            return sVNStatusType;
        }
        return sVNStatusType2;
    }

    public static SVNStatusType combineRemoteNodeAndContentsStatus(int n2, SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2) {
        if (n2 >= 29) {
            if (sVNStatusType == SVNStatusType.STATUS_MODIFIED) {
                return sVNStatusType2;
            }
            return sVNStatusType;
        }
        return sVNStatusType2;
    }
}

