/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class SVNRevision {
    public static final SVNRevision HEAD = new SVNRevision("HEAD", 0);
    public static final SVNRevision WORKING = new SVNRevision("WORKING", 1);
    public static final SVNRevision PREVIOUS = new SVNRevision("PREV", 3);
    public static final SVNRevision BASE = new SVNRevision("BASE", 2);
    public static final SVNRevision COMMITTED = new SVNRevision("COMMITTED", 4);
    public static final SVNRevision UNDEFINED = new SVNRevision("UNDEFINED", 30);
    private static final Map ourValidRevisions = new SVNHashMap();
    private static Pattern ISO_8601_EXTENDED_DATE_ONLY_PATTERN;
    private static Pattern ISO_8601_EXTENDED_UTC_PATTERN;
    private static Pattern ISO_8601_EXTENDED_OFFSET_PATTERN;
    private static Pattern ISO_8601_BASIC_DATE_ONLY_PATTERN;
    private static Pattern ISO_8601_BASIC_UTC_PATTERN;
    private static Pattern ISO_8601_BASIC_OFFSET_PATTERN;
    private static Pattern ISO_8601_GNU_FORMAT_PATTERN;
    private static Pattern SVN_LOG_DATE_FORMAT_PATTERN;
    private static Pattern TIME_ONLY_PATTERN;
    private static final Collection ourTimeFormatPatterns;
    private long myRevision;
    private String myName;
    private Date myDate;
    private int myID;

    private SVNRevision(long l2) {
        this.myRevision = l2;
        this.myName = null;
        this.myID = 10;
    }

    private SVNRevision(String string, int n2) {
        this(-1L);
        this.myName = string;
        this.myID = n2;
    }

    private SVNRevision(Date date) {
        this(-1L);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        this.myDate = calendar.getTime();
        this.myID = 20;
    }

    public String getName() {
        return this.myName;
    }

    public long getNumber() {
        return this.myRevision;
    }

    public Date getDate() {
        return this.myDate;
    }

    public boolean isValid() {
        return this != UNDEFINED && (this.myDate != null || this.myRevision >= 0L || this.myName != null);
    }

    public int getID() {
        return this.myID;
    }

    public int hashCode() {
        if (this.myRevision >= 0L) {
            return (int)this.myRevision & 0xFFFFFFFF;
        }
        if (this.myDate != null) {
            return this.myDate.hashCode();
        }
        if (this.myName != null) {
            return this.myName.hashCode();
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != SVNRevision.class) {
            return false;
        }
        SVNRevision sVNRevision = (SVNRevision)object;
        if (this.myRevision >= 0L) {
            return this.myRevision == sVNRevision.getNumber();
        }
        if (this.myDate != null) {
            return this.myDate.equals(sVNRevision.getDate());
        }
        if (this.myName != null) {
            return this.myName.equals(sVNRevision.getName());
        }
        return !sVNRevision.isValid();
    }

    public static boolean isValidRevisionNumber(long l2) {
        return l2 >= 0L;
    }

    public static SVNRevision create(long l2) {
        if (l2 < 0L) {
            return UNDEFINED;
        }
        return new SVNRevision(l2);
    }

    public static SVNRevision create(Date date) {
        return new SVNRevision(date);
    }

    public boolean isLocal() {
        boolean bl2 = !this.isValid() || this == HEAD || this.getNumber() >= 0L || this.getDate() != null;
        return !bl2;
    }

    public static SVNRevision parse(String string) {
        if (string == null) {
            return UNDEFINED;
        }
        if (string.startsWith("-r")) {
            string = string.substring("-r".length());
        }
        if ((string = string.trim()).startsWith("{") && string.endsWith("}")) {
            string = string.substring(1);
            string = string.substring(0, string.length() - 1);
            try {
                Calendar calendar = Calendar.getInstance();
                for (Pattern pattern : ourTimeFormatPatterns) {
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    if (pattern == ISO_8601_EXTENDED_DATE_ONLY_PATTERN || pattern == ISO_8601_BASIC_DATE_ONLY_PATTERN) {
                        int n2 = Integer.parseInt(matcher.group(1));
                        int n3 = Integer.parseInt(matcher.group(2));
                        int n4 = Integer.parseInt(matcher.group(3));
                        calendar.clear();
                        calendar.set(n2, n3 - 1, n4);
                    } else if (pattern == ISO_8601_EXTENDED_UTC_PATTERN || pattern == ISO_8601_EXTENDED_OFFSET_PATTERN || pattern == ISO_8601_BASIC_UTC_PATTERN || pattern == ISO_8601_BASIC_OFFSET_PATTERN || pattern == ISO_8601_GNU_FORMAT_PATTERN || pattern == SVN_LOG_DATE_FORMAT_PATTERN) {
                        int n5 = Integer.parseInt(matcher.group(1));
                        int n6 = Integer.parseInt(matcher.group(2));
                        int n7 = Integer.parseInt(matcher.group(3));
                        int n8 = Integer.parseInt(matcher.group(4));
                        int n9 = Integer.parseInt(matcher.group(5));
                        int n10 = 0;
                        int n11 = 0;
                        if (matcher.group(6) != null) {
                            n10 = Integer.parseInt(matcher.group(7));
                            if (matcher.group(8) != null) {
                                String string2 = matcher.group(9);
                                string2 = string2.length() <= 3 ? string2 : string2.substring(0, 3);
                                n11 = Integer.parseInt(string2);
                            }
                        }
                        calendar.clear();
                        calendar.set(n5, n6 - 1, n7, n8, n9, n10);
                        calendar.set(14, n11);
                        if (pattern == ISO_8601_EXTENDED_OFFSET_PATTERN || pattern == ISO_8601_BASIC_OFFSET_PATTERN || pattern == ISO_8601_GNU_FORMAT_PATTERN) {
                            int n12 = "+".equals(matcher.group(10)) ? 1 : -1;
                            int n13 = Integer.parseInt(matcher.group(11));
                            int n14 = matcher.group(12) != null ? Integer.parseInt(matcher.group(13)) : 0;
                            calendar.set(15, n12 *= (n13 * 3600 + n14 * 60) * 1000);
                            calendar.set(16, 0);
                        } else if (pattern == SVN_LOG_DATE_FORMAT_PATTERN && matcher.group(10) != null) {
                            int n15 = "+".equals(matcher.group(11)) ? 1 : -1;
                            int n16 = Integer.parseInt(matcher.group(12));
                            int n17 = matcher.group(13) != null ? Integer.parseInt(matcher.group(13)) : 0;
                            calendar.set(15, n15 *= (n16 * 3600 + n17 * 60) * 1000);
                            calendar.set(16, 0);
                        } else if ((pattern == ISO_8601_EXTENDED_UTC_PATTERN || pattern == ISO_8601_BASIC_UTC_PATTERN) && "Z".equals(matcher.group(10))) {
                            calendar.set(15, 0);
                            calendar.set(16, 0);
                        }
                    } else if (pattern == TIME_ONLY_PATTERN) {
                        int n18 = Integer.parseInt(matcher.group(1));
                        int n19 = Integer.parseInt(matcher.group(2));
                        int n20 = 0;
                        int n21 = 0;
                        if (matcher.group(3) != null) {
                            n20 = Integer.parseInt(matcher.group(4));
                            if (matcher.group(5) != null) {
                                String string3 = matcher.group(6);
                                string3 = string3.length() <= 3 ? string3 : string3.substring(0, 3);
                                n21 = Integer.parseInt(string3);
                            }
                        }
                        calendar.set(11, n18);
                        calendar.set(12, n19);
                        calendar.set(13, n20);
                        calendar.set(14, n21);
                    }
                    return SVNRevision.create(calendar.getTime());
                }
                return UNDEFINED;
            }
            catch (NumberFormatException numberFormatException) {
                return UNDEFINED;
            }
        }
        try {
            long l2 = Long.parseLong(string);
            return SVNRevision.create(l2);
        }
        catch (NumberFormatException numberFormatException) {
            SVNRevision sVNRevision = (SVNRevision)ourValidRevisions.get(string.toUpperCase());
            if (sVNRevision == null) {
                return UNDEFINED;
            }
            return sVNRevision;
        }
    }

    public String toString() {
        if (this.myRevision >= 0L) {
            return Long.toString(this.myRevision);
        }
        if (this.myName != null) {
            return this.myName;
        }
        if (this.myDate != null) {
            return DateFormat.getDateTimeInstance().format(this.myDate);
        }
        return "{invalid revision}";
    }

    static {
        ourValidRevisions.put(HEAD.getName(), HEAD);
        ourValidRevisions.put(WORKING.getName(), WORKING);
        ourValidRevisions.put(PREVIOUS.getName(), PREVIOUS);
        ourValidRevisions.put(BASE.getName(), BASE);
        ourValidRevisions.put(COMMITTED.getName(), COMMITTED);
        ISO_8601_EXTENDED_DATE_ONLY_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})");
        ISO_8601_EXTENDED_UTC_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})T(\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?(Z)?");
        ISO_8601_EXTENDED_OFFSET_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})T(\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?([+-])(\\d{2})(:(\\d{2}))?");
        ISO_8601_BASIC_DATE_ONLY_PATTERN = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})");
        ISO_8601_BASIC_UTC_PATTERN = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})T(\\d{2})(\\d{2})((\\d{2})([.,](\\d{1,6}))?)?(Z)?");
        ISO_8601_BASIC_OFFSET_PATTERN = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})T(\\d{2})(\\d{2})((\\d{2})([.,](\\d{1,6}))?)?([+-])(\\d{2})((\\d{2}))?");
        ISO_8601_GNU_FORMAT_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})T(\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?([+-])(\\d{2})((\\d{2}))?");
        SVN_LOG_DATE_FORMAT_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2}) (\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?( ([+-])(\\d{2})(\\d{2})?)?");
        TIME_ONLY_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?");
        ourTimeFormatPatterns = new LinkedList();
        ourTimeFormatPatterns.add(ISO_8601_EXTENDED_DATE_ONLY_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_EXTENDED_UTC_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_EXTENDED_OFFSET_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_BASIC_DATE_ONLY_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_BASIC_UTC_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_BASIC_OFFSET_PATTERN);
        ourTimeFormatPatterns.add(SVN_LOG_DATE_FORMAT_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_GNU_FORMAT_PATTERN);
        ourTimeFormatPatterns.add(TIME_ONLY_PATTERN);
    }
}

