/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc16.SVNMoveClient16;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNMoveClient
extends SVNBasicClient {
    public SVNMoveClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNMoveClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNMoveClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public void doMove(File file, File file2) {
        block4: {
            SvnWcGeneration svnWcGeneration = SvnOperationFactory.detectWcGeneration(file, true, false);
            SvnWcGeneration svnWcGeneration2 = SvnOperationFactory.detectWcGeneration(file2, true, true);
            if (svnWcGeneration == SvnWcGeneration.V17 && svnWcGeneration2 == SvnWcGeneration.V17) {
                SvnCopy svnCopy = this.getOperationsFactory().createCopy();
                svnCopy.setMove(true);
                svnCopy.setSingleTarget(SvnTarget.fromFile(file2));
                svnCopy.addCopySource(SvnCopySource.create(SvnTarget.fromFile(file), SVNRevision.WORKING));
                svnCopy.setFailWhenDstExists(true);
                svnCopy.run();
            } else {
                try {
                    SVNMoveClient16 sVNMoveClient16 = new SVNMoveClient16(this.getOperationsFactory().getAuthenticationManager(), this.getOptions());
                    sVNMoveClient16.doMove(file, file2);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_UNSUPPORTED_FORMAT) break block4;
                    SvnCopy svnCopy = this.getOperationsFactory().createCopy();
                    svnCopy.setMove(true);
                    svnCopy.setSingleTarget(SvnTarget.fromFile(file2));
                    svnCopy.addCopySource(SvnCopySource.create(SvnTarget.fromFile(file), SVNRevision.WORKING));
                    svnCopy.setFailWhenDstExists(true);
                    svnCopy.run();
                }
            }
        }
    }

    public void undoMove(File file, File file2) {
        SVNMoveClient16 sVNMoveClient16 = new SVNMoveClient16(this.getOperationsFactory().getAuthenticationManager(), this.getOptions());
        sVNMoveClient16.undoMove(file, file2);
    }

    public void doVirtualCopy(File file, File file2, boolean bl2) {
        SvnCopy svnCopy = this.getOperationsFactory().createCopy();
        svnCopy.addCopySource(SvnCopySource.create(SvnTarget.fromFile(file), SVNRevision.WORKING));
        svnCopy.setSingleTarget(SvnTarget.fromFile(file2));
        svnCopy.setMove(bl2);
        svnCopy.setVirtual(true);
        svnCopy.run();
    }
}

