/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;

public class SVNMergeFileSet {
    private String myLocalFilePath;
    private String myBaseFilePath;
    private String myRepositoryFilePath;
    private String myWCFilePath;
    private String myMergeResultFilePath;
    private String myMimeType;
    private SVNAdminArea myAdminArea;
    private SVNLog myLog;
    private String myLocalLabel;
    private String myBaseLabel;
    private String myRepositoryLabel;
    private File myLocalFile;
    private File myBaseFile;
    private File myRepositoryFile;
    private File myMergeResultFile;
    private File myCopyFromFile;
    private Collection myTmpPaths = new ArrayList();

    public SVNMergeFileSet(SVNAdminArea sVNAdminArea, SVNLog sVNLog, File file, File file2, String string, File file3, File file4, File file5, String string2) {
        this.myAdminArea = sVNAdminArea;
        this.myLog = sVNLog;
        this.myLocalFile = file2;
        this.myBaseFile = file;
        this.myRepositoryFile = file3;
        this.myWCFilePath = string;
        this.myMergeResultFile = file4;
        this.myCopyFromFile = file5;
        this.myMimeType = string2;
        if (this.myBaseFile != null) {
            this.myBaseFilePath = this.myAdminArea != null ? (SVNPathUtil.isAncestor(this.myAdminArea.getAdminDirectory().getAbsolutePath(), this.myBaseFile.getAbsolutePath()) ? SVNFileUtil.getBasePath(this.myBaseFile) : null) : this.myBaseFile.getAbsolutePath();
        }
        if (this.myLocalFile != null) {
            this.myLocalFilePath = SVNFileUtil.getBasePath(this.myLocalFile);
        }
        if (this.myRepositoryFile != null) {
            this.myRepositoryFilePath = this.myAdminArea != null ? (SVNPathUtil.isAncestor(this.myAdminArea.getAdminDirectory().getAbsolutePath(), this.myRepositoryFile.getAbsolutePath()) ? SVNFileUtil.getBasePath(this.myRepositoryFile) : null) : this.myRepositoryFile.getAbsolutePath();
        }
        if (this.myMergeResultFile != null) {
            this.myMergeResultFilePath = SVNFileUtil.getBasePath(this.myMergeResultFile);
        }
    }

    public void setMergeLabels(String string, String string2, String string3) {
        this.myLocalLabel = string2 == null ? ".working" : string2;
        this.myBaseLabel = string == null ? ".old" : string;
        this.myRepositoryLabel = string3 == null ? ".new" : string3;
    }

    public SVNLog getLog() {
        return this.myLog;
    }

    public String getBaseLabel() {
        return this.myBaseLabel;
    }

    public String getLocalLabel() {
        return this.myLocalLabel;
    }

    public String getRepositoryLabel() {
        return this.myRepositoryLabel;
    }

    public String getBasePath() {
        if (this.myBaseFilePath == null && this.myBaseFile != null) {
            File file = SVNAdminUtil.createTmpFile(this.myAdminArea);
            SVNFileUtil.copyFile(this.myBaseFile, file, false);
            this.myBaseFilePath = SVNFileUtil.getBasePath(file);
            this.myTmpPaths.add(this.myBaseFilePath);
        }
        return this.myBaseFilePath;
    }

    public String getLocalPath() {
        return this.myLocalFilePath;
    }

    public String getWCPath() {
        return this.myWCFilePath;
    }

    public String getRepositoryPath() {
        if (this.myRepositoryFilePath == null && this.myRepositoryFile != null) {
            File file = SVNAdminUtil.createTmpFile(this.myAdminArea);
            SVNFileUtil.copyFile(this.myRepositoryFile, file, false);
            this.myRepositoryFilePath = SVNFileUtil.getBasePath(file);
            this.myTmpPaths.add(this.myRepositoryFilePath);
        }
        return this.myRepositoryFilePath;
    }

    public String getResultPath() {
        return this.myMergeResultFilePath;
    }

    public File getBaseFile() {
        return this.myBaseFile;
    }

    public File getWCFile() {
        if (this.myAdminArea != null) {
            return this.myAdminArea.getFile(this.myWCFilePath);
        }
        return this.myWCFilePath != null ? new File(this.myWCFilePath) : null;
    }

    public File getLocalFile() {
        return this.myLocalFile;
    }

    public File getRepositoryFile() {
        return this.myRepositoryFile;
    }

    public File getResultFile() {
        return this.myMergeResultFile;
    }

    public boolean isBinary() {
        return SVNProperty.isBinaryMimeType(this.myMimeType);
    }

    public String getMimeType() {
        return this.myMimeType;
    }

    public SVNAdminArea getAdminArea() {
        return this.myAdminArea;
    }

    public void dispose() {
        SVNProperties sVNProperties = new SVNProperties();
        for (String string : this.myTmpPaths) {
            sVNProperties.put("name", string);
            this.myLog.addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
        }
    }

    public File getCopyFromFile() {
        return this.myCopyFromFile;
    }

    public String getCopyFromPath() {
        String string = this.myAdminArea.getRoot().getAbsolutePath().replace(File.separatorChar, '/');
        String string2 = this.getCopyFromFile().getAbsolutePath().replace(File.separatorChar, '/');
        String string3 = string2.substring(string.length());
        string3 = string3.startsWith("/") ? string3.substring("/".length()) : string3;
        return string3;
    }
}

