/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Date;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class SVNInfo {
    private File myFile;
    private String myPath;
    private SVNURL myURL;
    private SVNRevision myRevision;
    private SVNNodeKind myKind;
    private SVNURL myRepositoryRootURL;
    private String myRepositoryUUID;
    private SVNRevision myCommittedRevision;
    private Date myCommittedDate;
    private String myAuthor;
    private SVNLock myLock;
    private boolean myIsRemote;
    private String mySchedule;
    private SVNURL myCopyFromURL;
    private SVNRevision myCopyFromRevision;
    private Date myTextTime;
    private Date myPropTime;
    private String myChecksum;
    private File myConflictOldFile;
    private File myConflictNewFile;
    private File myConflictWrkFile;
    private File myPropConflictFile;
    private SVNDepth myDepth;
    private String myChangelistName;
    private long myWorkingSize;
    private long myRepositorySize;
    private SVNTreeConflictDescription myTreeConflict;
    private File myWorkingCopyRoot;
    private File myMovedFromPath;
    private File myMovedToPath;

    public static SVNInfo createInfo(File file, SVNEntry sVNEntry) {
        if (sVNEntry == null) {
            return null;
        }
        SVNLock sVNLock = null;
        if (sVNEntry.getLockToken() != null) {
            sVNLock = new SVNLock(null, sVNEntry.getLockToken(), sVNEntry.getLockOwner(), sVNEntry.getLockComment(), SVNDate.parseDate(sVNEntry.getLockCreationDate()), null);
        }
        SVNTreeConflictDescription sVNTreeConflictDescription = null;
        if (sVNEntry.getAdminArea() != null && sVNEntry.getAdminArea().getWCAccess() != null) {
            sVNTreeConflictDescription = sVNEntry.getAdminArea().getWCAccess().getTreeConflict(file);
        }
        return new SVNInfo(file, sVNEntry.getSVNURL(), sVNEntry.getRepositoryRootURL(), sVNEntry.getRevision(), sVNEntry.getKind(), sVNEntry.getUUID(), sVNEntry.getCommittedRevision(), sVNEntry.getCommittedDate(), sVNEntry.getAuthor(), sVNEntry.getSchedule(), sVNEntry.getCopyFromSVNURL(), sVNEntry.getCopyFromRevision(), sVNEntry.getTextTime(), sVNEntry.getPropTime(), sVNEntry.getChecksum(), sVNEntry.getConflictOld(), sVNEntry.getConflictNew(), sVNEntry.getConflictWorking(), sVNEntry.getPropRejectFile(), sVNLock, sVNEntry.getDepth(), sVNEntry.getChangelistName(), sVNEntry.getWorkingSize(), sVNTreeConflictDescription);
    }

    public static SVNInfo createInfo(File file, SVNTreeConflictDescription sVNTreeConflictDescription) {
        return new SVNInfo(file, null, null, -1L, SVNNodeKind.NONE, null, -1L, null, null, null, null, -1L, null, null, null, null, null, null, null, null, SVNDepth.UNKNOWN, null, -1L, sVNTreeConflictDescription);
    }

    public static SVNInfo createInfo(String string, SVNURL sVNURL, String string2, SVNURL sVNURL2, SVNRevision sVNRevision, SVNDirEntry sVNDirEntry, SVNLock sVNLock) {
        if (sVNDirEntry == null) {
            return null;
        }
        return new SVNInfo(string, sVNURL2, sVNRevision, sVNDirEntry.getKind(), string2, sVNURL, sVNDirEntry.getRevision(), sVNDirEntry.getDate(), sVNDirEntry.getAuthor(), sVNLock, SVNDepth.UNKNOWN, sVNDirEntry.getSize());
    }

    public SVNInfo(File file, SVNURL sVNURL, SVNURL sVNURL2, long l2, SVNNodeKind sVNNodeKind, String string, long l3, String string2, String string3, String string4, SVNURL sVNURL3, long l4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, SVNLock sVNLock, SVNDepth sVNDepth, String string12, long l5, SVNTreeConflictDescription sVNTreeConflictDescription) {
        this.myFile = file;
        this.myURL = sVNURL;
        this.myRevision = SVNRevision.create(l2);
        this.myKind = sVNNodeKind;
        this.myRepositoryUUID = string;
        this.myRepositoryRootURL = sVNURL2;
        this.myCommittedRevision = SVNRevision.create(l3);
        this.myCommittedDate = string2 != null ? SVNDate.parseDate(string2) : null;
        this.myAuthor = string3;
        this.mySchedule = string4;
        this.myChecksum = string7;
        this.myTextTime = string5 != null ? SVNDate.parseDate(string5) : null;
        this.myPropTime = string6 != null ? SVNDate.parseDate(string6) : null;
        this.myCopyFromURL = sVNURL3;
        this.myCopyFromRevision = SVNRevision.create(l4);
        this.myLock = sVNLock;
        this.myChangelistName = string12;
        this.myTreeConflict = sVNTreeConflictDescription;
        if (file != null) {
            if (string8 != null) {
                this.myConflictOldFile = new File(file.getParentFile(), string8);
            }
            if (string9 != null) {
                this.myConflictNewFile = new File(file.getParentFile(), string9);
            }
            if (string10 != null) {
                this.myConflictWrkFile = new File(file.getParentFile(), string10);
            }
            if (string11 != null) {
                this.myPropConflictFile = new File(file.getParentFile(), string11);
            }
        }
        this.myIsRemote = false;
        this.myDepth = sVNDepth;
        this.myWorkingSize = l5;
        this.myRepositorySize = -1L;
    }

    public SVNInfo(String string, SVNURL sVNURL, SVNRevision sVNRevision, SVNNodeKind sVNNodeKind, String string2, SVNURL sVNURL2, long l2, Date date, String string3, SVNLock sVNLock, SVNDepth sVNDepth, long l3) {
        this.myIsRemote = true;
        this.myURL = sVNURL;
        this.myRevision = sVNRevision;
        this.myKind = sVNNodeKind;
        this.myRepositoryRootURL = sVNURL2;
        this.myRepositoryUUID = string2;
        this.myCommittedDate = date;
        this.myCommittedRevision = SVNRevision.create(l2);
        this.myAuthor = string3;
        this.myLock = sVNLock;
        this.myPath = string;
        this.myDepth = sVNDepth;
        this.myRepositorySize = l3;
        this.myWorkingSize = -1L;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getChecksum() {
        return this.myChecksum;
    }

    public Date getCommittedDate() {
        return this.myCommittedDate;
    }

    public SVNRevision getCommittedRevision() {
        return this.myCommittedRevision;
    }

    public File getConflictNewFile() {
        return this.myConflictNewFile;
    }

    public File getConflictOldFile() {
        return this.myConflictOldFile;
    }

    public File getConflictWrkFile() {
        return this.myConflictWrkFile;
    }

    public SVNTreeConflictDescription getTreeConflict() {
        return this.myTreeConflict;
    }

    public SVNRevision getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public SVNURL getCopyFromURL() {
        return this.myCopyFromURL;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isRemote() {
        return this.myIsRemote;
    }

    public SVNNodeKind getKind() {
        return this.myKind;
    }

    public SVNLock getLock() {
        return this.myLock;
    }

    public String getPath() {
        return this.myPath;
    }

    public File getPropConflictFile() {
        return this.myPropConflictFile;
    }

    public Date getPropTime() {
        return this.myPropTime;
    }

    public SVNURL getRepositoryRootURL() {
        return this.myRepositoryRootURL;
    }

    public String getRepositoryUUID() {
        return this.myRepositoryUUID;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public String getSchedule() {
        return this.mySchedule;
    }

    public Date getTextTime() {
        return this.myTextTime;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public SVNDepth getDepth() {
        return this.myDepth;
    }

    public String getChangelistName() {
        return this.myChangelistName;
    }

    public long getWorkingSize() {
        return this.myWorkingSize;
    }

    public long getRepositorySize() {
        return this.myRepositorySize;
    }

    public File getWorkingCopyRoot() {
        return this.myWorkingCopyRoot;
    }

    public File getMovedFromPath() {
        return this.myMovedFromPath;
    }

    public File getMovedToPath() {
        return this.myMovedToPath;
    }

    public void setWorkingCopyRoot(File file) {
        this.myWorkingCopyRoot = file;
    }

    public void setMovedFromPath(File file) {
        this.myMovedFromPath = file;
    }

    public void setMovedToPath(File file) {
        this.myMovedToPath = file;
    }
}

