/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNEvent {
    private File myFile;
    private SVNNodeKind myNodeKind;
    private String myMimeType;
    private long myRevision;
    private long myPreviousRevision;
    private SVNURL myURL;
    private SVNURL myPreviousURL;
    private SVNStatusType myContentsStatus;
    private SVNStatusType myPropertiesStatus;
    private SVNStatusType myLockStatus;
    private SVNLock myLock;
    private SVNErrorMessage myErrorMessage;
    private SVNEventAction myAction;
    private SVNEventAction myExpectedAction;
    private String myChangelistName;
    private SVNMergeRange myRange;
    private SVNProperties myRevisionProperties;
    private String myPropertyName;
    private Object info;

    public SVNEvent(SVNErrorMessage sVNErrorMessage, SVNEventAction sVNEventAction) {
        this.myErrorMessage = sVNErrorMessage;
        this.myAction = SVNEventAction.SKIP;
        this.myExpectedAction = sVNEventAction;
    }

    public SVNEvent(File file, SVNNodeKind sVNNodeKind, String string, long l2, SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2, SVNStatusType sVNStatusType3, SVNLock sVNLock, SVNEventAction sVNEventAction, SVNEventAction sVNEventAction2, SVNErrorMessage sVNErrorMessage, SVNMergeRange sVNMergeRange, String string2, SVNProperties sVNProperties, String string3) {
        this.myFile = file != null ? file.getAbsoluteFile() : null;
        this.myNodeKind = sVNNodeKind == null ? SVNNodeKind.UNKNOWN : sVNNodeKind;
        this.myMimeType = string;
        this.myRevision = l2;
        this.myContentsStatus = sVNStatusType == null ? SVNStatusType.INAPPLICABLE : sVNStatusType;
        this.myPropertiesStatus = sVNStatusType2 == null ? SVNStatusType.INAPPLICABLE : sVNStatusType2;
        this.myLockStatus = sVNStatusType3 == null ? SVNStatusType.LOCK_INAPPLICABLE : sVNStatusType3;
        this.myLock = sVNLock;
        this.myAction = sVNEventAction;
        this.myExpectedAction = sVNEventAction2 == null ? sVNEventAction : sVNEventAction2;
        this.myErrorMessage = sVNErrorMessage;
        this.myRange = sVNMergeRange;
        this.myChangelistName = string2;
        this.myPreviousRevision = -1L;
        this.myRevisionProperties = sVNProperties;
        this.myPropertyName = string3;
    }

    public File getFile() {
        return this.myFile;
    }

    public SVNEventAction getAction() {
        return this.myAction;
    }

    public SVNEventAction getExpectedAction() {
        return this.myExpectedAction;
    }

    public SVNStatusType getContentsStatus() {
        return this.myContentsStatus;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    public SVNLock getLock() {
        return this.myLock;
    }

    public SVNStatusType getLockStatus() {
        return this.myLockStatus;
    }

    public String getMimeType() {
        return this.myMimeType;
    }

    public SVNNodeKind getNodeKind() {
        return this.myNodeKind;
    }

    public SVNStatusType getPropertiesStatus() {
        return this.myPropertiesStatus;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public long getPreviousRevision() {
        return this.myPreviousRevision;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public SVNURL getPreviousURL() {
        return this.myPreviousURL;
    }

    public String getChangelistName() {
        return this.myChangelistName;
    }

    public SVNMergeRange getMergeRange() {
        return this.myRange;
    }

    public void setPreviousRevision(long l2) {
        this.myPreviousRevision = l2;
    }

    public void setURL(SVNURL sVNURL) {
        this.myURL = sVNURL;
    }

    public void setPreviousURL(SVNURL sVNURL) {
        this.myPreviousURL = sVNURL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getAction() != null) {
            stringBuffer.append(this.getAction().toString());
        }
        if (this.getFile() != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.getFile().toString());
        }
        if (this.getURL() != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.getURL().toString());
        }
        return stringBuffer.toString();
    }

    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object object) {
        this.info = object;
    }

    public void setFile(File file) {
        this.myFile = file;
    }

    public SVNProperties getRevisionProperties() {
        return this.myRevisionProperties;
    }

    public void setRevisionProperties(SVNProperties sVNProperties) {
        this.myRevisionProperties = sVNProperties;
    }

    public String getPropertyName() {
        return this.myPropertyName;
    }

    public void setPropertyName(String string) {
        this.myPropertyName = string;
    }
}

