/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient$1;
import org.tmatesoft.svn.core.wc.SVNDiffClient$2;
import org.tmatesoft.svn.core.wc.SVNDiffClient$3;
import org.tmatesoft.svn.core.wc.SVNDiffClient$4;
import org.tmatesoft.svn.core.wc.SVNDiffClient$5;
import org.tmatesoft.svn.core.wc.SVNDiffClient$6;
import org.tmatesoft.svn.core.wc.SVNDiffClient$7;
import org.tmatesoft.svn.core.wc.SVNDiffClient$8;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnDiff;
import org.tmatesoft.svn.core.wc2.SvnDiffSummarize;
import org.tmatesoft.svn.core.wc2.SvnGetMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnLogMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnMerge;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnPatch;
import org.tmatesoft.svn.core.wc2.SvnSuggestMergeSources;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNDiffClient
extends SVNBasicClient {
    private boolean gitDiffFormat;
    private boolean showCopiesAsAdds;
    private boolean myIsAllowMixedRevisions;
    private boolean recurseIntoDeletedDirectories;
    private ISVNDiffGenerator diffGenerator;
    private SVNDiffOptions diffOptions;

    public SVNDiffClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNDiffClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNDiffClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    @Override
    protected void initDefaults() {
        this.setDiffGenerator(null);
        this.setMergeOptions(null);
        this.setRecurseIntoDeletedDirectories(true);
    }

    public void setDiffGenerator(ISVNDiffGenerator iSVNDiffGenerator) {
        if (iSVNDiffGenerator == null) {
            iSVNDiffGenerator = new DefaultSVNDiffGenerator();
        }
        this.diffGenerator = iSVNDiffGenerator;
    }

    public ISVNDiffGenerator getDiffGenerator() {
        return this.diffGenerator;
    }

    public void setMergeOptions(SVNDiffOptions sVNDiffOptions) {
        if (sVNDiffOptions == null) {
            sVNDiffOptions = new SVNDiffOptions();
        }
        this.diffOptions = sVNDiffOptions;
    }

    public SVNDiffOptions getMergeOptions() {
        return this.diffOptions;
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, OutputStream outputStream) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSource(SvnTarget.fromURL(sVNURL, sVNRevision), sVNRevision2, sVNRevision3);
        svnDiff.setDepth(SVNDepth.getInfinityOrEmptyDepth(bl2));
        svnDiff.setIgnoreAncestry(!bl3);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSource(SvnTarget.fromURL(sVNURL, sVNRevision), sVNRevision2, sVNRevision3);
        svnDiff.setDepth(sVNDepth);
        svnDiff.setIgnoreAncestry(!bl2);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, OutputStream outputStream) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSource(SvnTarget.fromFile(file, sVNRevision), sVNRevision2, sVNRevision3);
        svnDiff.setDepth(SVNDepth.getInfinityOrEmptyDepth(bl2));
        svnDiff.setIgnoreAncestry(!bl3);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(File[] fileArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        for (File file : fileArray) {
            SvnDiff svnDiff = this.getOperationsFactory().createDiff();
            svnDiff.setDiffGenerator(this.getDiffGenerator());
            svnDiff.setSource(SvnTarget.fromFile(file, sVNRevision3), sVNRevision, sVNRevision2);
            svnDiff.setDepth(sVNDepth);
            svnDiff.setIgnoreAncestry(!bl2);
            svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
            svnDiff.setOutput(outputStream);
            svnDiff.setApplicalbeChangelists(collection);
            svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
            svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
            svnDiff.run();
        }
    }

    public void doDiff(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSource(SvnTarget.fromFile(file, sVNRevision), sVNRevision2, sVNRevision3);
        svnDiff.setDepth(sVNDepth);
        svnDiff.setIgnoreAncestry(!bl2);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setApplicalbeChangelists(collection);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, boolean bl3, OutputStream outputStream) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSources(SvnTarget.fromURL(sVNURL, sVNRevision), SvnTarget.fromURL(sVNURL2, sVNRevision2));
        svnDiff.setDepth(SVNDepth.getInfinityOrEmptyDepth(bl2));
        svnDiff.setIgnoreAncestry(!bl3);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSources(SvnTarget.fromURL(sVNURL, sVNRevision), SvnTarget.fromURL(sVNURL2, sVNRevision2));
        svnDiff.setDepth(sVNDepth);
        svnDiff.setIgnoreAncestry(!bl2);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, boolean bl3, OutputStream outputStream) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSources(SvnTarget.fromFile(file, sVNRevision), SvnTarget.fromURL(sVNURL, sVNRevision2));
        svnDiff.setDepth(SVNDepth.getInfinityOrEmptyDepth(bl2));
        svnDiff.setIgnoreAncestry(!bl3);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSources(SvnTarget.fromFile(file, sVNRevision), SvnTarget.fromURL(sVNURL, sVNRevision2));
        svnDiff.setDepth(sVNDepth);
        svnDiff.setIgnoreAncestry(!bl2);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setApplicalbeChangelists(collection);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, boolean bl3, OutputStream outputStream) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSources(SvnTarget.fromURL(sVNURL, sVNRevision), SvnTarget.fromFile(file, sVNRevision2));
        svnDiff.setDepth(SVNDepth.getInfinityOrEmptyDepth(bl2));
        svnDiff.setIgnoreAncestry(!bl3);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSources(SvnTarget.fromURL(sVNURL, sVNRevision), SvnTarget.fromFile(file, sVNRevision2));
        svnDiff.setDepth(sVNDepth);
        svnDiff.setIgnoreAncestry(!bl2);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setApplicalbeChangelists(collection);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, boolean bl3, OutputStream outputStream) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSources(SvnTarget.fromFile(file, sVNRevision), SvnTarget.fromFile(file2, sVNRevision2));
        svnDiff.setDepth(SVNDepth.getInfinityOrEmptyDepth(bl2));
        svnDiff.setIgnoreAncestry(!bl3);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiff(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        SvnDiff svnDiff = this.getOperationsFactory().createDiff();
        svnDiff.setDiffGenerator(this.getDiffGenerator());
        svnDiff.setSources(SvnTarget.fromFile(file, sVNRevision), SvnTarget.fromFile(file2, sVNRevision2));
        svnDiff.setDepth(sVNDepth);
        svnDiff.setIgnoreAncestry(!bl2);
        svnDiff.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiff.setOutput(outputStream);
        svnDiff.setApplicalbeChangelists(collection);
        svnDiff.setShowCopiesAsAdds(this.isShowCopiesAsAdds());
        svnDiff.setUseGitDiffFormat(this.isGitDiffFormat());
        svnDiff.run();
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(SvnTarget.fromFile(file, SVNRevision.UNDEFINED), sVNRevision, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(SvnTarget.fromFile(file, sVNRevision3), sVNRevision, sVNRevision2, sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(SvnTarget.fromFile(file, sVNRevision), SvnTarget.fromFile(file2, sVNRevision2), sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(SvnTarget.fromFile(file, sVNRevision), SvnTarget.fromURL(sVNURL, sVNRevision2), SVNDepth.getInfinityOrFilesDepth(bl2), bl3, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(SvnTarget.fromFile(file, sVNRevision), SvnTarget.fromURL(sVNURL, sVNRevision2), sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(sVNURL, sVNRevision, file, sVNRevision2, SVNDepth.getUnknownOrFilesDepth(bl2), bl3, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(SvnTarget.fromURL(sVNURL, sVNRevision), SvnTarget.fromFile(file, sVNRevision2), sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(SvnTarget.fromURL(sVNURL, sVNRevision), SvnTarget.fromURL(sVNURL2, sVNRevision2), SVNDepth.getInfinityOrFilesDepth(bl2), bl3, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(SvnTarget.fromURL(sVNURL, sVNRevision3), sVNRevision, sVNRevision2, sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(SvnTarget.fromURL(sVNURL, sVNRevision), SvnTarget.fromURL(sVNURL2, sVNRevision2), sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doMerge(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, File file3, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.doMerge(file, sVNRevision, file2, sVNRevision2, file3, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, File file3, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SvnMerge svnMerge = this.getOperationsFactory().createMerge();
        svnMerge.setMergeOptions(this.getMergeOptions());
        svnMerge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        svnMerge.setSources(SvnTarget.fromFile(file, sVNRevision), SvnTarget.fromFile(file2, sVNRevision2));
        svnMerge.addTarget(SvnTarget.fromFile(file3));
        svnMerge.setDepth(sVNDepth);
        svnMerge.setIgnoreAncestry(!bl2);
        svnMerge.setForce(bl3);
        svnMerge.setDryRun(bl4);
        svnMerge.setRecordOnly(bl5);
        svnMerge.run();
    }

    public void doMerge(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, File file2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.doMerge(file, sVNRevision, sVNURL, sVNRevision2, file2, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, File file2, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SvnMerge svnMerge = this.getOperationsFactory().createMerge();
        svnMerge.setMergeOptions(this.getMergeOptions());
        svnMerge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        svnMerge.setSources(SvnTarget.fromFile(file, sVNRevision), SvnTarget.fromURL(sVNURL, sVNRevision2));
        svnMerge.addTarget(SvnTarget.fromFile(file2));
        svnMerge.setDepth(sVNDepth);
        svnMerge.setIgnoreAncestry(!bl2);
        svnMerge.setForce(bl3);
        svnMerge.setDryRun(bl4);
        svnMerge.setRecordOnly(bl5);
        svnMerge.run();
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, File file2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.doMerge(sVNURL, sVNRevision, file, sVNRevision2, file2, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, File file2, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SvnMerge svnMerge = this.getOperationsFactory().createMerge();
        svnMerge.setMergeOptions(this.getMergeOptions());
        svnMerge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        svnMerge.setSources(SvnTarget.fromURL(sVNURL, sVNRevision), SvnTarget.fromFile(file, sVNRevision2));
        svnMerge.addTarget(SvnTarget.fromFile(file2));
        svnMerge.setDepth(sVNDepth);
        svnMerge.setIgnoreAncestry(!bl2);
        svnMerge.setForce(bl3);
        svnMerge.setDryRun(bl4);
        svnMerge.setRecordOnly(bl5);
        svnMerge.run();
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.doMerge(sVNURL, sVNRevision, sVNURL2, sVNRevision2, file, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SvnMerge svnMerge = this.getOperationsFactory().createMerge();
        svnMerge.setMergeOptions(this.getMergeOptions());
        svnMerge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        svnMerge.setSources(SvnTarget.fromURL(sVNURL, sVNRevision), SvnTarget.fromURL(sVNURL2, sVNRevision2));
        svnMerge.addTarget(SvnTarget.fromFile(file));
        svnMerge.setDepth(sVNDepth);
        svnMerge.setIgnoreAncestry(!bl2);
        svnMerge.setForce(bl3);
        svnMerge.setDryRun(bl4);
        svnMerge.setRecordOnly(bl5);
        svnMerge.run();
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        ArrayList<SVNRevisionRange> arrayList = new ArrayList<SVNRevisionRange>();
        arrayList.add(new SVNRevisionRange(sVNRevision2, sVNRevision3));
        this.doMerge(sVNURL, sVNRevision, arrayList, file, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, Collection collection, File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SvnMerge svnMerge = this.getOperationsFactory().createMerge();
        svnMerge.setMergeOptions(this.getMergeOptions());
        svnMerge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        svnMerge.setSource(SvnTarget.fromURL(sVNURL, sVNRevision), false);
        if (collection != null) {
            for (SVNRevisionRange sVNRevisionRange : collection) {
                svnMerge.addRevisionRange(SvnCodec.revisionRange(sVNRevisionRange));
            }
        }
        svnMerge.addTarget(SvnTarget.fromFile(file));
        svnMerge.setDepth(sVNDepth);
        svnMerge.setIgnoreAncestry(!bl2);
        svnMerge.setForce(bl3);
        svnMerge.setDryRun(bl4);
        svnMerge.setRecordOnly(bl5);
        svnMerge.run();
    }

    public void doMerge(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, File file2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        ArrayList<SVNRevisionRange> arrayList = new ArrayList<SVNRevisionRange>();
        arrayList.add(new SVNRevisionRange(sVNRevision2, sVNRevision3));
        this.doMerge(file, sVNRevision, arrayList, file2, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(File file, SVNRevision sVNRevision, Collection collection, File file2, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SvnMerge svnMerge = this.getOperationsFactory().createMerge();
        svnMerge.setMergeOptions(this.getMergeOptions());
        svnMerge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        svnMerge.setSource(SvnTarget.fromFile(file, sVNRevision), false);
        if (collection != null) {
            for (SVNRevisionRange sVNRevisionRange : collection) {
                svnMerge.addRevisionRange(SvnCodec.revisionRange(sVNRevisionRange));
            }
        }
        svnMerge.addTarget(SvnTarget.fromFile(file2));
        svnMerge.setDepth(sVNDepth);
        svnMerge.setIgnoreAncestry(!bl2);
        svnMerge.setForce(bl3);
        svnMerge.setDryRun(bl4);
        svnMerge.setRecordOnly(bl5);
        svnMerge.run();
    }

    public boolean isAllowMixedRevisionsWCForMerge() {
        return this.myIsAllowMixedRevisions;
    }

    public void doMergeReIntegrate(File file, SVNRevision sVNRevision, File file2, boolean bl2) {
        SvnMerge svnMerge = this.getOperationsFactory().createMerge();
        svnMerge.setMergeOptions(this.getMergeOptions());
        svnMerge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        svnMerge.addTarget(SvnTarget.fromFile(file2));
        svnMerge.setSource(SvnTarget.fromFile(file, sVNRevision), true);
        svnMerge.setDryRun(bl2);
        svnMerge.run();
    }

    public void doMergeReIntegrate(SVNURL sVNURL, SVNRevision sVNRevision, File file, boolean bl2) {
        SvnMerge svnMerge = this.getOperationsFactory().createMerge();
        svnMerge.setMergeOptions(this.getMergeOptions());
        svnMerge.setAllowMixedRevisions(this.isAllowMixedRevisionsWCForMerge());
        svnMerge.addTarget(SvnTarget.fromFile(file));
        svnMerge.setSource(SvnTarget.fromURL(sVNURL, sVNRevision), true);
        svnMerge.setDryRun(bl2);
        svnMerge.run();
    }

    public void doGetLogMergedMergeInfo(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        SvnLogMergeInfo svnLogMergeInfo = this.getOperationsFactory().createLogMergeInfo();
        svnLogMergeInfo.addTarget(SvnTarget.fromFile(file, sVNRevision));
        svnLogMergeInfo.setSource(SvnTarget.fromURL(sVNURL, sVNRevision2));
        svnLogMergeInfo.setDiscoverChangedPaths(bl2);
        svnLogMergeInfo.setRevisionProperties(stringArray);
        svnLogMergeInfo.setFindMerged(true);
        svnLogMergeInfo.setReceiver(new SVNDiffClient$1(this, iSVNLogEntryHandler));
        svnLogMergeInfo.run();
    }

    public void doGetLogMergedMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        SvnLogMergeInfo svnLogMergeInfo = this.getOperationsFactory().createLogMergeInfo();
        svnLogMergeInfo.addTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnLogMergeInfo.setSource(SvnTarget.fromURL(sVNURL2, sVNRevision2));
        svnLogMergeInfo.setDiscoverChangedPaths(bl2);
        svnLogMergeInfo.setRevisionProperties(stringArray);
        svnLogMergeInfo.setFindMerged(true);
        svnLogMergeInfo.setReceiver(new SVNDiffClient$2(this, iSVNLogEntryHandler));
        svnLogMergeInfo.run();
    }

    public void doGetLogMergedMergeInfo(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        SvnLogMergeInfo svnLogMergeInfo = this.getOperationsFactory().createLogMergeInfo();
        svnLogMergeInfo.addTarget(SvnTarget.fromFile(file, sVNRevision));
        svnLogMergeInfo.setSource(SvnTarget.fromFile(file2, sVNRevision2));
        svnLogMergeInfo.setDiscoverChangedPaths(bl2);
        svnLogMergeInfo.setRevisionProperties(stringArray);
        svnLogMergeInfo.setFindMerged(true);
        svnLogMergeInfo.setReceiver(new SVNDiffClient$3(this, iSVNLogEntryHandler));
        svnLogMergeInfo.run();
    }

    public void doGetLogMergedMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        SvnLogMergeInfo svnLogMergeInfo = this.getOperationsFactory().createLogMergeInfo();
        svnLogMergeInfo.addTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnLogMergeInfo.setSource(SvnTarget.fromFile(file, sVNRevision2));
        svnLogMergeInfo.setDiscoverChangedPaths(bl2);
        svnLogMergeInfo.setRevisionProperties(stringArray);
        svnLogMergeInfo.setFindMerged(true);
        svnLogMergeInfo.setReceiver(new SVNDiffClient$4(this, iSVNLogEntryHandler));
        svnLogMergeInfo.run();
    }

    public void doGetLogEligibleMergeInfo(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        SvnLogMergeInfo svnLogMergeInfo = this.getOperationsFactory().createLogMergeInfo();
        svnLogMergeInfo.addTarget(SvnTarget.fromFile(file, sVNRevision));
        svnLogMergeInfo.setSource(SvnTarget.fromURL(sVNURL, sVNRevision2));
        svnLogMergeInfo.setDiscoverChangedPaths(bl2);
        svnLogMergeInfo.setRevisionProperties(stringArray);
        svnLogMergeInfo.setFindMerged(false);
        svnLogMergeInfo.setReceiver(new SVNDiffClient$5(this, iSVNLogEntryHandler));
        svnLogMergeInfo.run();
    }

    public void doGetLogEligibleMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        SvnLogMergeInfo svnLogMergeInfo = this.getOperationsFactory().createLogMergeInfo();
        svnLogMergeInfo.addTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnLogMergeInfo.setSource(SvnTarget.fromURL(sVNURL2, sVNRevision2));
        svnLogMergeInfo.setDiscoverChangedPaths(bl2);
        svnLogMergeInfo.setRevisionProperties(stringArray);
        svnLogMergeInfo.setFindMerged(false);
        svnLogMergeInfo.setReceiver(new SVNDiffClient$6(this, iSVNLogEntryHandler));
        svnLogMergeInfo.run();
    }

    public void doGetLogEligibleMergeInfo(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        SvnLogMergeInfo svnLogMergeInfo = this.getOperationsFactory().createLogMergeInfo();
        svnLogMergeInfo.addTarget(SvnTarget.fromFile(file, sVNRevision));
        svnLogMergeInfo.setSource(SvnTarget.fromFile(file2, sVNRevision2));
        svnLogMergeInfo.setDiscoverChangedPaths(bl2);
        svnLogMergeInfo.setRevisionProperties(stringArray);
        svnLogMergeInfo.setFindMerged(false);
        svnLogMergeInfo.setReceiver(new SVNDiffClient$7(this, iSVNLogEntryHandler));
        svnLogMergeInfo.run();
    }

    public void doGetLogEligibleMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        SvnLogMergeInfo svnLogMergeInfo = this.getOperationsFactory().createLogMergeInfo();
        svnLogMergeInfo.addTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        svnLogMergeInfo.setSource(SvnTarget.fromFile(file, sVNRevision2));
        svnLogMergeInfo.setDiscoverChangedPaths(bl2);
        svnLogMergeInfo.setRevisionProperties(stringArray);
        svnLogMergeInfo.setFindMerged(false);
        svnLogMergeInfo.setReceiver(new SVNDiffClient$8(this, iSVNLogEntryHandler));
        svnLogMergeInfo.run();
    }

    public Map doGetMergedMergeInfo(File file, SVNRevision sVNRevision) {
        SvnGetMergeInfo svnGetMergeInfo = this.getOperationsFactory().createGetMergeInfo();
        svnGetMergeInfo.setSingleTarget(SvnTarget.fromFile(file, sVNRevision));
        return (Map)svnGetMergeInfo.run();
    }

    public Map doGetMergedMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision) {
        SvnGetMergeInfo svnGetMergeInfo = this.getOperationsFactory().createGetMergeInfo();
        svnGetMergeInfo.setSingleTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        return (Map)svnGetMergeInfo.run();
    }

    public Collection doSuggestMergeSources(File file, SVNRevision sVNRevision) {
        SvnSuggestMergeSources svnSuggestMergeSources = this.getOperationsFactory().createSuggestMergeSources();
        svnSuggestMergeSources.setSingleTarget(SvnTarget.fromFile(file, sVNRevision));
        return (Collection)svnSuggestMergeSources.run();
    }

    public Collection doSuggestMergeSources(SVNURL sVNURL, SVNRevision sVNRevision) {
        SvnSuggestMergeSources svnSuggestMergeSources = this.getOperationsFactory().createSuggestMergeSources();
        svnSuggestMergeSources.setSingleTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        return (Collection)svnSuggestMergeSources.run();
    }

    public void doPatch(File file, File file2, boolean bl2, int n2) {
        SvnPatch svnPatch = this.getOperationsFactory().createPatch();
        svnPatch.setPatchFile(file);
        svnPatch.setStripCount(n2);
        svnPatch.setDryRun(bl2);
        svnPatch.setSingleTarget(SvnTarget.fromFile(file2));
        svnPatch.run();
    }

    public void doPatch(File file, File file2, boolean bl2, int n2, boolean bl3, boolean bl4, boolean bl5) {
        SvnPatch svnPatch = this.getOperationsFactory().createPatch();
        svnPatch.setPatchFile(file);
        svnPatch.setStripCount(n2);
        svnPatch.setDryRun(bl2);
        svnPatch.setSingleTarget(SvnTarget.fromFile(file2));
        svnPatch.setIgnoreWhitespace(bl3);
        svnPatch.setRemoveTempFiles(bl4);
        svnPatch.setReverse(bl5);
        svnPatch.run();
    }

    private void doDiffStatus(SvnTarget svnTarget, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        SvnDiffSummarize svnDiffSummarize = this.getOperationsFactory().createDiffSummarize();
        svnDiffSummarize.setSource(svnTarget, sVNRevision, sVNRevision2);
        svnDiffSummarize.setDepth(sVNDepth);
        svnDiffSummarize.setIgnoreAncestry(!bl2);
        svnDiffSummarize.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiffSummarize.setReceiver(SvnCodec.diffStatusReceiver(iSVNDiffStatusHandler));
        svnDiffSummarize.run();
    }

    private void doDiffStatus(SvnTarget svnTarget, SvnTarget svnTarget2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        SvnDiffSummarize svnDiffSummarize = this.getOperationsFactory().createDiffSummarize();
        svnDiffSummarize.setSources(svnTarget, svnTarget2);
        svnDiffSummarize.setDepth(sVNDepth);
        svnDiffSummarize.setIgnoreAncestry(!bl2);
        svnDiffSummarize.setRecurseIntoDeletedDirectories(this.isRecurseIntoDeletedDirectories());
        svnDiffSummarize.setReceiver(SvnCodec.diffStatusReceiver(iSVNDiffStatusHandler));
        svnDiffSummarize.run();
    }

    public void setAllowMixedRevisionsWCForMerge(boolean bl2) {
        this.myIsAllowMixedRevisions = bl2;
    }

    public boolean isRecurseIntoDeletedDirectories() {
        return this.recurseIntoDeletedDirectories;
    }

    public void setRecurseIntoDeletedDirectories(boolean bl2) {
        this.recurseIntoDeletedDirectories = bl2;
    }

    public boolean isShowCopiesAsAdds() {
        return this.showCopiesAsAdds;
    }

    public void setShowCopiesAsAdds(boolean bl2) {
        this.showCopiesAsAdds = bl2;
    }

    public boolean isGitDiffFormat() {
        return this.gitDiffFormat;
    }

    public void setGitDiffFormat(boolean bl2) {
        this.gitDiffFormat = bl2;
    }
}

