/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNCopySource {
    private SVNRevision myPegRevision;
    private SVNRevision myRevision;
    private SVNURL myURL;
    private File myPath;
    private boolean myIsCopyContents;

    public SVNCopySource(SVNRevision sVNRevision, SVNRevision sVNRevision2, File file) {
        this.myPegRevision = sVNRevision;
        this.myRevision = sVNRevision2;
        this.myPath = file.getAbsoluteFile();
    }

    public SVNCopySource(SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNURL sVNURL) {
        this.myPegRevision = sVNRevision;
        this.myRevision = sVNRevision2;
        this.myURL = sVNURL;
    }

    public File getFile() {
        return this.myPath;
    }

    public SVNRevision getPegRevision() {
        return this.myPegRevision;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public boolean isURL() {
        return this.myURL != null;
    }

    public String getName() {
        if (this.isURL()) {
            return SVNPathUtil.tail(this.myURL.getPath());
        }
        return this.myPath.getName();
    }

    public void setCopyContents(boolean bl2) {
        this.myIsCopyContents = bl2;
    }

    public boolean isCopyContents() {
        return this.myIsCopyContents;
    }
}

