/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRemoteCopy;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNCopyClient
extends SVNBasicClient {
    private ISVNCommitHandler commitHandler;
    private ISVNCommitParameters commitParamaters;
    private ISVNExternalsHandler externalsHandler;
    private boolean disableLocalModifications;

    public SVNCopyClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNCopyClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNCopyClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    @Override
    protected void initDefaults() {
        this.setCommitParameters(null);
        this.setCommitHandler(null);
        this.setExternalsHandler(null);
    }

    public void setCommitHandler(ISVNCommitHandler iSVNCommitHandler) {
        if (iSVNCommitHandler == null) {
            iSVNCommitHandler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = iSVNCommitHandler;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.commitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters iSVNCommitParameters) {
        if (iSVNCommitParameters == null) {
            iSVNCommitParameters = new DefaultSVNCommitParameters();
        }
        this.commitParamaters = iSVNCommitParameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        return this.commitParamaters;
    }

    public void setExternalsHandler(ISVNExternalsHandler iSVNExternalsHandler) {
        if (iSVNExternalsHandler == null) {
            iSVNExternalsHandler = ISVNExternalsHandler.DEFAULT;
        }
        this.externalsHandler = iSVNExternalsHandler;
    }

    public void setDisableLocalModificationCopying(boolean bl2) {
        this.disableLocalModifications = bl2;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        return this.externalsHandler;
    }

    public void doCopy(SVNCopySource[] sVNCopySourceArray, File file, boolean bl2, boolean bl3, boolean bl4) {
        SvnCopy svnCopy = this.getOperationsFactory().createCopy();
        svnCopy.setSingleTarget(SvnTarget.fromFile(file));
        svnCopy.setMove(bl2);
        svnCopy.setFailWhenDstExists(bl4);
        svnCopy.setMakeParents(bl3);
        for (int i2 = 0; i2 < sVNCopySourceArray.length; ++i2) {
            svnCopy.addCopySource(SvnCodec.copySource(sVNCopySourceArray[i2]));
        }
        svnCopy.run();
    }

    public void doCopy(SVNCopySource[] sVNCopySourceArray, File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map map) {
        SvnCopy svnCopy = this.getOperationsFactory().createCopy();
        svnCopy.setSingleTarget(SvnTarget.fromFile(file));
        svnCopy.setMove(bl2);
        svnCopy.setFailWhenDstExists(bl4);
        svnCopy.setMakeParents(bl3);
        svnCopy.setPinExternals(bl5);
        svnCopy.setExternalsToPin(map);
        for (int i2 = 0; i2 < sVNCopySourceArray.length; ++i2) {
            svnCopy.addCopySource(SvnCodec.copySource(sVNCopySourceArray[i2]));
        }
        svnCopy.run();
    }

    public void doCopy(SVNCopySource[] sVNCopySourceArray, File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        SvnCopy svnCopy = this.getOperationsFactory().createCopy();
        svnCopy.setSingleTarget(SvnTarget.fromFile(file));
        svnCopy.setMove(bl2);
        svnCopy.setFailWhenDstExists(bl4);
        svnCopy.setMakeParents(bl3);
        svnCopy.setIgnoreExternals(this.isIgnoreExternals());
        svnCopy.setAllowMixedRevisions(bl5);
        svnCopy.setMetadataOnly(bl6);
        for (int i2 = 0; i2 < sVNCopySourceArray.length; ++i2) {
            svnCopy.addCopySource(SvnCodec.copySource(sVNCopySourceArray[i2]));
        }
        svnCopy.run();
    }

    public SVNCommitInfo doCopy(SVNCopySource[] sVNCopySourceArray, SVNURL sVNURL, boolean bl2, boolean bl3, boolean bl4, String string, SVNProperties sVNProperties) {
        SvnRemoteCopy svnRemoteCopy = this.getOperationsFactory().createRemoteCopy();
        svnRemoteCopy.setSingleTarget(SvnTarget.fromURL(sVNURL));
        svnRemoteCopy.setMove(bl2);
        svnRemoteCopy.setFailWhenDstExists(bl4);
        svnRemoteCopy.setMakeParents(bl3);
        svnRemoteCopy.setCommitMessage(string);
        svnRemoteCopy.setRevisionProperties(sVNProperties);
        svnRemoteCopy.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        svnRemoteCopy.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        svnRemoteCopy.setDisableLocalModifications(this.disableLocalModifications);
        svnRemoteCopy.setCommitParameters(SvnCodec.commitParameters(this.getCommitParameters()));
        for (int i2 = 0; i2 < sVNCopySourceArray.length; ++i2) {
            svnRemoteCopy.addCopySource(SvnCodec.copySource(sVNCopySourceArray[i2]));
        }
        return svnRemoteCopy.run();
    }

    public SVNCommitInfo doCopy(SVNCopySource[] sVNCopySourceArray, SVNURL sVNURL, boolean bl2, boolean bl3, boolean bl4, String string, SVNProperties sVNProperties, boolean bl5, Map map) {
        SvnRemoteCopy svnRemoteCopy = this.getOperationsFactory().createRemoteCopy();
        svnRemoteCopy.setSingleTarget(SvnTarget.fromURL(sVNURL));
        svnRemoteCopy.setMove(bl2);
        svnRemoteCopy.setFailWhenDstExists(bl4);
        svnRemoteCopy.setMakeParents(bl3);
        svnRemoteCopy.setCommitMessage(string);
        svnRemoteCopy.setRevisionProperties(sVNProperties);
        svnRemoteCopy.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        svnRemoteCopy.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        svnRemoteCopy.setDisableLocalModifications(this.disableLocalModifications);
        svnRemoteCopy.setCommitParameters(SvnCodec.commitParameters(this.getCommitParameters()));
        svnRemoteCopy.setPinExternals(bl5);
        svnRemoteCopy.setExternalsToPin(map);
        for (int i2 = 0; i2 < sVNCopySourceArray.length; ++i2) {
            svnRemoteCopy.addCopySource(SvnCodec.copySource(sVNCopySourceArray[i2]));
        }
        return svnRemoteCopy.run();
    }

    public void doCopy(File file) {
        SvnCopy svnCopy = this.getOperationsFactory().createCopy();
        svnCopy.setDisjoint(true);
        svnCopy.setSingleTarget(SvnTarget.fromFile(file));
        svnCopy.run();
    }
}

