/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;

public class SVNCommitPacket {
    public static final SVNCommitPacket EMPTY = SvnCodec.commitPacket(null, new SvnCommitPacket());
    private SVNCommitItem[] myCommitItems;
    private Map myLockTokens;
    private boolean[] myIsSkipped;
    private boolean myIsDisposed;

    public SVNCommitPacket(SVNWCAccess sVNWCAccess, SVNCommitItem[] sVNCommitItemArray, Map map) {
        this.myCommitItems = sVNCommitItemArray;
        this.myLockTokens = map;
        this.myIsSkipped = new boolean[sVNCommitItemArray == null ? 0 : sVNCommitItemArray.length];
        this.myIsDisposed = false;
        if (sVNWCAccess != null) {
            for (int i2 = 0; i2 < sVNCommitItemArray.length; ++i2) {
                if (sVNCommitItemArray[i2].getWCAccess() != null) continue;
                sVNCommitItemArray[i2].setWCAccess(sVNWCAccess);
            }
        }
    }

    public SVNCommitItem[] getCommitItems() {
        return this.myCommitItems;
    }

    public void setCommitItemSkipped(SVNCommitItem sVNCommitItem, boolean bl2) {
        int n2 = this.getItemIndex(sVNCommitItem);
        if (n2 >= 0 && n2 < this.myIsSkipped.length) {
            this.myIsSkipped[n2] = bl2;
        }
    }

    public boolean isCommitItemSkipped(SVNCommitItem sVNCommitItem) {
        int n2 = this.getItemIndex(sVNCommitItem);
        if (n2 >= 0 && n2 < this.myIsSkipped.length) {
            return this.myIsSkipped[n2];
        }
        return true;
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void dispose() {
        try {
            for (int i2 = 0; i2 < this.myCommitItems.length; ++i2) {
                if (this.myCommitItems[i2] == null || this.myCommitItems[i2].getWCAccess() == null) continue;
                this.myCommitItems[i2].getWCAccess().close();
            }
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    private int getItemIndex(SVNCommitItem sVNCommitItem) {
        for (int i2 = 0; this.myCommitItems != null && i2 < this.myCommitItems.length; ++i2) {
            SVNCommitItem sVNCommitItem2 = this.myCommitItems[i2];
            if (sVNCommitItem2 != sVNCommitItem) continue;
            return i2;
        }
        return -1;
    }

    public Map getLockTokens() {
        return this.myLockTokens;
    }

    public SVNCommitPacket removeSkippedItems() {
        if (this == EMPTY) {
            return EMPTY;
        }
        ArrayList arrayList = new ArrayList();
        SVNHashMap sVNHashMap = this.getLockTokens() == null ? null : new SVNHashMap(this.getLockTokens());
        SVNCommitItem[] sVNCommitItemArray = this.filterSkippedItemsAndLockTokens(arrayList, sVNHashMap);
        return new SVNCommitPacket(null, sVNCommitItemArray, sVNHashMap);
    }

    public String toString() {
        if (EMPTY == this) {
            return "[EMPTY]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SVNCommitPacket: ");
        for (int i2 = 0; i2 < this.myCommitItems.length; ++i2) {
            SVNCommitItem sVNCommitItem = this.myCommitItems[i2];
            stringBuffer.append("\n");
            if (sVNCommitItem.isAdded()) {
                stringBuffer.append("A");
            } else if (sVNCommitItem.isDeleted()) {
                stringBuffer.append("D");
            } else if (sVNCommitItem.isContentsModified()) {
                stringBuffer.append("M");
            } else {
                stringBuffer.append("_");
            }
            if (sVNCommitItem.isPropertiesModified()) {
                stringBuffer.append("M");
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(" ");
            if (sVNCommitItem.getPath() != null) {
                stringBuffer.append(sVNCommitItem.getPath());
                stringBuffer.append(" ");
            }
            stringBuffer.append(sVNCommitItem.getFile().getAbsolutePath());
            stringBuffer.append("\n");
            stringBuffer.append(sVNCommitItem.getRevision());
            stringBuffer.append(" ");
            stringBuffer.append(sVNCommitItem.getURL());
            if (sVNCommitItem.isCopied()) {
                stringBuffer.append("\n");
                stringBuffer.append("+");
                stringBuffer.append(sVNCommitItem.getCopyFromURL());
            }
            if (!sVNCommitItem.isLocked()) continue;
            stringBuffer.append("\n");
            stringBuffer.append("LOCKED");
        }
        return stringBuffer.toString();
    }

    protected SVNCommitItem[] filterSkippedItemsAndLockTokens(Collection collection, Map map) {
        for (int i2 = 0; this.myCommitItems != null && i2 < this.myCommitItems.length; ++i2) {
            SVNCommitItem sVNCommitItem = this.myCommitItems[i2];
            if (!this.myIsSkipped[i2]) {
                collection.add(sVNCommitItem);
                continue;
            }
            if (map == null) continue;
            map.remove(sVNCommitItem.getURL().toString());
        }
        return collection.toArray(new SVNCommitItem[collection.size()]);
    }
}

