/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec$SVNCommitPacketWrapper;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient$1;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnImport;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRemoteDelete;
import org.tmatesoft.svn.core.wc2.SvnRemoteMkDir;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitClient
extends SVNBasicClient {
    private ISVNCommitHandler commitHandler;
    private ISVNCommitParameters commitParameters;
    private boolean failOnMultipleRepositories;

    public SVNCommitClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
        this.setCommitHander(null);
        this.setCommitParameters(null);
        this.setCommitHandler(null);
    }

    public SVNCommitClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNCommitClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    @Override
    protected void initDefaults() {
        this.setCommitHander(null);
        this.setCommitParameters(null);
        this.setCommitHandler(null);
    }

    public void setCommitHander(ISVNCommitHandler iSVNCommitHandler) {
        if (iSVNCommitHandler == null) {
            iSVNCommitHandler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = iSVNCommitHandler;
    }

    public void setCommitHandler(ISVNCommitHandler iSVNCommitHandler) {
        if (iSVNCommitHandler == null) {
            iSVNCommitHandler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = iSVNCommitHandler;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.commitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters iSVNCommitParameters) {
        this.commitParameters = iSVNCommitParameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        return this.commitParameters;
    }

    public SVNCommitInfo doDelete(SVNURL[] sVNURLArray, String string) {
        SvnRemoteDelete svnRemoteDelete = this.getOperationsFactory().createRemoteDelete();
        if (this.getCommitHandler() != null) {
            svnRemoteDelete.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        for (int i2 = 0; i2 < sVNURLArray.length; ++i2) {
            svnRemoteDelete.addTarget(SvnTarget.fromURL(sVNURLArray[i2]));
        }
        svnRemoteDelete.setCommitMessage(string);
        return (SVNCommitInfo)svnRemoteDelete.run();
    }

    public SVNCommitInfo doDelete(SVNURL[] sVNURLArray, String string, SVNProperties sVNProperties) {
        SvnRemoteDelete svnRemoteDelete = this.getOperationsFactory().createRemoteDelete();
        if (this.getCommitHandler() != null) {
            svnRemoteDelete.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        for (int i2 = 0; i2 < sVNURLArray.length; ++i2) {
            svnRemoteDelete.addTarget(SvnTarget.fromURL(sVNURLArray[i2]));
        }
        svnRemoteDelete.setCommitMessage(string);
        svnRemoteDelete.setRevisionProperties(sVNProperties);
        return (SVNCommitInfo)svnRemoteDelete.run();
    }

    public SVNCommitInfo doMkDir(SVNURL[] sVNURLArray, String string) {
        SvnRemoteMkDir svnRemoteMkDir = this.getOperationsFactory().createRemoteMkDir();
        if (this.getCommitHandler() != null) {
            svnRemoteMkDir.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        for (int i2 = 0; i2 < sVNURLArray.length; ++i2) {
            svnRemoteMkDir.addTarget(SvnTarget.fromURL(sVNURLArray[i2]));
        }
        svnRemoteMkDir.setCommitMessage(string);
        return (SVNCommitInfo)svnRemoteMkDir.run();
    }

    public SVNCommitInfo doMkDir(SVNURL[] sVNURLArray, String string, SVNProperties sVNProperties, boolean bl2) {
        SvnRemoteMkDir svnRemoteMkDir = this.getOperationsFactory().createRemoteMkDir();
        if (this.getCommitHandler() != null) {
            svnRemoteMkDir.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        for (int i2 = 0; i2 < sVNURLArray.length; ++i2) {
            svnRemoteMkDir.addTarget(SvnTarget.fromURL(sVNURLArray[i2]));
        }
        svnRemoteMkDir.setCommitMessage(string);
        svnRemoteMkDir.setRevisionProperties(sVNProperties);
        svnRemoteMkDir.setMakeParents(bl2);
        return (SVNCommitInfo)svnRemoteMkDir.run();
    }

    public SVNCommitInfo doImport(File file, SVNURL sVNURL, String string, boolean bl2) {
        return this.doImport(file, sVNURL, string, null, true, true, SVNDepth.fromRecurse(bl2));
    }

    public SVNCommitInfo doImport(File file, SVNURL sVNURL, String string, boolean bl2, boolean bl3) {
        return this.doImport(file, sVNURL, string, null, bl2, true, SVNDepth.fromRecurse(bl3));
    }

    public SVNCommitInfo doImport(File file, SVNURL sVNURL, String string, SVNProperties sVNProperties, boolean bl2, boolean bl3, SVNDepth sVNDepth) {
        return this.doImport(file, sVNURL, string, sVNProperties, bl2, bl3, sVNDepth, true);
    }

    public SVNCommitInfo doImport(File file, SVNURL sVNURL, String string, SVNProperties sVNProperties, boolean bl2, boolean bl3, SVNDepth sVNDepth, boolean bl4) {
        SvnImport svnImport = this.getOperationsFactory().createImport();
        svnImport.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        svnImport.setCommitMessage(string);
        svnImport.setRevisionProperties(sVNProperties);
        svnImport.addTarget(SvnTarget.fromURL(sVNURL));
        svnImport.setSource(file);
        svnImport.setDepth(sVNDepth);
        svnImport.setUseGlobalIgnores(bl2);
        svnImport.setApplyAutoProperties(bl4);
        return (SVNCommitInfo)svnImport.run();
    }

    public SVNCommitInfo doCommit(File[] fileArray, boolean bl2, String string, boolean bl3, boolean bl4) {
        return this.doCommit(fileArray, bl2, string, null, null, false, bl3, SVNDepth.fromRecurse(bl4));
    }

    public SVNCommitInfo doCommit(File[] fileArray, boolean bl2, String string, SVNProperties sVNProperties, String[] stringArray, boolean bl3, boolean bl4, SVNDepth sVNDepth) {
        SVNCommitInfo[] sVNCommitInfoArray;
        SVNCommitPacket[] sVNCommitPacketArray = this.doCollectCommitItems(fileArray, bl2, bl4, sVNDepth, true, stringArray);
        if (sVNCommitPacketArray != null && (sVNCommitInfoArray = this.doCommit(sVNCommitPacketArray, bl2, bl3, string, sVNProperties)) != null && sVNCommitInfoArray.length > 0) {
            return sVNCommitInfoArray[0];
        }
        return SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doCommit(SVNCommitPacket sVNCommitPacket, boolean bl2, String string) {
        return this.doCommit(sVNCommitPacket, bl2, false, string, null);
    }

    public SVNCommitInfo doCommit(SVNCommitPacket sVNCommitPacket, boolean bl2, boolean bl3, String string, SVNProperties sVNProperties) {
        SVNCommitInfo[] sVNCommitInfoArray = this.doCommit(new SVNCommitPacket[]{sVNCommitPacket}, bl2, bl3, string, sVNProperties);
        if (sVNCommitInfoArray != null && sVNCommitInfoArray.length > 0) {
            return sVNCommitInfoArray[0];
        }
        return SVNCommitInfo.NULL;
    }

    public SVNCommitInfo[] doCommit(SVNCommitPacket[] sVNCommitPacketArray, boolean bl2, String string) {
        return this.doCommit(sVNCommitPacketArray, bl2, false, string, null);
    }

    public SVNCommitInfo[] doCommit(SVNCommitPacket[] sVNCommitPacketArray, boolean bl2, boolean bl3, String string, SVNProperties sVNProperties) {
        int n2;
        Object object;
        SVNCommitInfo[] sVNCommitInfoArray = new SVNCommitInfo[sVNCommitPacketArray.length];
        if (sVNCommitPacketArray.length == 0) {
            return sVNCommitInfoArray;
        }
        SvnCommit svnCommit = null;
        for (int i2 = 0; i2 < sVNCommitPacketArray.length; ++i2) {
            object = ((SvnCodec$SVNCommitPacketWrapper)sVNCommitPacketArray[i2]).getOperation();
            if (svnCommit == null) {
                svnCommit = object;
            }
            if (object == svnCommit) continue;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Commit packets created by different commit operations may not be mixed.");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (svnCommit == null) {
            return new SVNCommitInfo[0];
        }
        SvnCommitPacket[] svnCommitPacketArray = svnCommit.splitCommitPackets(svnCommit.isCombinePackets());
        object = new HashSet();
        for (n2 = 0; n2 < sVNCommitPacketArray.length; ++n2) {
            SvnCommitPacket svnCommitPacket = ((SvnCodec$SVNCommitPacketWrapper)sVNCommitPacketArray[n2]).getPacket();
            object.add(svnCommitPacket);
        }
        for (n2 = 0; n2 < svnCommitPacketArray.length; ++n2) {
            if (object.contains(svnCommitPacketArray[n2])) continue;
            svnCommitPacketArray[n2].dispose();
        }
        SvnCommit svnCommit2 = svnCommit;
        svnCommit2.setIncludeDirectoryExternals(!this.isIgnoreExternals());
        svnCommit2.setIncludeFileExternals(!this.isIgnoreExternals());
        svnCommit2.setCommitMessage(string);
        svnCommit2.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        svnCommit2.setCommitParameters(SvnCodec.commitParameters(this.getCommitParameters()));
        if (sVNProperties != null) {
            for (String string2 : sVNProperties.nameSet()) {
                SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
                if (sVNPropertyValue == null) continue;
                svnCommit2.setRevisionProperty(string2, sVNPropertyValue);
            }
        }
        svnCommit2.setKeepLocks(bl2);
        svnCommit2.setKeepChangelists(bl3);
        svnCommit2.setReceiver(new SVNCommitClient$1(this, sVNCommitInfoArray));
        svnCommit2.run();
        return sVNCommitInfoArray;
    }

    public SVNCommitPacket doCollectCommitItems(File[] fileArray, boolean bl2, boolean bl3, boolean bl4) {
        SVNCommitPacket[] sVNCommitPacketArray = this.doCollectCommitItems(fileArray, bl2, bl3, SVNDepth.fromRecurse(bl4), true, null);
        if (sVNCommitPacketArray != null && sVNCommitPacketArray.length > 0) {
            return sVNCommitPacketArray[0];
        }
        return SVNCommitPacket.EMPTY;
    }

    public SVNCommitPacket doCollectCommitItems(File[] fileArray, boolean bl2, boolean bl3, SVNDepth sVNDepth, String[] stringArray) {
        SVNCommitPacket[] sVNCommitPacketArray = this.doCollectCommitItems(fileArray, bl2, bl3, sVNDepth, true, stringArray);
        if (sVNCommitPacketArray != null && sVNCommitPacketArray.length > 0) {
            return sVNCommitPacketArray[0];
        }
        return SVNCommitPacket.EMPTY;
    }

    public SVNCommitPacket[] doCollectCommitItems(File[] fileArray, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return this.doCollectCommitItems(fileArray, bl2, bl3, SVNDepth.fromRecurse(bl4), bl5, null);
    }

    public SVNCommitPacket[] doCollectCommitItems(File[] fileArray, boolean bl2, boolean bl3, SVNDepth sVNDepth, boolean bl4, String[] stringArray) {
        SvnCommitPacket svnCommitPacket;
        SvnCommit svnCommit = this.getOperationsFactory().createCommit();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            svnCommit.addTarget(SvnTarget.fromFile(fileArray[i2]));
        }
        svnCommit.setIncludeFileExternals(!this.isIgnoreExternals());
        svnCommit.setIncludeDirectoryExternals(!this.isIgnoreExternals());
        svnCommit.setKeepLocks(bl2);
        svnCommit.setDepth(sVNDepth);
        svnCommit.setForce(bl3);
        svnCommit.setFailOnMultipleRepositories(this.failOnMultipleRepositories);
        svnCommit.setCommitParameters(SvnCodec.commitParameters(this.getCommitParameters()));
        svnCommit.setCombinePackets(bl4);
        if (stringArray != null && stringArray.length > 0) {
            svnCommit.setApplicalbeChangelists(Arrays.asList(stringArray));
        }
        if ((svnCommitPacket = svnCommit.collectCommitItems()) != null) {
            SvnCommitPacket[] svnCommitPacketArray = svnCommit.splitCommitPackets(bl4);
            SVNCommitPacket[] sVNCommitPacketArray = new SVNCommitPacket[svnCommitPacketArray.length];
            for (int i3 = 0; i3 < svnCommitPacketArray.length; ++i3) {
                sVNCommitPacketArray[i3] = SvnCodec.commitPacket(svnCommit, svnCommitPacketArray[i3]);
            }
            return sVNCommitPacketArray;
        }
        return new SVNCommitPacket[0];
    }

    public void setFailOnMultipleRepositories(boolean bl2) {
        this.failOnMultipleRepositories = bl2;
    }
}

