/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc.admin.SVNAdminBasicClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNClientManager
implements ISVNRepositoryPool {
    private ISVNOptions myOptions;
    private SVNCommitClient myCommitClient;
    private SVNCopyClient myCopyClient;
    private SVNDiffClient myDiffClient;
    private SVNLogClient myLogClient;
    private SVNMoveClient myMoveClient;
    private SVNStatusClient myStatusClient;
    private SVNUpdateClient myUpdateClient;
    private SVNWCClient myWCClient;
    private SVNChangelistClient myChangelistClient;
    private SVNAdminClient myAdminClient;
    private SVNLookClient myLookClient;
    private ISVNEventHandler myEventHandler;
    private ISVNRepositoryPool myRepositoryPool;
    private ISVNDebugLog myDebugLog;
    private SvnOperationFactory myOperationFactory;
    private boolean myIsIgnoreExternals;

    private SVNClientManager(ISVNOptions iSVNOptions, ISVNRepositoryPool iSVNRepositoryPool) {
        this.myOptions = iSVNOptions;
        if (this.myOptions == null) {
            this.myOptions = SVNWCUtil.createDefaultOptions(true);
        }
        this.myRepositoryPool = iSVNRepositoryPool;
    }

    private SVNClientManager(ISVNOptions iSVNOptions, ISVNAuthenticationManager iSVNAuthenticationManager) {
        this(iSVNOptions, new DefaultSVNRepositoryPool(iSVNAuthenticationManager == null ? SVNWCUtil.createDefaultAuthenticationManager() : iSVNAuthenticationManager, iSVNOptions));
    }

    private SVNClientManager(SvnOperationFactory svnOperationFactory) {
        this.myOperationFactory = svnOperationFactory;
    }

    public static SVNClientManager newInstance() {
        return new SVNClientManager(null, (ISVNAuthenticationManager)null);
    }

    public static SVNClientManager newInstance(ISVNOptions iSVNOptions) {
        return new SVNClientManager(iSVNOptions, (ISVNAuthenticationManager)null);
    }

    public static SVNClientManager newInstance(ISVNOptions iSVNOptions, ISVNAuthenticationManager iSVNAuthenticationManager) {
        return new SVNClientManager(iSVNOptions, iSVNAuthenticationManager);
    }

    public static SVNClientManager newInstance(SvnOperationFactory svnOperationFactory) {
        return new SVNClientManager(svnOperationFactory);
    }

    public static SVNClientManager newInstance(ISVNOptions iSVNOptions, ISVNRepositoryPool iSVNRepositoryPool) {
        return new SVNClientManager(iSVNOptions, iSVNRepositoryPool);
    }

    public static SVNClientManager newInstance(DefaultSVNOptions defaultSVNOptions, String string, String string2) {
        boolean bl2 = defaultSVNOptions == null || defaultSVNOptions.isAuthStorageEnabled();
        ISVNAuthenticationManager iSVNAuthenticationManager = SVNWCUtil.createDefaultAuthenticationManager(null, string, string2, bl2);
        return new SVNClientManager((ISVNOptions)defaultSVNOptions, iSVNAuthenticationManager);
    }

    @Override
    public SVNRepository createRepository(SVNURL sVNURL, boolean bl2) {
        if (this.getRepositoryPool() != null) {
            return this.getRepositoryPool().createRepository(sVNURL, bl2);
        }
        SVNRepository sVNRepository = SVNRepositoryFactory.create(sVNURL);
        sVNRepository.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager());
        sVNRepository.setDebugLog(this.getDebugLog());
        return sVNRepository;
    }

    @Override
    public void shutdownConnections(boolean bl2) {
        if (this.getRepositoryPool() != null) {
            this.getRepositoryPool().dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.myOperationFactory != null) {
            this.myOperationFactory.dispose();
        } else if (this.myRepositoryPool != null) {
            this.myRepositoryPool.dispose();
        }
    }

    public ISVNOptions getOptions() {
        if (this.myOperationFactory != null) {
            return this.myOperationFactory.getOptions();
        }
        return this.myOptions;
    }

    public void setEventHandler(ISVNEventHandler iSVNEventHandler) {
        this.myEventHandler = iSVNEventHandler;
        this.setCanceller(iSVNEventHandler);
        if (this.myCommitClient != null) {
            this.myCommitClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myChangelistClient != null) {
            this.myChangelistClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myAdminClient != null) {
            this.myAdminClient.setEventHandler(iSVNEventHandler);
        }
        if (this.myLookClient != null) {
            this.myLookClient.setEventHandler(iSVNEventHandler);
        }
    }

    public void setIgnoreExternals(boolean bl2) {
        this.myIsIgnoreExternals = bl2;
        if (this.myCommitClient != null) {
            this.myCommitClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myChangelistClient != null) {
            this.myChangelistClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
    }

    public boolean isIgnoreExternals() {
        return this.myIsIgnoreExternals;
    }

    public void setOptions(ISVNOptions iSVNOptions) {
        if (this.myOperationFactory != null) {
            this.myOperationFactory.setOptions(iSVNOptions);
        } else {
            this.myOptions = iSVNOptions;
            if (this.myCommitClient != null) {
                this.myCommitClient.setOptions(iSVNOptions);
            }
            if (this.myCopyClient != null) {
                this.myCopyClient.setOptions(iSVNOptions);
            }
            if (this.myDiffClient != null) {
                this.myDiffClient.setOptions(iSVNOptions);
            }
            if (this.myLogClient != null) {
                this.myLogClient.setOptions(iSVNOptions);
            }
            if (this.myMoveClient != null) {
                this.myMoveClient.setOptions(iSVNOptions);
            }
            if (this.myStatusClient != null) {
                this.myStatusClient.setOptions(iSVNOptions);
            }
            if (this.myUpdateClient != null) {
                this.myUpdateClient.setOptions(iSVNOptions);
            }
            if (this.myWCClient != null) {
                this.myWCClient.setOptions(iSVNOptions);
            }
            if (this.myAdminClient != null) {
                this.myAdminClient.setOptions(iSVNOptions);
            }
            if (this.myLookClient != null) {
                this.myLookClient.setOptions(iSVNOptions);
            }
        }
    }

    public SVNCommitClient getCommitClient() {
        if (this.myCommitClient == null) {
            this.myCommitClient = this.myOperationFactory != null ? new SVNCommitClient(this.myOperationFactory) : new SVNCommitClient(this, this.myOptions);
            this.myCommitClient.setEventHandler(this.myEventHandler);
            this.myCommitClient.setDebugLog(this.getDebugLog());
            this.myCommitClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myCommitClient;
    }

    public SVNAdminClient getAdminClient() {
        if (this.myAdminClient == null) {
            this.myAdminClient = this.myOperationFactory != null ? new SVNAdminClient(this.myOperationFactory) : new SVNAdminClient(this, this.myOptions);
            this.initClientDefaults(this.myAdminClient);
        }
        return this.myAdminClient;
    }

    public SVNLookClient getLookClient() {
        if (this.myLookClient == null) {
            this.myLookClient = this.myOperationFactory != null ? new SVNLookClient(this.myOperationFactory) : new SVNLookClient(this, this.myOptions);
            this.initClientDefaults(this.myLookClient);
        }
        return this.myLookClient;
    }

    public SVNCopyClient getCopyClient() {
        if (this.myCopyClient == null) {
            this.myCopyClient = this.myOperationFactory != null ? new SVNCopyClient(this.myOperationFactory) : new SVNCopyClient(this, this.myOptions);
            this.initClientDefaults(this.myCopyClient);
        }
        return this.myCopyClient;
    }

    public SVNDiffClient getDiffClient() {
        if (this.myDiffClient == null) {
            this.myDiffClient = this.myOperationFactory != null ? new SVNDiffClient(this.myOperationFactory) : new SVNDiffClient(this, this.myOptions);
            this.initClientDefaults(this.myDiffClient);
        }
        return this.myDiffClient;
    }

    public SVNLogClient getLogClient() {
        if (this.myLogClient == null) {
            this.myLogClient = this.myOperationFactory != null ? new SVNLogClient(this.myOperationFactory) : new SVNLogClient(this, this.myOptions);
            this.initClientDefaults(this.myLogClient);
        }
        return this.myLogClient;
    }

    public SVNMoveClient getMoveClient() {
        if (this.myMoveClient == null) {
            this.myMoveClient = this.myOperationFactory != null ? new SVNMoveClient(this.myOperationFactory) : new SVNMoveClient(this, this.myOptions);
            this.initClientDefaults(this.myMoveClient);
        }
        return this.myMoveClient;
    }

    public SVNStatusClient getStatusClient() {
        if (this.myStatusClient == null) {
            this.myStatusClient = this.myOperationFactory != null ? new SVNStatusClient(this.myOperationFactory) : new SVNStatusClient(this, this.myOptions);
            this.initClientDefaults(this.myStatusClient);
        }
        return this.myStatusClient;
    }

    public SVNUpdateClient getUpdateClient() {
        if (this.myUpdateClient == null) {
            this.myUpdateClient = this.myOperationFactory != null ? new SVNUpdateClient(this.myOperationFactory) : new SVNUpdateClient(this, this.myOptions);
            this.initClientDefaults(this.myUpdateClient);
        }
        return this.myUpdateClient;
    }

    public SVNWCClient getWCClient() {
        if (this.myWCClient == null) {
            this.myWCClient = this.myOperationFactory != null ? new SVNWCClient(this.myOperationFactory) : new SVNWCClient(this, this.myOptions);
            this.initClientDefaults(this.myWCClient);
        }
        return this.myWCClient;
    }

    public SVNChangelistClient getChangelistClient() {
        if (this.myChangelistClient == null) {
            this.myChangelistClient = this.myOperationFactory != null ? new SVNChangelistClient(this.myOperationFactory) : new SVNChangelistClient(this, this.myOptions);
            this.initClientDefaults(this.myChangelistClient);
        }
        return this.myChangelistClient;
    }

    protected void initClientDefaults(SVNBasicClient sVNBasicClient) {
        sVNBasicClient.setEventHandler(this.myEventHandler);
        sVNBasicClient.setDebugLog(this.getDebugLog());
        sVNBasicClient.setIgnoreExternals(this.myIsIgnoreExternals);
    }

    protected void initClientDefaults(SVNAdminBasicClient sVNAdminBasicClient) {
        sVNAdminBasicClient.setEventHandler(this.myEventHandler);
        sVNAdminBasicClient.setDebugLog(this.getDebugLog());
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }

    @Override
    public void setDebugLog(ISVNDebugLog iSVNDebugLog) {
        this.myDebugLog = iSVNDebugLog;
        if (this.myCommitClient != null) {
            this.myCommitClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myChangelistClient != null) {
            this.myChangelistClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myAdminClient != null) {
            this.myAdminClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myLookClient != null) {
            this.myLookClient.setDebugLog(iSVNDebugLog);
        }
        if (this.myRepositoryPool != null) {
            this.myRepositoryPool.setDebugLog(iSVNDebugLog);
        }
    }

    @Override
    public void setAuthenticationManager(ISVNAuthenticationManager iSVNAuthenticationManager) {
        if (this.myOperationFactory != null) {
            this.myOperationFactory.setAuthenticationManager(iSVNAuthenticationManager);
        } else if (this.myRepositoryPool != null) {
            this.myRepositoryPool.setAuthenticationManager(iSVNAuthenticationManager);
        }
    }

    @Override
    public void setCanceller(ISVNCanceller iSVNCanceller) {
        if (this.myOperationFactory != null) {
            this.myOperationFactory.setCanceller(iSVNCanceller);
        } else if (this.myRepositoryPool != null) {
            this.myRepositoryPool.setCanceller(iSVNCanceller);
        }
    }

    public ISVNRepositoryPool getRepositoryPool() {
        if (this.myOperationFactory != null) {
            return this.myOperationFactory.getRepositoryPool();
        }
        return this.myRepositoryPool;
    }

    public SvnOperationFactory getOperationFactory() {
        return this.myOperationFactory;
    }
}

